<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Jenis_izin_m extends CI_Model
{
    var $table = 'master_jenis_izin';

    function get_datatables()
    {
        $this->_get_datatables_query();
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all()
    {
        $this->db->select("id_jenis_izin")->from($this->table);
        $this->db->where("id_company", $this->id_company);
        return $this->db->count_all_results();
    }
    private function _get_datatables_query()
    {
        $this->db->select("id_jenis_izin,kode_izin,nama,jenis_izin,flag,flag_kalender,flag_file,max_izin,back_date")->from($this->table);
        $this->db->where("id_company", $this->id_company);

        $column_search = array('kode_izin', 'nama');
        $i = 0;

        foreach ($column_search as $item) {  // looping awal
            if ($_GET['search']['value']) { // jika datatable mengirimkan pencarian dengan metode POST

                if ($i === 0) { // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                } else {
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if (count($column_search) - 1 == $i) {
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('', 'kode_izin', 'nama', 'jenis_izin', 'max_izin', 'flag');

        if (isset($_GET['order'])) {
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } else {
            $order_by = array("id_jenis_izin" => "DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id = null)
    {
        $select = $this->db->select('
                id_jenis_izin,
                kode_izin,
                nama,
                jenis_izin,
                flag,
                flag_kalender,
                flag_file,
                max_izin,
                back_date
            ')
            ->from($this->table)
            ->where('id_company', $this->id_company)
            ->where('md5(id_jenis_izin)', $id)
            ->get()
            ->row();
        return $select;
    }

    public function save($data, $id = null, $kd_jenis_izin_old = null)
    {
        $kode_ready = ["H", "T", "A", "L"];
        $nama_kode = ["H" => "Hadir", "T" => "Terlambat", "A" => "Alpha", "L" => "Libur"];
        $kode = $data['kode_izin'];
        if ($id != null) {

            $data['user_update'] = $this->nik_karyawan." - ".$this->nm_karyawan;
            $data['tgl_update']  = date('Y-m-d h:i:s');

            $sql = "SELECT kode_izin
                    FROM master_jenis_izin
                    WHERE kode_izin = ?
                    AND md5(id_jenis_izin) != ?
                    AND id_company = ?";
            $cek_kode = $this->db->query($sql, array($kode, $id, $this->id_company));
            if ($cek_kode->num_rows() > 0) {
                $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('error_kode_digunakan') . '</font>');
                return __response_update(false, $message);
            } else {
                if (in_array($kode, $kode_ready)) {
                    $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . ucwords(strtolower($this->lang->line('kode'))) . ' ' . $kode . $this->lang->line('error_simpan_jenis_izin') . $nama_kode[$kode] . '</font>');
                    return __response_update(false, $message);
                } else {
                    $this->db->trans_start();

                    # CEK KODE IZIN YANG SUDAH DIGUNAKAN DI DATA IZIN
                    $this->db->select("id_izin");
                    $this->db->where("kode_izin", $kd_jenis_izin_old);
                    $this->db->where("id_company", $this->id_company);
                    $this->db->from("data_izin");
                    $data_izin = $this->db->get();

                    if ($data_izin->num_rows() > 0) {

                        #UPDATE KODE IZIN PADA DATA IZIN
                        $this->db->where(array('kode_izin' => $kd_jenis_izin_old, 'status' => '1', 'id_company' => $this->id_company));
                        $this->db->update("data_izin", array('kode_izin' => $data['kode_izin']));
                    }

                    # UPDATE KODE IZIN PADA MASTER JENIS IZIN
                    $this->db->where(array('md5(id_jenis_izin)' => $id, 'id_company' => $this->id_company));
                    $this->db->update($this->table, $data);

                    $this->logger->create_log('master_jenis_izin', 'edit', $this->db->last_query());

                    $this->db->trans_complete();

                    if ($this->db->trans_status() === FALSE) {
                        $this->db->trans_rollback();
                        return __response_update(false);
                    } else {
                        $this->db->trans_commit();
                        return __response_update(true);
                    }
                }
            }
        } else {
            $data['user_input'] = $this->nik_karyawan." - ".$this->nm_karyawan;
            
            $sql = "SELECT kode_izin
                    FROM master_jenis_izin
                    WHERE kode_izin = ?
                    AND id_company = ?";
            $cek_kode = $this->db->query($sql, array($kode, $this->id_company));
            if ($cek_kode->num_rows() > 0) {
                $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('error_kode_digunakan') . '</font>');
                return __response_save(false, $message);
            } else {
                if (in_array($kode, $kode_ready)) {
                    $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . ucwords(strtolower($this->lang->line('kode'))) . ' ' . $kode . $this->lang->line('error_simpan_jenis_izin') . $nama_kode[$kode] . '</font>');
                    return __response_save(false, $message);
                } else {
                    $nextId = $this->fungsi->getNextId($this->table, 'id_jenis_izin', $this->id_company, 3);
                    $id_jenis_izin = array('id_jenis_izin' => $nextId);
                    $save = $this->db->insert($this->table, array_merge($data, $id_jenis_izin));

                    return __response_save($save);
                }
            }
        }
    }

    public function delete($id = null)
    {
        $this->db->select("kode_izin");
        $this->db->where("id_company", $this->id_company);
        $this->db->where("md5(id_jenis_izin)", $id);
        $this->db->from("master_jenis_izin");
        $kode_izin = $this->db->get()->row()->kode_izin;

        $this->db->select("id_izin");
        $this->db->where("id_company", $this->id_company);
        $this->db->where("status", "1");
        $this->db->where("kode_izin", $kode_izin);
        $this->db->from("data_izin");
        $cek_data = $this->db->get()->num_rows();

        if ($cek_data > 0) {
            $message = '<font color="#ffffff"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('error_hapus_jenis_izin') . '</font>';
            return __response_delete(false, ["message" => $message]);
        } else {
            $this->db->where('md5(id_jenis_izin)', $id);
            $this->db->where('id_company', $this->id_company);
            $delete = $this->db->delete($this->table);
            $this->logger->create_log('master_jenis_izin', 'delete', $this->db->last_query());
            return  __response_delete($delete);
        }
    }
}
