<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Payroll_bpjs extends CI_Migration {

        public function up()
        {       //create table payroll_bpjs_tk_config
                $this->dbforge->add_field("tunj_jht_perus decimal(3,2) not null default 0.00 comment 'default 3.70'");
                $this->dbforge->add_field("pot_jht_kry decimal(3,2) not null default 0.00 comment 'default 2.00'");
                $this->dbforge->add_field("tunj_jkk decimal(3,2) not null default 0.00 comment 'default 0.24'");
                $this->dbforge->add_field("tunj_jp_perus decimal(3,2) not null default 0.00 comment 'default 2.00'");
                $this->dbforge->add_field("pot_jp_kry decimal(3,2) not null default 0.00 comment 'default 1.00'");
                $this->dbforge->add_field("tunj_jkm decimal(3,2) not null default 0.00 comment 'default 3.00'");
                $this->dbforge->create_table('payroll_bpjs_tk_config');

                $data = array(
                        'tunj_jht_perus' => 3.70,
                        'pot_jht_kry'    => 2.00,
                        'tunj_jkk'       => 0.24,
                        'tunj_jp_perus'  => 2.00,
                        'pot_jp_kry'     => 1.00,
                        'tunj_jkm'       => 3.00
                );

                $this->db->insert('payroll_bpjs_tk_config', $data);

                //create table payroll_bpjs_tk_comp_p
                $this->dbforge->add_field("id_company varchar(20) not null default 1");
                $this->dbforge->add_field("tunj_jht_perus decimal(3,2) not null default 0.00");
                $this->dbforge->add_field("pot_jht_kry decimal(3,2) not null default 0.00");
                $this->dbforge->add_field("flag_jht enum('0','1') NOT NULL DEFAULT '0'");
                $this->dbforge->add_field("tunj_jkk decimal(3,2) not null default 0.00");
                $this->dbforge->add_field("flag_jkk enum('0','1') NOT NULL DEFAULT '0'");
                $this->dbforge->add_field("tunj_jp_perus decimal(3,2) not null default 0.00");
                $this->dbforge->add_field("pot_jp_kry decimal(3,2) not null default 0.00");
                $this->dbforge->add_field("flag_jp enum('0','1') NOT NULL DEFAULT '0'");
                $this->dbforge->add_field("tunj_jkm decimal(3,2) not null default 0.00");
                $this->dbforge->add_field("flag_jkm enum('0','1') NOT NULL DEFAULT '0'");
                $this->dbforge->add_field("user_input varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan'");
                $this->dbforge->add_field("tgl_input timestamp NOT NULL DEFAULT current_timestamp()");
                $this->dbforge->add_field("user_update varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan'");
                $this->dbforge->add_field("tgl_update timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'");
                $this->dbforge->create_table('payroll_bpjs_tk_comp_p');
                //set primary key
                $this->db->query("ALTER TABLE payroll_bpjs_tk_comp_p ADD PRIMARY KEY(id_company)");

                //create table payroll_bpjs_tk_m
                $this->dbforge->add_field("id_karyawan varchar(50) not null");
                $this->dbforge->add_field("ttl_gaji_terdaftar int not null default 0 comment 'total gaji yang didatarkan'");
                $this->dbforge->add_field("tunj_jht_perus_persen decimal(3,2) not null default 0.00");
                $this->dbforge->add_field("tunj_jht_perus_rp decimal(8,2) not null default 0.00");
                $this->dbforge->add_field("pot_jht_kry_persen decimal(3,2) not null default 0.00");
                $this->dbforge->add_field("pot_jht_kry_rp decimal(8,2) not null default 0.00");
                $this->dbforge->add_field("flag_jht enum('0','1') NOT NULL DEFAULT '0'");
                $this->dbforge->add_field("tunj_jkk_persen decimal(3,2) not null default 0.00");
                $this->dbforge->add_field("tunj_jkk_rp decimal(8,2) not null default 0.00");
                $this->dbforge->add_field("flag_jkk enum('0','1') NOT NULL DEFAULT '0'");
                $this->dbforge->add_field("tunj_jp_perus_persen decimal(3,2) not null default 0.00");
                $this->dbforge->add_field("tunj_jp_perus_rp decimal(8,2) not null default 0.00");
                $this->dbforge->add_field("pot_jp_kry_persen decimal(3,2) not null default 0.00");
                $this->dbforge->add_field("pot_jp_kry_rp decimal(8,2) not null default 0.00");
                $this->dbforge->add_field("flag_jp enum('0','1') NOT NULL DEFAULT '0'");
                $this->dbforge->add_field("tunj_jkm_persen decimal(3,2) not null default 0.00");
                $this->dbforge->add_field("tunj_jkm_rp decimal(8,2) not null default 0.00");
                $this->dbforge->add_field("flag_jkm enum('0','1') NOT NULL DEFAULT '0'");
                $this->dbforge->add_field("ttl_pot_karyawan decimal(9,2) not null default 0.00");
                $this->dbforge->add_field("ttl_tunj_dibiayai_perus decimal(9,2) not null default 0.00");
                $this->dbforge->add_field("id_company varchar(20) not null default 1");
                $this->dbforge->add_field("user_input varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan'");
                $this->dbforge->add_field("tgl_input timestamp NOT NULL DEFAULT current_timestamp()");
                $this->dbforge->add_field("user_update varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan'");
                $this->dbforge->add_field("tgl_update timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'");
                $this->dbforge->create_table('payroll_bpjs_tk_m');
                //set primary key
                $this->db->query("ALTER TABLE payroll_bpjs_tk_m ADD PRIMARY KEY(id_karyawan, id_company)");

                //create table payroll_bpjs_tk_trx
                $this->dbforge->add_field("id_karyawan varchar(50) not null");
                $this->dbforge->add_field("periode varchar(7) not null default '' comment 'format yyyy-mm'");
                $this->dbforge->add_field("ttl_gaji_terdaftar int not null default 0 comment 'total gaji yang didatarkan'");
                $this->dbforge->add_field("tunj_jht_perus_persen decimal(3,2) not null default 0.00");
                $this->dbforge->add_field("tunj_jht_perus_rp decimal(8,2) not null default 0.00");
                $this->dbforge->add_field("pot_jht_kry_persen decimal(3,2) not null default 0.00");
                $this->dbforge->add_field("pot_jht_kry_rp decimal(8,2) not null default 0.00");
                $this->dbforge->add_field("flag_jht enum('0','1') NOT NULL DEFAULT '0'");
                $this->dbforge->add_field("tunj_jkk_persen decimal(3,2) not null default 0.00");
                $this->dbforge->add_field("tunj_jkk_rp decimal(8,2) not null default 0.00");
                $this->dbforge->add_field("flag_jkk enum('0','1') NOT NULL DEFAULT '0'");
                $this->dbforge->add_field("tunj_jp_perus_persen decimal(3,2) not null default 0.00");
                $this->dbforge->add_field("tunj_jp_perus_rp decimal(8,2) not null default 0.00");
                $this->dbforge->add_field("pot_jp_kry_persen decimal(3,2) not null default 0.00");
                $this->dbforge->add_field("pot_jp_kry_rp decimal(8,2) not null default 0.00");
                $this->dbforge->add_field("flag_jp enum('0','1') NOT NULL DEFAULT '0'");
                $this->dbforge->add_field("tunj_jkm_persen decimal(3,2) not null default 0.00");
                $this->dbforge->add_field("tunj_jkm_rp decimal(8,2) not null default 0.00");
                $this->dbforge->add_field("flag_jkm enum('0','1') NOT NULL DEFAULT '0'");
                $this->dbforge->add_field("id_company varchar(20) not null default 1");
                $this->dbforge->add_field("user_input varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan'");
                $this->dbforge->add_field("tgl_input timestamp NOT NULL DEFAULT current_timestamp()");
                $this->dbforge->add_field("user_update varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan'");
                $this->dbforge->add_field("tgl_update timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'");
                $this->dbforge->create_table('payroll_bpjs_tk_trx');
                //set primary key
                $this->db->query("ALTER TABLE payroll_bpjs_tk_trx ADD PRIMARY KEY(id_karyawan, periode, id_company)");

                //create payroll_bpjs_kes_config
                $this->dbforge->add_field("tunj_perus decimal(3,2) not null default 0.00 COMMENT '4.00'");
                $this->dbforge->add_field("pot_kry decimal(3,2) not null default 0.00 COMMENT '1.00'");
                $this->dbforge->add_field("pot_tambahan_kry decimal(3,2) not null default 0.00 COMMENT '1.00'");
                $this->dbforge->create_table('payroll_bpjs_kes_config');

                $data = array(
                        'tunj_perus'       => 4.00,
                        'pot_kry'          => 1.00,
                        'pot_tambahan_kry' => 1.00
                );
                $this->db->insert('payroll_bpjs_kes_config', $data);

                //create table payroll_bpjs_kes_comp_p
                $this->dbforge->add_field("id_company varchar(20) not null default ''");
                $this->dbforge->add_field("flag enum('0','1') NOT NULL DEFAULT '0'");
                $this->dbforge->add_field("tunj_perus decimal(3,2) not null default 0.00 COMMENT '4.00'");
                $this->dbforge->add_field("pot_kry decimal(3,2) not null default 0.00 COMMENT '1.00'");
                $this->dbforge->add_field("pot_tambahan_kry decimal(3,2) not null default 0.00 COMMENT '1.00'");
                $this->dbforge->add_field("user_input varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan'");
                $this->dbforge->add_field("tgl_input timestamp NOT NULL DEFAULT current_timestamp()");
                $this->dbforge->add_field("user_update varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan'");
                $this->dbforge->add_field("tgl_update timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'");
                $this->dbforge->create_table('payroll_bpjs_kes_comp_p');
                //set primary key
                $this->db->query("ALTER TABLE payroll_bpjs_kes_comp_p ADD PRIMARY KEY(id_company)");

                //create table payroll_bpjs_kes_m
                $this->dbforge->add_field("id_karyawan varchar(50) not null");
                $this->dbforge->add_field("flag enum('0','1') NOT NULL DEFAULT '0'");
                $this->dbforge->add_field("jml_anak tinyint(2) not null default 0");
                $this->dbforge->add_field("ttl_gaji_terdaftar int not null default 0 comment 'total gaji yang didatarkan'");
                $this->dbforge->add_field("tunj_perus_persen decimal(3,2) not null default 0.00 COMMENT '4.00'");
                $this->dbforge->add_field("tunj_perus_rp decimal(8,2) not null default 0.00");
                $this->dbforge->add_field("pot_kry_persen decimal(3,2) not null default 0.00 COMMENT '1.00'");
                $this->dbforge->add_field("pot_kry_rp decimal(8,2) not null default 0.00");
                $this->dbforge->add_field("id_company varchar(20) not null default ''");
                $this->dbforge->add_field("user_input varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan'");
                $this->dbforge->add_field("tgl_input timestamp NOT NULL DEFAULT current_timestamp()");
                $this->dbforge->add_field("user_update varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan'");
                $this->dbforge->add_field("tgl_update timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'");
                $this->dbforge->create_table('payroll_bpjs_kes_m');
                //set primary key
                $this->db->query("ALTER TABLE payroll_bpjs_kes_m ADD PRIMARY KEY(id_karyawan, id_company)");
        }

        public function down()
        {
                $this->dbforge->drop_table('payroll_bpjs_tk_config');
                $this->dbforge->drop_table('payroll_bpjs_tk_comp_p');
                $this->dbforge->drop_table('payroll_bpjs_tk_m');
                $this->dbforge->drop_table('payroll_bpjs_tk_trx');
                $this->dbforge->drop_table('payroll_bpjs_kes_config');
                $this->dbforge->drop_table('payroll_bpjs_kes_comp_p');
                $this->dbforge->drop_table('payroll_bpjs_kes_m');
        }
}