<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Sales_activity extends MY_Controller
{
    public function index()
    {
        $data['judul'] = $this->lang->line('sales_monitoring');
        $data['aktif'] = 'sales_activity';
        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('sales_activity/index', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function list_data($tab, $params = null)
    {
        switch ($tab) {
            case 'pengaturan':
                $this->list_pengaturan($params);
                break;

            case 'master':
                $this->list_master($params);
                break;

            default:
                $this->list_dashboard();
                break;
        }
    }

    private function list_dashboard()
    {
        //
    }

    private function list_master($params)
    {
        dd();
    }

    private function list_pengaturan($params)
    {
        //
    }


    public function get_target_harian_bulanan(){
        $hari_ini  = date('Y-m-d');
        $bulan_ini = date('Y-m');

        $poin_harian = $this->db->select('
                sa.id_karyawan,
                IF(stpt.poin IS NULL, 0, stpt.poin) AS poin_target,
                IF(spa.poin IS NULL, 0, SUM(spa.poin)) AS realisasi_poin
            ')
            ->from('sales_approver AS sa')
            ->join('sales_target_poin_trx AS stpt', 'stpt.id_karyawan = sa.id_karyawan AND stpt.tgl_trx = "'.$hari_ini.'" ', 'LEFT')
            ->join('sales_pipeline_activity AS spa', 
                'spa.id_karyawan = sa.id_karyawan 
                    AND spa.tgl_activity = "'.$hari_ini.'"
                '
                , 'LEFT')
            ->where('sa.id_karyawan', $this->id_karyawan)
            ->where('sa.id_company', $this->id_company)
            ->group_by('sa.id_karyawan')
            ->get()
            ->row();

        $poin_bulanan = $this->db->select('
                sa.id_karyawan,
                (
                    SELECT SUM(stpt.poin)
                    FROM sales_target_poin_trx AS stpt
                    WHERE stpt.id_karyawan = sa.id_karyawan
                    AND DATE_FORMAT(stpt.tgl_trx, "%Y-%m") = "'.$bulan_ini.'"
                ) AS poin_target,
                (
                    SELECT SUM(spa.poin)
                    FROM sales_pipeline_activity AS spa
                    WHERE spa.id_karyawan = sa.id_karyawan
                    AND DATE_FORMAT(spa.tgl_activity, "%Y-%m") = "'.$bulan_ini.'"
                    AND spa.status = "approve"
                ) AS realisasi_poin
            ')
            ->from('sales_approver AS sa')
            ->where('sa.id_karyawan', $this->id_karyawan)
            ->where('sa.id_company', $this->id_company)
            ->get()
            ->row();

        $data = [
            'poin_harian' => [
                'target'    => (float) $poin_harian->poin_target,
                'realisasi' => (float) $poin_harian->realisasi_poin,
            ],
            'poin_bulanan' => [
                'target'    => (float) $poin_bulanan->poin_target,
                'realisasi' => (float) $poin_bulanan->realisasi_poin,
            ],
        ];

        echo json_encode($data);
   }

}
