<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Reminder_absensi extends CI_Controller {

    public function index($jam_mulai, $jam_selesai)
    {
        // reminder company aktif absensi jam kerja tidak libur dan tidak di hari libur nasional
        $this->load->database('payroll');
        
        $this->db->select('master_plan.id_company, 
                            notif_absensi_p.absensi_masuk_sebelum_flag, 
                            notif_absensi_p.absensi_masuk_sebelum_menit, 
                            notif_absensi_p.absensi_masuk_setelah_flag, 
                            notif_absensi_p.absensi_masuk_setelah_menit, 
                            notif_absensi_p.absensi_pulang_setelah_flag,
                            notif_absensi_p.absensi_pulang_setelah_menit');
        $this->db->from('master_plan');
        $this->db->join('notif_absensi_p', 'notif_absensi_p.id_company = master_plan.id_company');
        $this->db->where('master_plan.tgl_berakhir >', date('Y-m-d'));
        $this->db->group_start();
        $this->db->where('notif_absensi_p.absensi_masuk_sebelum_flag', '1');
        $this->db->or_where('notif_absensi_p.absensi_masuk_setelah_flag', '1');
        $this->db->or_where('notif_absensi_p.absensi_pulang_setelah_flag', '1');
        $this->db->group_end();
        $data = $this->db->get();
        if($data->num_rows() > 0) {
            foreach($data->result() as $row) {
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $this->config->item('url_mb').'/queue_reminder_absensi');
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_POST, 1);
                // curl_setopt($ch, CURLOPT_VERBOSE, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
                    'id_company'           => $row->id_company,
                    'sebelum_masuk'        => $row->absensi_masuk_sebelum_flag,
                    'sebelum_masuk_menit'  => $row->absensi_masuk_sebelum_menit,
                    'setelah_masuk'        => $row->absensi_masuk_setelah_flag,
                    'setelah_masuk_menit'  => $row->absensi_masuk_setelah_menit,
                    'setelah_pulang'       => $row->absensi_pulang_setelah_flag,
                    'setelah_pulang_menit' => $row->absensi_pulang_setelah_menit,
                    'jam_mulai'            => $jam_mulai,
                    'jam_selesai'          => $jam_selesai,
                    'notif'                => 'profesional'
                ]));
    
                $output = curl_exec($ch);
                echo $row->id_company." : ".$output."\n";
                curl_close($ch); 
            }
        } else {
            echo "tidak ada data";
        }
    }

    public function testing() {
        $this->load->database('payroll');

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'http://localhost:3007/queue_reminder_absensi');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
            'id_company'           => '202100001',
            'sebelum_masuk'        => '1',
            'sebelum_masuk_menit'  => 0,
            'setelah_masuk'        => '0',
            'setelah_masuk_menit'  => 0,
            'setelah_pulang'       => '0',
            'setelah_pulang_menit' => 0,
            'jam_mulai'            => '14:30:00',
            'jam_selesai'          => '14:50:00',
            'notif'                => 'profesional'
        ]));
        curl_setopt($ch, CURLOPT_USERAGENT, 'PROFESIONAL');
        $output = curl_exec($ch);
        echo $row->id_company." : ".$output."\n";
        curl_close($ch); 
    }
}
