<script type="text/javascript">
    $(function() {
        $(".numberbox").keydown(function (e) {
            // Allow: backspace, delete, tab, escape, enter and
            if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110]) !== -1 ||
                // Allow: Ctrl+A
                (e.keyCode == 65 && e.ctrlKey === true) ||
                // Allow: home, end, left, right, down, up
                (e.keyCode >= 35 && e.keyCode <= 40)) {
                    // let it happen, don't do anything
                    return;
            }
            // Ensure that it is a number and stop the keypress
            if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
                e.preventDefault();
                $("#jumlah_barang").focus();
                return false();
            }
        });

        $(document).on('click', '.btn_edit', function() {
            var form_name = "#" + $(this).attr("form-data");

            $(form_name + " input:radio").attr('disabled', false);
            $(form_name + " #label").removeClass('disabled');
            $(form_name + " .btn_batal").show();
            $(form_name + " .btn_save").show();
            $(form_name + " .btn_edit").hide();
            $(form_name + " #message").html("");
        });

        $(document).on('click', '.btn_batal', function() {
            var form_name = "#" + $(this).attr("form-data");
            value = $(form_name + " #value_lama").val();
            if (form_name == "#form_locklokasi") {
                if (value == "0") {
                    $('input[name="lock_lokasi"][value="0"]').prop('checked', true);
                } else {
                    $('input[name="lock_lokasi"][value="1"]').prop('checked', true);
                }
            } else if (form_name == "#form_lockdevice") {
                if (value == "0") {
                    $('input[name="lock_device"][value="0"]').prop('checked', true);
                } else {
                    $('input[name="lock_device"][value="1"]').prop('checked', true);
                }
            } else {
                if (value == "0") {
                    $('input[name="lock_facerecognition"][value="0"]').prop('checked', true);
                } else {
                    $('input[name="lock_facerecognition"][value="1"]').prop('checked', true);
                }
            }

            $(form_name + " #message").html("");
            $(form_name + " input:radio").attr('disabled', true);
            $(form_name + " #label").addClass('disabled');
            $(form_name + " .btn_batal").hide();
            $(form_name + " .btn_save").hide();
            $(form_name + " .btn_edit").show();
        });


        $(document).on("click", ".btn_save", function(e) {
            e.preventDefault();

            var form_name = "#" + $(this).attr("form-data");
            var status = $(form_name + " input[type='radio']:checked").val();
            $(form_name + " #message").html("");

            var loading = Ladda.create(this);
            loading.start();

            var params = "jenis_form=" + form_name +
                        "&status=" + status;

            $.ajax({
                type: 'POST',
                url: "<?= route('pengaturan.umum.save') ?>",
                data: params,
                dataType: 'JSON',
                success: function(result) {
                    if (result.success == true) {
                        $(form_name + " input:radio").attr('disabled', true);
                        $(form_name + " #label").addClass('disabled');
                        $(form_name + " .btn_batal").hide();
                        $(form_name + " .btn_save").hide();
                        $(form_name + " .btn_edit").show();
                        $(form_name + " #value_lama").val(status);
                    }

                    loading.stop();

                    $(form_name + " #message").show();
                    $(form_name + " #message").html(result.message);
                },
                error: function() {
                    loading.stop();
                    $(form_name + " #message").show();
                    $(form_name + " #message").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });


        $(document).on("click", ".btn_save_cuti", function(e) {
            e.preventDefault();
            $("#modal_cuti #modal_close").hide();
            $("#modal_cuti .card-footer").show();

            var form_name = $(this).attr("form-data");
            $("#"+form_name +" #message").text("");

            var option = 0;
            var jml_cuti = $("#"+form_name +" #jml_cuti").val();

            if(jml_cuti ==""){
                $("#"+form_name +" #message").html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Jumlah cuti belum diisi</font>");
                $("#"+form_name +" #message").focus();
                return false;
            }

            if(form_name == "form_resetcuti"){
                var status = "reset";
                var title = "Seluruh karyawan tetap sisa cuti tahunannya akan di <b class='text-danger'>RESET menjadi "+jml_cuti+"</b>, apakah Anda yakin?";
            }else{
                var status = "update";
                var option = $("#"+form_name +" #option").val();
                var redaksional = $("#"+form_name +" option:selected").attr('redaksional');
                var title = "Seluruh karyawan tetap sisa cuti tahunannya akan <b class='text-danger'>"+redaksional+" "+jml_cuti+"</b>, apakah Anda yakin?";
            }
            $('#modal_cuti .title').html(title);

            $('#modal_cuti #status').val(status);
            $('#modal_cuti #option').val(option);
            $('#modal_cuti #jml_cuti').val(jml_cuti);
            $('#modal_cuti').modal('show');
        });

        $(document).on("click", "#btn_confrim_cuti", function(e) {
            e.preventDefault();

            $("#modal_cuti #message").html("");
            var status = $("#modal_cuti #status").val();
            var option = $("#modal_cuti #option").val();
            var jml_cuti = $("#modal_cuti #jml_cuti").val();

            var loading = Ladda.create(this);
            loading.start();

            var params = "status=" + status +
                        "&option=" + option +
                        "&jml_cuti=" + jml_cuti;

            $.ajax({
                type: 'POST',
                url: "<?= route('pengaturan.umum.save.cuti') ?>",
                data: params,
                dataType: 'JSON',
                success: function(result) {
                    if(result.success == true) {
                        $("#modal_cuti #modal_close").show();
                        $("#modal_cuti .card-footer").hide();
                        $("#modal_cuti .title").html(result.message);
                    }

                    loading.stop();

                    $("#modal_cuti #message").show();
                    $("#modal_cuti #message").html(result.message);
                },
                error: function() {
                    loading.stop();
                    $("#modal_cuti #message").show();
                    $("#modal_cuti #message").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });

    });
</script>

<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        </li>
                        <li class="breadcrumb-item"><a href="#">Pengaturan</a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div id="form_resetcuti" class="col-md-4">
        <div class="card card-rounded">
            <div class="card-content">
                <div class="card-header">
                    <h5>
                        Jumlah Cuti Untuk Satu Tahun
                        <i class="text-primary fa fa-question-circle-o fa-lg" data-toggle="tooltip" & data-placement="top" data-original-title="<?= $tooltip_reset_cuti ?>"></i>
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="custom-radio-blue">
                                <section class="light">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <input type="text" id="jml_cuti" class="form-control numberbox">
                                        </div>
                                    </div>
                                </section>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer card-footer-rounded">
                    <button form-data="form_resetcuti" class="btn_save_cuti btn btn-primary ladda-button" data-style="expand-left"><i class="fa fa-save "> </i> SIMPAN</button>
                    <label id="message"></label>
                </div>
            </div>
        </div>
    </div>

    <div id="form_updatecuti" class="col-md-4">
        <div class="card card-rounded">
            <div class="card-content">
                <div class="card-header">
                    <h5>
                        Update cuti
                        <i class="text-primary fa fa-question-circle-o fa-lg" data-toggle="tooltip" & data-placement="top" data-original-title="<?= $tooltip_update_cuti ?>"></i>
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="custom-radio-blue">
                                <div class="row">
                                    <div class="col-md-4">
                                        <select id="option" class="form-control">
                                            <option value="tambah" redaksional="DITAMBAH">TAMBAH</option>
                                            <option value="kurang" redaksional="DIKURANGI">KURANG</option>
                                        </select>
                                    </div>
                                    <div class="col-md-8">
                                        <input type="text" id="jml_cuti" class="form-control numberbox">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer card-footer-rounded">
                    <button form-data="form_updatecuti" class="btn_save_cuti btn btn-primary ladda-button" data-style="expand-left"><i class="fa fa-save "> </i> SIMPAN</button>
                    <label id="message"></label>
                </div>
            </div>
        </div>
    </div>

    <div id="form_tukarshift" class="col-md-4 <?= ((isset($pengaturan_shift)) ? "" : "hidden") ?>">
        <div class="card card-rounded">
            <div class="card-content">
                <div class="card-header">
                    <h5>
                        Izinkan karyawan tukar shift
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <input type="hidden" id="value_lama" value="<?= $pengaturan_shift->aktif ?>">
                            <div class="custom-radio-blue">
                                <section class="light">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <label id="label" class="disabled">
                                                <input type="radio" name="pengaturan_shift" value="0" <?= ((isset($pengaturan_shift) && $pengaturan_shift->aktif == "0") ? "checked" : "") ?> disabled>
                                                <span class="design"></span>
                                                <span class="text">Tidak</span>
                                            </label>
                                        </div>
                                        <div class="col-md-6">
                                            <label id="label" class="disabled">
                                                <input type="radio" name="pengaturan_shift" value="1" <?= ((isset($pengaturan_shift) && $pengaturan_shift->aktif == "1") ? "checked" : "") ?> disabled>
                                                <span class="design"></span>
                                                <span class="text">Ya</span>
                                            </label>
                                        </div>
                                    </div>
                                </section>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer card-footer-rounded">
                    <button class="btn_batal btn btn-secondary" form-data="form_tukarshift" style="display:none"><i class="fa fa-close"> </i> BATAL</button>
                    <button class="btn_save btn btn-primary ladda-button" data-style="expand-left" form-data="form_tukarshift" style="display:none"><i class="fa fa-save "> </i> SIMPAN</button>
                    <button class="btn_edit btn btn-warning" form-data="form_tukarshift"><i class="fa fa-edit (alias) "> </i> EDIT</button>
                    <label id="message"></label>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div id="form_locklokasi" class="col-md-4">
        <div class="card card-rounded">
            <div class="card-content">
                <div class="card-header">
                    <h5>
                        Lock Lokasi Absensi Semua Karyawan
                        <i class="text-primary fa fa-question-circle-o fa-lg" data-toggle="tooltip" & data-placement="top" data-original-title="<?= $tooltip_lock_lokasi ?>"></i>
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <input type="hidden" id="value_lama" value="<?= $data->lock_lokasi ?>">
                            <div class="custom-radio-blue">
                                <section class="light">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <label id="label" class="disabled">
                                                <input type="radio" name="lock_lokasi" value="0" <?= ((isset($data) && $data->lock_lokasi == "0") ? "checked" : "") ?> disabled>
                                                <span class="design"></span>
                                                <span class="text">Tidak</span>
                                            </label>
                                        </div>
                                        <div class="col-md-6">
                                            <label id="label" class="disabled">
                                                <input type="radio" name="lock_lokasi" value="1" <?= ((isset($data) && $data->lock_lokasi == "1") ? "checked" : "") ?> disabled>
                                                <span class="design"></span>
                                                <span class="text">Ya</span>
                                            </label>
                                        </div>
                                    </div>
                                </section>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer card-footer-rounded">
                    <button class="btn_batal btn btn-secondary" form-data="form_locklokasi" style="display:none"><i class="fa fa-close"> </i> BATAL</button>
                    <button class="btn_save btn btn-primary ladda-button" data-style="expand-left" form-data="form_locklokasi" style="display:none"><i class="fa fa-save "> </i> SIMPAN</button>
                    <button class="btn_edit btn btn-warning" form-data="form_locklokasi"><i class="fa fa-edit (alias) "> </i> EDIT</button>
                    <label id="message"></label>
                </div>

            </div>
        </div>
    </div>

    <div id="form_lockdevice" class="col-md-4">
        <div class="card card-rounded">
            <div class="card-content">
                <div class="card-header">
                    <h5>
                        Lock Device Semua Karyawan
                        <i class="text-primary fa fa-question-circle-o fa-lg" data-toggle="tooltip" & data-placement="top" data-original-title="<?= $tooltip_lock_device ?>"></i>
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <input type="hidden" id="value_lama" value="<?= $data->lock_device ?>">
                            <div class="custom-radio-blue">
                                <section class="light">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <label id="label" class="disabled">
                                                <input type="radio" name="lock_device" value="0" <?= ((isset($data) && $data->lock_device == "0") ? "checked" : "") ?> disabled>
                                                <span class="design"></span>
                                                <span class="text">Tidak</span>
                                            </label>
                                        </div>
                                        <div class="col-md-6">
                                            <label id="label" class="disabled">
                                                <input type="radio" name="lock_device" value="1" <?= ((isset($data) && $data->lock_device == "1") ? "checked" : "") ?> disabled>
                                                <span class="design"></span>
                                                <span class="text">Ya</span>
                                            </label>
                                        </div>
                                    </div>
                                </section>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer card-footer-rounded">
                    <button class="btn_batal btn btn-secondary" form-data="form_lockdevice" style="display:none"><i class="fa fa-batal "> </i> BATAL</button>
                    <button class="btn_save btn btn-primary ladda-button" data-style="expand-left" form-data="form_lockdevice" style="display:none"><i class="fa fa-save "> </i> SIMPAN</button>
                    <button class="btn_edit btn btn-warning" form-data="form_lockdevice"><i class="fa fa-edit (alias) "> </i> EDIT</button>
                    <label id="message"></label>
                </div>
            </div>
        </div>
    </div>

    <div id="form_facerecognition" class="col-md-4">
        <div class="card card-rounded">
            <div class="card-content">
                <div class="card-header">
                    <h5>
                        Lock Face Recognition Semua Karyawan
                        <i class="text-primary fa fa-question-circle-o fa-lg" data-toggle="tooltip" & data-placement="top" data-original-title="<?= $tooltip_lock_facerecognition ?>"></i>
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <input type="hidden" id="value_lama" value="<?= $data->lock_facerecognition ?>">
                            <div class="custom-radio-blue">
                                <section class="light">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <label id="label" class="disabled">
                                                <input type="radio" name="lock_facerecognition" value="0" <?= ((isset($data) && $data->lock_facerecognition == "0") ? "checked" : "") ?> disabled>
                                                <span class="design"></span>
                                                <span class="text">Tidak</span>
                                            </label>
                                        </div>
                                        <div class="col-md-6">
                                            <label id="label" class="disabled">
                                                <input type="radio" name="lock_facerecognition" value="1" <?= ((isset($data) && $data->lock_facerecognition == "1") ? "checked" : "") ?> disabled>
                                                <span class="design"></span>
                                                <span class="text">Ya</span>
                                            </label>
                                        </div>
                                    </div>
                                </section>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer card-footer-rounded">
                    <button class="btn_batal btn btn-secondary" form-data="form_facerecognition" style="display:none"><i class="fa fa-close"> </i> BATAL</button>
                    <button class="btn_save btn btn-primary ladda-button" data-style="expand-left" form-data="form_facerecognition" style="display:none"><i class="fa fa-save "> </i> SIMPAN</button>
                    <button class="btn_edit btn btn-warning" form-data="form_facerecognition"><i class="fa fa-edit (alias) "> </i> EDIT</button>
                    <label id="message"></label>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL CUTI-->
<div id="modal_cuti" class="modal fade in">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <input type="hidden" id="status">
            <input type="hidden" id="option">
            <input type="hidden" id="jml_cuti">
            <div class="card-header">
                <button type="button" id="modal_close" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div id="message" class="col-md-7 text-left"></div>
                    <div class="col-md-5 text-right">
                        <button class="btn btn-secondary" data-dismiss="modal">BATAL</button>
                        <button id="btn_confrim_cuti" class="btn btn-success ladda-button" data-style="expand-left">YA</button>
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL CUTI-->
