<style>
    #btn_filter_pencarian {
        background-color: Transparent;
        background-repeat: no-repeat;
        border: none;
        cursor: pointer;
        overflow: hidden;
        outline: none;
    }
</style>
<script type="text/javascript">
    $(document).ready(function() {
        btn_filter_pencarian();
        dropdown_karyawan();
        dropdown_cabang();
        dropdown_departemen();

        list_data();
        loadfungsimodaldetail();
        tanggal();

        $('#btn_cari').click(function(){
            var loading = Ladda.create(this);
            loading.start();
            var tanggal_mulai = ($('#tanggal_mulai').val() != null) ? $('#tanggal_mulai').val() : 0;
            var tanggal_selesai = ($('#tanggal_selesai').val() != null) ? $('#tanggal_selesai').val() : 0;
            var jenis = ($('#jenis').val() != null) ? $('#jenis').val() : 0;
            var status = $('#status').val();
            var id_karyawan = ($('#karyawan').val() != null) ? $('#karyawan').val() : 0;
            var id_cabang = 0;
            var id_departemen = 0;

            $('#view_data').load("<?= route('pengajuan.izin.data.view') ?>"+ '/' + tanggal_mulai + '/' + tanggal_selesai + '/' + jenis + '/' + status+ '/' + id_karyawan + "/" + id_cabang + '/' + id_departemen, function(){
                loading.stop();
            });
        });

        $('#btn_filter').click(function(){
            var loading = Ladda.create(this);
            loading.start();

            var level_user          = '<?= $level_user ?>';
            var multi_departemen    = '<?= $multi_departemen ?>';
            var multi_cabang        = '<?= $multi_cabang ?>';

            var tanggal_mulai = ($('#tanggal_mulai').val() != null) ? $('#tanggal_mulai').val() : 0;
            var tanggal_selesai = ($('#tanggal_selesai').val() != null) ? $('#tanggal_selesai').val() : 0;
            var jenis = (!$('#jenis').val())? "SM": $('#jenis').val();
            var status = $('#status').val();

            if(level_user == "3"){
                var id_karyawan = "<?= $this->id_karyawan ?>";
            }else{
                var id_karyawan = 0;
            }

            if(level_user == "1" || level_user == "4"){ // ADMIN HR DAN DIREKSI
                var id_cabang     = (!$("#cabang").val())?"0":$("#cabang").val();
                var id_departemen = (!$("#departemen").val())?"0":$("#departemen").val();
            }else if(level_user == "5"){ // KEPALA CABANG
                if(multi_cabang == '1'){
                    var id_cabang   = (!$("#cabang").val())?"0":$("#cabang").val();
                }else{
                    var id_cabang   = '<?= $this->id_cabang ?>';
                }
                var id_departemen   = (!$("#departemen").val())?"0":$("#departemen").val();
            }else if(level_user == "2"){ // KEPALA DEPARTEMEN
                var id_cabang     = '<?= $this->id_cabang ?>';
                if(multi_departemen == '1'){
                    var id_departemen   = (!$("#departemen").val())?"0":$("#departemen").val();
                }else{
                    var id_departemen   = '<?= $this->id_departemen ?>';
                }
            }else{
                var id_cabang       = '<?= $this->id_cabang ?>';
                var id_departemen   = '<?= $this->id_departemen ?>';
            }

            $('#view_data').load("<?= route('pengajuan.izin.data.view') ?>"+ '/' + tanggal_mulai + '/' + tanggal_selesai + '/' + jenis + '/' + status+ '/' + id_karyawan + "/" + id_cabang + '/' + id_departemen, function(){
                loading.stop();
            });
        });

        $('#jenis').select2({
            placeholder: 'Pilih Jenis Izin',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= site_url("pengajuan/izin/get-jenis")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });


        $(document).on('click', '.btn_verifikasi', function() {
            var id_izin             = $(this).attr('id');
            var level_verifikasi    = $(this).attr('level_verifikasi');
            $('#tampil_form').load("<?= route('pengajuan.izin.modal.verifikasi') ?>"+"/"+level_verifikasi+"/"+id_izin, function() {
                $('#modal_form').modal('show');

                if(level_verifikasi == "7"){
                    var title = "Approval Supervisi";
                }else if(level_verifikasi == "2"){
                    var title = "Approval Kepala Departemen";
                }else if(level_verifikasi == "5"){
                    var title = "Approval Kepala Cabang";
                }else if(level_verifikasi == "4"){
                    var title = "Approval Direksi";
                }else if(level_verifikasi == "1"){
                    var title = "Approval HRD";
                }else{
                    var title = "-";
                }

                $(".title").text(title);

                //Setuju
                $(".btn_setuju").on("click", function(e) {
                    e.preventDefault();
                    $('#message').html("");
                    var loading = Ladda.create(this);

                    status = $(this).attr('id');

                    loading.start();

                    var param = new FormData();
                    param.append('status', status);
                    param.append('id', $("#id").val());

                    $.ajax({
                        type: 'POST',
                        url: "<?= route('pengajuan.izin.approve') ?>",
                        data: param,
                        dataType: 'JSON',
                        contentType: false,
                        processData: false,
                        cache: false,
                        complete: function(data) {
                            reconfigure(data);
                        },
                        success: function(result) {
                            if(result.success == true) {
                                setTimeout(function(){
                                    $('#modal_form').modal('hide');
                                }, 500);
                                // list_data();
                            }
                            loading.stop();
                            $('#message').show();
                            $('#message').html(result.message);
                        },
                        error: function() {
                            loading.stop();
                            $('#message').show();
                            $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                        }
                    });
                });

                //Tolak
                $(".btn_tolak").on("click", function(e) {
                    e.preventDefault();
                    $('#message').html("");
                    var loading = Ladda.create(this);

                    status = $(this).attr('id');

                    loading.start();

                    var param = new FormData();
                    param.append('status', status);
                    param.append('id', $("#id").val());

                    $.ajax({
                        type: 'POST',
                        url: "<?= route('pengajuan.izin.approve') ?>",
                        data: param,
                        dataType: 'JSON',
                        contentType: false,
                        processData: false,
                        cache: false,
                        complete: function(data) {
                            reconfigure(data);
                        },
                        success: function(result) {
                            if(result.success == true) {
                                setTimeout(function(){
                                    $('#modal_form').modal('hide');
                                }, 500);
                            }
                            loading.stop();
                            $('#message').show();
                            $('#message').html(result.alert);
                        },
                        error: function() {
                            loading.stop();
                            $('#message').show();
                            $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                        }
                    });
                });
            });
        });


        $(document).on('click', '.btn_detail', function() {
            $('#tampil_form').load("<?php echo site_url('pengajuan/izin/detail/') ?>" + $(this).attr('id'), function() {
                $('#modal_form').modal('show');
                $(".title").text("Detail Data");
                $(".btn_save").append('<i class="fa fa-close"></i> ');
                $(".btn_save").append('KEMBALI');
                $(".btn_save").attr("data-dismiss", "modal");
                $(".btn_save").removeClass("btn_save").addClass("btn_kembali btn btn-secondary");
            });
        });

        $(document).on('click', '.btn_edit', function() {
            var id = $(this).attr('id');
            window.location.href = "<?= site_url('pengajuan/izin/edit/') ?>" + id
        });

        //btn_hapus
        $(document).on('click', '.btn_delete', function() {
            var id_izin = $(this).attr('id');
            $("#modal_hapus #id_izin").val(id_izin);
            $('#modal_hapus').modal('show');
            $(".title").text("Apakah Anda ingin menghapus data ini?");
            $(".btn_hapus").removeClass("btn_hapus").addClass("btn_hapus btn btn-danger");
        });
        //btn_hapus

        //btn_delete
        $('.btn_hapus').on('click', function() {
            var loading = Ladda.create(this);
            id_izin = $("#modal_hapus #id_izin").val();
            loading.start();
            $.ajax({
                type: 'POST',
                url: "<?php echo site_url('pengajuan/izin/delete') ?>",
                data: 'id_izin=' + id_izin,
                dataType: 'JSON',
                complete: function(data) {
                    reconfigure(data);
                },
                success: function(result) {
                    loading.stop();
                    $("#modal_hapus").modal('hide');
                    // list_data();
                },
                error: function() {
                    loading.stop();
                    $("#modal_hapus .card-body").hide();
                    $("#modal_hapus .card-footer").hide();
                    $("#modal_hapus .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });
        //btn_delete

    });

    function list_data() {
        var tanggal_mulai = ($('#tanggal_mulai').val() != null) ? $('#tanggal_mulai').val() : 0;
        var tanggal_selesai = ($('#tanggal_selesai').val() != null) ? $('#tanggal_selesai').val() : 0;
        var jenis = ($('#jenis').val() != null) ? $('#jenis').val() : 0;
        var status = $('#status').val();
        var id_karyawan = 0;
        var id_cabang = 0;
        var id_departemen = 0;

        $('#view_data').load("<?= route('pengajuan.izin.data.view') ?>"+ '/' + tanggal_mulai + '/' + tanggal_selesai + '/' + jenis + '/' + status+ '/' + id_karyawan + "/" + id_cabang + '/' + id_departemen);
    }

    function dropdown_karyawan() {
        $('#karyawan').select2({
            placeholder: 'Semua Karyawan',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.karyawan")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    function dropdown_cabang(){
        $('#cabang').select2({
            placeholder: 'Semua Cabang',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.cabang")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    function onchange_dropdown_cabang(){
        $("#departemen").val('').trigger('change');
        dropdown_departemen();
    }

    function dropdown_departemen(){

        var level_user = '<?= $level_user ?>';
        var multi_cabang = '<?= $multi_cabang ?>';
        if(level_user == "1" || level_user == "4" || (level_user == 5 && multi_cabang == true)){
            var id_cabang = $("#cabang").val();
        }else{
            var id_cabang = '<?= $this->id_cabang ?>';
        }

        $("#departemen").select2({
            placeholder: "Semua Departemen",
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.departemen.by.cabang") ?>'+'/'+id_cabang,
                dataType: 'json',
                delay: 250,
                processResults:function(data) {
                    return {
                            results: data
                        };
                },
                cache: false
            }
        });
    }

    function btn_filter_pencarian() {
        $("#btn_filter_pencarian").click(function() {
            if ($("#kolom_filter").is(":visible") == true) {
                $("#caret").removeClass("fa-caret-down");
                $("#caret").addClass("fa-caret-up");
                $("#kolom_filter").hide();
            } else {
                $("#caret").addClass("fa-caret-down");
                $("#caret").removeClass("fa-caret-up");
                $("#kolom_filter").show();
            }
        });
    }


    function tanggal() {
        var d = new Date();
        d.setDate(d.getDate()); // - 1
        $('.input-daterange input').each(function() {
            $(this).datepicker({
                orientation: "bottom",
                format: "dd-mm-yyyy",
                // endDate: d,
                autoclose: true,
            });
        });
    }

    function approve_spv(id, con) {
        var cnf = confirm("Apakah anda yakin?");
        if (cnf == true) {
            $.ajax({
                url: "<?php echo site_url('pengajuan/izin/approve-spv') ?>?id=" + id + "&con=" + con,
                type: "POST",
                dataType: "JSON",
                error: function() {
                    alert('Terjadi Kesalahan Dalam Database.');
                    //location.href = '<?= site_url('pengajuan/izin') ?>';
                },
                beforeSend: function() {

                    $("#hidden").show();
                    $("#hidden").css('display', 'block');
                    //$("#progress-bar").animate({width: "100%"}, 1000);
                },
                success: function(respon) {

                    $("#hidden").hide();
                    if (respon.status == 'berhasil') {
                        alert(respon.alert);
                        location.href = '<?= site_url('pengajuan/izin') ?>';
                        //list_data();
                    } else {
                        alert(respon.alert);
                        //location.href = '<?= site_url('pengajuan/izin') ?>';
                    }
                }
            });
        }
    }
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Kelola Absensi</a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <div class="float-md-right">
                <button type="button" id="btn_filter_pencarian">
                    <i class="fa fa-filter"></i> Filter Pencarian <i id="caret" class="fa fa-caret-down"></i>
                </button>
                <?php
                if (in_array($this->level_user, array("1"))) {
                ?>
                    <a href="<?= site_url('pengajuan/izin/tambah'); ?>">
                        <button type="button" class="btn_tambah btn btn-biru">
                            <i class="fa fa-plus"></i> Tambah Data
                        </button>
                    </a>
                <?php } ?>
            </div>
        </div>
    </div>
    <hr>
    <div id="kolom_filter">
        <div class="row">
            <div class="col-md-1">
                PERIODE
            </div>
            <div class="col-md-5">
                <div class="form-group">
                    <div class="input-group input-daterange">
                        <input type="text" id="tanggal_mulai" class="form-control masktanggal" autocomplete="off" placeholder="dd-mm-yyyy" value="<?= $periode_awal ?>">
                        <div class="align-self-center">&nbsp;s/d&nbsp;</div>
                        <input type="text" id="tanggal_selesai" class="form-control masktanggal" autocomplete="off" placeholder="dd-mm-yyyy" value="<?= $periode_akhir ?>">
                    </div>
                </div>
            </div>
        </div>
        <div class="row mb-1">
            <div class="col-md-1">
                JENIS IZIN
            </div>
            <div class="col-md-2">
                <select class="form-control" name="jenis" id="jenis" class="select2 form-control">
                    <option value="SM" selected="true">Semua Jenis</option>
                </select>
            </div>
            <div class="col-md-1">
                STATUS
            </div>
            <div class="col-md-2">
                <select class="form-control" name="status" id="status" class="select2 form-control">
                    <option value="1" selected="true">Pengajuan</option>
                    <option value="3">Disetujui</option>
                    <option value="2">Ditolak</option>
                    <option value="0">Semua</option>
                </select>
            </div>
            <?php
                if($level_user == "3") {
            ?>
                    <div class="col-md-1">
                        <button type="button" id="btn_filter" class="ladda-button btn-block btn btn-primary" data-style="expand-left">FILTER</button>
                    </div>
            <?php
                }
            ?>
        </div>
        <?php
            if($level_user != "3") {
        ?>
                <div class="row mb-1">
                    <label class="col-md-1">KARYAWAN</label>
                    <div class="col-md-5">
                        <select class="form-control" name="karyawan" id="karyawan" class="select2 form-control">
                        </select>
                    </div>
                    <div class="col-md-1">
                        <button type="button" id="btn_cari" class="btn btn-primary btn-block ladda-button" data-style="expand-left">CARI</button>
                    </div>
                </div>
        <?php
            }
        ?>
        <div class="row mb-1">
            <?php
            if(in_array($level_user, array("1", "4")) || $multi_cabang == true) {
            ?>
                <label class="col-md-1">CABANG</label>
                <div class="col-md-2">
                    <select id="cabang" class="form-control" onchange="onchange_dropdown_cabang()"></select>
                </div>
            <?php } ?>
            <?php
                if (in_array($level_user, array("1", "4", "5")) || $multi_departemen == true) {

                    if(in_array($level_user, array("1", "4"))){
                        $class = "col-md-2";
                    }else if($level_user == "5"){
                        if($multi_cabang == true){
                            $class = "col-md-2";
                        }else{
                            $class = "col-md-5";
                        }
                    }else{
                        $class = "col-md-5";
                    }
            ?>
                <div class="col-lg-1">
                    <label>DEPARTEMEN</label>
                </div>
                <div class="<?= $class ?>">
                    <select id="departemen" class="form-control"></select>
                </div>
                <div class="col-md-1">
                    <button type="button" id="btn_filter" class="ladda-button btn-block btn btn-primary" data-style="expand-left">FILTER</button>
                </div>
            <?php } ?>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div id="view_data"></div>
            <!--class="col-md-12 bbna"-->
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

<!-- START TAMPIL MODAL -->
<div id="modal_hapus" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_hapus" class="modal-content">
            <input type="hidden" id="id_izin">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-7 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-5 text-right">
                        <button class="btn_hapus ladda-button" id="btn_hapus" data-style="expand-left"><i class="fa fa-trash"></i> HAPUS</button>
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL -->