<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $sub_judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        </li>
                        <li class="breadcrumb-item"><a href="#"><?= $judul ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?= $sub_judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <div class="float-right">
                <a class="btn btn-secondary" href="<?php echo site_url('pengajuan/izin') ?>">
                    <i class="fa fa-arrow-left"></i> KEMBALI
                </a>
            </div>
        </div>
    </div>
</div>
<?php
switch ($this->level_user) {
    case '1':
        $lv_appv = 'hrd';
        break;
    case '2':
        $lv_appv = 'kedep';
        break;
    case '4':
        $lv_appv = 'direksi';
        break;
    case '5':
        $lv_appv = 'kacab';
        break;
    case '7':
        $lv_appv = 'spv';
        break;
    default:
        $lv_appv = '';
        break;
}
?>
<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <input type="hidden" name="id" value="<?php echo md5($data->id_izin) ?>">
                        <div class="row mb-1">
                            <div class="col-md-6">
                                <div class="text-bold-400"><b>NIK</b></div>
                                <label><?= ((isset($data)) ? $data->nik : '') ?></label>
                            </div>
                            <div class="col-md-6">
                                <div class="text-bold-400"><b>Nama Karyawan</b></div>
                                <label><?= ((isset($data)) ? $data->nama_lengkap : '') ?></label>
                            </div>
                        </div>

                        <div class="row mb-1">
                            <div class="col-md-6">
                                <div class="text-bold-400"><b>Cabang</b></div>
                                <label><?= ((isset($data)) ? $this->fungsi->get_nama_cab($data->id_cabang) : '') ?></label>
                            </div>
                            <div class="col-md-6">
                                <div class="text-bold-400"><b>Departemen</b></div>
                                <label><?= ((isset($data)) ? $this->fungsi->get_data_nama_dep($data->id_departemen) : '') ?></label>
                            </div>
                        </div>

                        <div class="row mb-1">
                            <div class="col-md-6">
                                <div class="text-bold-400"><b>Jenis Izin</b></div>
                                <label><?= ((isset($data)) ? ucwords($data->jenis_izin) . ' (' . ucwords($data->nama_izin) . ')' : '') ?></label>
                            </div>
                            <div class="col-md-6">
                                <div class="text-bold-400"><b>Jumlah Izin</b></div>
                                <label><?= ((isset($data)) ? $data->jml_izin : '') ?> Hari</label>
                            </div>
                        </div>

                        <div class="row mb-1">
                            <div class="col-md-6">
                                <div class="text-bold-400"><b>Tanggal Pengajuan</b></div>
                                <label><?= ((isset($data)) ?  date('d-m-Y', strtotime($data->tgl_pengajuan)) : '') ?></label>
                            </div>
                            <div class="col-md-6">
                                <div class="text-bold-400"><b>Periode Izin</b></div>
                                <label><?= ((isset($data)) ? date('d-m-Y', strtotime($data->tgl_mulai_izin)) : '') . " s/d " . ((isset($data)) ? date('d-m-Y', strtotime($data->tgl_selesai_izin)) : '') ?></label>
                            </div>
                        </div>

                        <div class="row mb-1">
                            <div class="col-md-12">
                                <div class="text-bold-400"><b>Keterangan</b></div>
                                <label><?= ((isset($data)) ? $data->ket_izin : '') ?></label>
                            </div>
                        </div>

                        <div class="row mb-1">
                            <div class="col-md-12">
                                <div class="text-bold-400"><b>Status</b></div>
                                <b><label><?= ((isset($data)) ? $this->fungsi->get_approval($data->status) : '') ?></label></b>
                            </div>
                        </div>

                        <div class="row mb-1">
                            <div class="col-md-12">
                                <?php
                                if ($lv_appv != '' && $data->status == '1') {
                                    $tx = 'approval_' . $lv_appv;
                                    $cek = $data->$tx;
                                    if ($cek == '1') {
                                ?>
                                        <button type="button" id="btn_approve" class="btn btn-success" data-toggle="modal" data-target="#modal_approve" data-cfm="Apakah Anda ingin menyetujui pengajuan ini?" data-act="4">
                                            <i class="fa fa-check-square-o"></i> APPROVE
                                        </button>
                                        <button type="button" id="btn_tolak" class="btn btn-danger" data-toggle="modal" data-target="#modal_approve" data-cfm="Apakah Anda ingin menolak pengajuan ini?" data-act="3">
                                            <i class="fa fa-close"></i> TOLAK
                                        </button>
                                <?php }
                                } ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="text-bold-400 text-center"><b>Lampiran File Izin</b></div>
                    <hr>
                    <div class="row">
                        <?php
                        if (isset($data->fl_izin)) {
                            foreach ($data->fl_izin as $k => $v) {
                        ?>
                                <div class="col-md-4">
                                    <?php
                                    $foto = $this->config->item('base_image').'image?_t=file&_d='.$v->file;
                                    ?>
                                    <a data-toggle="modal" data-target="#exampleModal" data-urlimg="<?php echo $foto ?>" href="javascript:;">
                                        <img width="100%" src="<?php echo $foto ?>" alt="Lampiran">
                                    </a>
                                </div>
                        <?php
                            }
                        }
                        ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel"></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <img id="imgcont" width="100%" src="#" alt="">
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_approve" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_approve" class="modal-content">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-7 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-5 text-right">
                        <button style="display:none;" class="btn btn-success btn_setuju ladda-button" data-style="expand-left" type="button" id="confirm_approve">
                            <i class="fa fa-check-square-o"></i> APPROVE
                        </button>
                        <button style="display:none;" class="btn btn-danger btn_tolak ladda-button" data-style="expand-left" type="button" id="3">
                            <i class="fa fa-close"></i> TOLAK
                        </button>
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

<script>
    $(document).ready(function() {

        $('#exampleModal').on('shown.bs.modal', function(event) {
            $('#imgcont').attr('src', event.relatedTarget.dataset.urlimg);
        });

        $('#exampleModal').on('hide.bs.modal', function(event) {
            $('#imgcont').attr('src', '');
        });

        $('#modal_approve').on('shown.bs.modal', function(event) {
            $('.title').text(event.relatedTarget.dataset.cfm);

            if (event.relatedTarget.dataset.act == '4') {
                $('.btn_setuju').show();
            }

            if (event.relatedTarget.dataset.act == '3') {
                $('.btn_tolak').show();
            }
        });

        $('#modal_approve').on('hide.bs.modal', function(event) {
            $('.title').text('');
            $('.btn_setuju').hide();
            $('.btn_tolak').hide();
        });

        //Setuju
        $(document).on("click", "#confirm_approve", function(e) {
            e.preventDefault();

            $('#message').html("");
            var loading = Ladda.create(this);

            status = $(this).attr('id');

            loading.start();

            var param = new FormData();
            param.append('status', "4");
            param.append('id', $("input[name=id]").val());

            $.ajax({
                type: 'POST',
                url: "<?= route('pengajuan.izin.approve') ?>",
                data: param,
                dataType: 'JSON',
                contentType: false,
                processData: false,
                cache: false,
                complete: function(data) {
                    reconfigure(data);
                },
                success: function(result) {
                    if(result.success == true) {
                        $("#modal_approve .card-body").hide();
                        $("#modal_approve .card-footer").hide();
                        $("#modal_approve .title").html('<font color="#ffffff"><i class="fa fa-check-square">&nbsp;</i>Izin Berhasil Disetujui</font>');
                        $("#confirm_approve").hide();
                        $("#btn_approve").hide();
                        $("#btn_tolak").hide();
                    }
                    $('#message').show();
                    $('#message').html(result.message);
                    loading.stop();
                },
                error: function() {
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });

        //Tolak
        $(document).on("click", ".btn_tolak", function(e) {
            e.preventDefault();

            $('#message').html("");
            var loading = Ladda.create(this);

            status = $(this).attr('id');

            loading.start();

            var param = new FormData();
            param.append('status', status);
            param.append('id', $("input[name=id]").val());

            $.ajax({
                type: 'POST',
                url: "<?= route('pengajuan.izin.approve') ?>",
                data: param,
                dataType: 'JSON',
                contentType: false,
                processData: false,
                cache: false,
                complete: function(data) {
                    reconfigure(data);
                },
                success: function(result) {
                    if(result.success == true) {
                        $("#btn_approve").hide();
                        $("#3").hide();
                    }

                    $('#message').show();
                    $('#message').html(result.message);
                    loading.stop();
                },
                error: function() {
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });
    });
</script>