<script src="<?=base_url('assets/js')?>/autoNumeric.js"></script>
<input type="hidden" name="id_karyawan" value="<?= $id_karyawan ?>">
<div class="row form-detail-karyawan mt-2">
    <div class="col-8">
        <div class="row">
            <div class="col-6">
                <fieldset class="form-group">
                    <label for="no_id_karyawan">Nomor Induk Karyawan</label>
                    <p class="form-control-static"><?= $data_diri->nik != '' ? $data_diri->nik : '-' ?></p>
                </fieldset>
            </div>
            <div class="col-3">
                <fieldset class="form-group">
                    <label for="nama_lengkap">Nama Lengkap</label>
                    <p class="form-control-static"><?= $data_diri->nik != '' ? $data_diri->nama_lengkap : '-' ?></p>
                </fieldset>
            </div>
        </div>
        <div class="row">
            <div class="col-6">
                <fieldset class="form-group">
                    <label for="tanggungan">Tanggungan</label>
                    <div class="form-inline" id="tanggungan">
                        <p class="form-control-static">
                            <?= $data_diri->tanggungan != '' ? $data_diri->tanggungan : '-' ?>
                        </p>
                        &nbsp;<button class="btn btn-link" onclick="form_update(this)"><i class="fa fa-edit"></i>
                    </div>
                </fieldset>
            </div>
        </div>
        <div class="row">
            <div class="col-6">
                <fieldset class="form-group">
                    <label for="npwp">NPWP</label>
                    <div class="form-inline" id="npwp">
                        <p class="form-control-static">
                            <?= $data_diri->npwp != '' ? $data_diri->npwp : '-' ?>
                        </p>
                        &nbsp;<button class="btn btn-link" onclick="form_update(this)"><i class="fa fa-edit"></i>
                    </div>
                </fieldset>
            </div>
        </div>
        <div class="text-primary mt-3"><h5>Informasi Bank</h5></div>
        <hr>
        <div class="row">
            <div class="col">
                <fieldset class="form-group">
                    <label for="bank_atas_nama">Nama Direkening</label>
                    <div class="form-inline" id="bank_atas_nama">
                        <p class="form-control-static">
                            <?= $data_diri->bank_atas_nama != '' ? $data_diri->bank_atas_nama : '-' ?>
                        </p>
                        &nbsp;<button class="btn btn-link" onclick="form_update(this)"><i class="fa fa-edit"></i>
                    </div>
                </fieldset>
            </div>
        </div>
        <div class="row">
            <div class="col">
                <fieldset class="form-group">
                    <label for="bank_nama">Nama Bank</label>
                    <div class="form-inline" id="bank_nama">
                        <p class="form-control-static">
                            <?= $data_diri->bank_nama != '' ? $data_diri->bank_nama : '-' ?>
                        </p>
                        &nbsp;<button class="btn btn-link" onclick="form_update(this)"><i class="fa fa-edit"></i>
                    </div>
                </fieldset>
            </div>
            <div class="col">
                <fieldset class="form-group">
                    <label for="bank_rek">No. Rekening</label>
                    <div class="form-inline" id="bank_rek">
                        <p class="form-control-static">
                            <?= $data_diri->bank_rek != '' ? $data_diri->bank_rek : '-' ?>
                        </p>
                        &nbsp;<button class="btn btn-link" onclick="form_update(this)"><i class="fa fa-edit"></i>
                    </div>
                </fieldset>
            </div>
        </div>
        <div class="text-primary mt-3"><h5>Informasi Gaji</h5></div>
        <hr>
        <label for="pendapatan" class="mt-1">Pendapatan</label>
        <div class="row">
            <div class="col-6">
                <div class="d-flex justify-content-between" id="gapok">
                    Gaji Pokok
                    <p class="form-control-static">Rp. <?= $gapok != '' ? dec_to_num($gapok) : '0' ?>&nbsp;<a class="text-primary" onclick="form_update(this)"><i class="fa fa-edit"></i></a></p>
                </div>
                <div id="tunj_tetap">
                <?php if($tunj_tetap->num_rows() > 0) {
                    foreach($tunj_tetap->result() as $row) {
                ?>
                <div class="d-flex justify-content-between" id="tunjtetap_<?= md5($row->id_item) ?>">
                    <?= $row->nm_tunjangan ?>
                    <p class="form-control-static">Rp. <?= $row->nominal_tunjangan != '' ? dec_to_num($row->nominal_tunjangan) : '0' ?>&nbsp;
                        <?php if($row->flag_persentase_gapok == '0') { ?>
                        <a class="text-primary" onclick="form_update(this)"><i class="fa fa-edit"></i></a>
                        <?php } ?>
                    </p>
                </div>
                <?php }
                } ?>
                </div>
                <hr>
                <div class="row">
                    <div class="col-6">Total Pendapatan</div>
                    <div class="col-6 text-right"><p class="form-control-static" id="ttl_pendapatan">Rp. <?= dec_to_num($gapok+$ttl_tunj_tetap) ?></p></div>
                </div>
            </div>
        </div>
        <label for="potongan" class="mt-3">Potongan</label>
        <div class="row">
            <div class="col-6">
                <div class="d-flex justify-content-between">
                    Potongan BPJS Kesehatan
                    <p class="form-control-static" id="pot_bpjs_kes">
                        Rp. <?= $pot_bpjs_kes != '' ? dec_to_num($pot_bpjs_kes, 2) : '0' ?>
                    </p>
                </div>
                <div class="d-flex justify-content-between">
                    Potongan JHT
                    <p class="form-control-static">
                        Rp. <?= $pot_bpjs_tk->pot_jht_kry_rp != '' ? dec_to_num($pot_bpjs_tk->pot_jht_kry_rp, 2) : '0' ?>
                    </p>
                </div>
                <div class="d-flex justify-content-between">
                    Potongan JP
                    <p class="form-control-static">
                        Rp. <?= $pot_bpjs_tk->pot_jp_kry_rp != '' ? dec_to_num($pot_bpjs_tk->pot_jp_kry_rp, 2) : '0' ?>
                    </p>
                </div>
                <div id="pot_tetap">
                <?php if($pot_tetap->num_rows() > 0) {
                    foreach($pot_tetap->result() as $row) {
                ?>
                <div class="d-flex justify-content-between" id="pottetap_<?= md5($row->id_item) ?>">
                    <?= $row->nm_potongan ?>
                    <p class="form-control-static">Rp. <?= $row->nominal_potongan != '' ? dec_to_num($row->nominal_potongan) : '0' ?>&nbsp;
                    <?php if($row->flag_persentase_gapok == '0') { ?>
                        <a class="text-primary" onclick="form_update(this)"><i class="fa fa-edit"></i></a>
                        <?php } ?>
                    </p>
                </div>
                <?php }
                } ?>
                </div>
                <hr>
                <div class="row">
                    <div class="col-6">Total Potongan</div>
                    <div class="col-6 text-right"><p class="form-control-static" id="ttl_pot">Rp. <?= dec_to_num($ttl_pot, 2) ?></p></div>
                </div>
            </div>
        </div>
        <fieldset class="form-group mt-1">
            <label for="gaji">Gaji Yang Diterima</label>
            <p class="form-control-static" id="gaji">Rp. <?= dec_to_num(($gapok+$ttl_tunj_tetap)-$ttl_pot, 2) ?></p>
        </fieldset>
        <div class="text-primary mt-3"><h5>Tunjangan Dibiayai Perusahaan</h5></div>
        <hr>
        <div class="row">
            <div class="col-6">
                <div class="row mt-1">
                    <div class="col-6">
                        <fieldset class="form-group">
                            <label for="bpjs_kes">BPJS Kesehatan</label>
                            <p class="form-control-static">
                                Rp. <?= $tunj_bpjs_kes != '' ? dec_to_num($tunj_bpjs_kes, 2) : '0' ?>
                            </p>
                        </fieldset>
                    </div>
                    <div class="col-6">
                        <fieldset class="form-group">
                            <label for="bpjs_ket">BPJS Ketenagakerjaan</label>
                            <p class="form-control-static">
                                Rp. <?= $ttl_tunj_bpjs_tk != '' ? dec_to_num($ttl_tunj_bpjs_tk, 2) : '0' ?>
                            </p>
                        </fieldset>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function form_update(element) {
        var id = $(element).closest('div').attr('id');
        var id_karyawan = $('input[name="id_karyawan"]').val();
        $.get('<?= site_url("master/karyawan/payroll/form") ?>/'+id+'/'+id_karyawan, function(response) {
			$('#'+id).html(response);
            if (['bank_atas_nama', 'bank_rek', 'bank_nama'].includes(id)) {
                $('#'+id+' .nominal').closest('.input-group').attr('style', 'width: 100%');
            } else if(id == 'jml_anak') {
                $('#'+id+' .nominal').inputmask('9');
            } else if(id == 'npwp') {
                $('#'+id+' .nominal').inputmask('99.999.999.9-999.999');
            } else if(['tanggungan', 'jml_anak'].includes(id) == false) {
                $('#'+id+' .nominal').autoNumeric('init', {aSep: '.', aDec: ',', mDec: 0});
            }
        });
    }

    function save(element) {
        var form = $(element).closest('form');
        var id   = form.find('input[name="name"]').val();
        $.post('<?= route("master.karyawan.payroll.save") ?>', form.serialize(), function(response) {
            if(response.success) {
                $('#'+id).html(response.html);
                if(id == 'gapok') {
                    $('#tunj_tetap').html(response.html_tunj_tetap);
                    $('#pot_tetap').html(response.html_pot_tetap);
                }
                var items = ['ttl_pendapatan', 'pot_bpjs_kes', 'ttl_pot', 'gaji'];
                items.forEach(function(value) {
                    if(response.hasOwnProperty(value)) {
                        $('#'+value).html('Rp. '+response[value]);
                    }
                });
            }
        }, 'json');
    }
</script>
