<script type="text/javascript">
    $(function() {
        list_data = $('#list_data').DataTable({ 
                    'searching'   : true,
                    'paging'      : true,
                    'lengthChange': true,
                    'ordering'    : true,
                    'info'        : true,
                    'scrollX'     : true,
                    // 'scrollCollapse': true,
                    // 'fixedColumns': true,
                    'language'    :{
                                    'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                    'sEmptyTable' : 'Tidak ada data untuk ditampilkan'
                                },
                    "processing"  : true, 
                    "serverSide"  : true, 
                    "order"       : [], 
                    
                    "ajax"        : {
                                    "url": "<?= route('pengaturan.jamkerja.listdata') ?>",
                                    "type": "GET",
                                        "complete" : function(data){
                                            reconfigure(data);
                                        }
                                    },
            
                    "aoColumnDefs": [
                                        { "aTargets": [0], "bSortable": false },
                                        { "aTargets": [4], "bSortable": false }
                                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center'});
                            $('td:eq(4)', nRow).css({'text-align':'center'});
            
                            $('td:eq(0)', nRow).css({'width':'10px'});
                            $('td:eq(4)', nRow).css({'width':'100px'});
                    }
        
        });

        
    });
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Pengaturan</a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="table-responsive">
                <table id="list_data" class="table table-striped" style="width:100%">
                    <thead>
                        <tr>
                            <th class="text-center">NO</th>
                            <th class="text-left">KODE</th>
                            <th class="text-left">NAMA</th>
                            <th class="text-left">PUSAT/CABANG</th>
                            <th class="text-center">AKSI</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->


