<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Shift_m extends CI_Model {
    var $table = 'master_shift';
    public function __construct(){
        parent::__construct();
    }

    function get_datatables($cabang = null){
        $this->_get_datatables_query($cabang);
        if($_GET['length'] != -1){
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered($cabang = null){
        $this->_get_datatables_query($cabang);
        $query = $this->db->get();
        return $query->num_rows();
    }
    
    public function count_all($cabang = null){
        $this->_get_datatables_query($cabang);
        return $this->db->count_all_results();
    }
    private function _get_datatables_query($cabang = null){
        $this->db->select("master_shift.id_master_shift, 
                            master_shift.kode_shift, 
                            master_shift.nama_shift, 
                            master_shift.jam_masuk, 
                            master_shift.jam_pulang, 
                            master_shift.start_absen_masuk,
                            master_shift.batas_absen_pulang, 
                            master_shift.libur, 
                            master_shift.id_cabang, 
                            master_shift.flag_jam_pulang, 
                            master_shift.flag_batas_absen_pulang, 
                            master_cabang.nama as nama_cabang, 
                            master_cabang.kode as kode_cabang");
        $this->db->from($this->table);
        $this->db->join('master_cabang','master_shift.id_cabang  = master_cabang.id_cabang', 'left');
        $this->db->where("master_shift.id_company", $this->id_company);
        if($cabang != null) {
            $this->db->where("master_shift.id_cabang", $cabang);
        }else{
            if($this->multi_cabang == true){
                $this->db->where_in("master_shift.id_cabang", $this->id_cabang_arr);
            }else if($this->level_user == "5"){
                $this->db->where("master_shift.id_cabang", $this->id_cabang);
            }
        }
        
        $column_search = array('master_shift.kode_shift','master_shift.nama_shift');
        $i = 0;
    
        foreach ($column_search as $item){  // looping awal
            if($_GET['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST
    
                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                }else{
                    $this->db->or_like($item, $_GET['search']['value']);
                }
    
                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }
    
        $column_order = array('',
                            'master_shift.kode_shift',
                            'master_shift.nama_shift',
                            'master_shift.libur',
                            'master_shift.jam_masuk',
                            'master_shift.start_absen_masuk',
                            'master_shift.jam_pulang',
                            'master_shift.batas_absen_pulang',
                            'master_cabang.kode');
    
        if(isset($_GET['order'])){
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } 
        else{
            $order_by = array("master_shift.tgl_input"=>"DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id=null){
        $select = $this->db->select("master_shift.id_master_shift,
                                    master_shift.kode_shift,
                                    master_shift.nama_shift,
                                    master_shift.jam_masuk,
                                    master_shift.jam_pulang, 
                                    master_shift.start_absen_masuk,
                                    master_shift.batas_absen_pulang, 
                                    master_shift.flag_jam_pulang,
                                    master_shift.flag_batas_absen_pulang,
                                    master_shift.libur, 
                                    master_shift.id_cabang,
                                    master_cabang.id_cabang,
                                    master_cabang.kode as kode_cabang,
                                    master_cabang.nama as nama_cabang")
                            ->from($this->table)
                            ->join("master_cabang","master_cabang.id_cabang = master_shift.id_cabang")
                            ->where("MD5(master_shift.id_master_shift)",$id)
                            ->where("master_shift.id_company",$this->id_company)
                            ->get();
        return $select->row();
    }

    public function save($data,$id_shift = null){
        $kode_shift = $data['kode_shift'];
        $id_cabang = $data['id_cabang'];

        if($id_shift != null){

            $this->db->select("kode_shift")
                    ->from("master_shift")
                    ->where("kode_shift",$kode_shift)
                    ->where("md5(id_master_shift) !=",$id_shift)
                    ->where("id_cabang",$id_cabang)
                    ->where("id_company",$this->id_company);
            $cek_kode = $this->db->get();
            
            if($cek_kode->num_rows() > 0) {
                $message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Kode sudah digunakan</font>');
                return __response_update(false,$message);
            }else{
                $this->db->where(array('md5(id_master_shift)'=>$id_shift, 'id_company'=>$this->id_company));
                $update = $this->db->update($this->table,$data);
                return  __response_update($update);
            }
            
        }else{
            $this->db->select("kode_shift")
                    ->from("master_shift")
                    ->where("kode_shift",$kode_shift)
                    ->where("id_cabang",$id_cabang)
                    ->where("id_company",$this->id_company);
            $cek_kode = $this->db->get();
            
            if ($cek_kode->num_rows() > 0) {
                $message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Kode sudah digunakan</font>');
                return __response_save(false,$message);
            }else{
                $nextId = $this->fungsi->getNextId($this->table,'id_master_shift',$this->id_company,3);
                $id_shift = array('id_master_shift' => $nextId);
                $save = $this->db->insert($this->table, array_merge($data,$id_shift));
                return __response_save($save);
            }
        }     
    }

    public function delete($id=null){
        $this->db->where(array('md5(id_master_shift)'=>$id));
        $delete =$this->db->delete($this->table);
        return  __response_delete($delete);
    
        
    }

}