<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Riwayat_pendidikan_m extends CI_Model {
    var $table = 'riwayat_pendidikan';
    public function __construct(){
        parent::__construct();
    }

    public function getDataById($id_riwayat_pendidikan=null){
        $query = $this->db->select("id_riwayat_pendidikan,
                                    nama_sekolah,
                                    jenjang,
                                    jurusan,
                                    lulusan_asal,
                                    gelar,
                                    tahun_masuk,
                                    tahun_lulus,
                                    ijazah,
                                    transkrip")
                            ->from($this->table)
                            ->where("MD5(id_riwayat_pendidikan)",$id_riwayat_pendidikan)
                            ->get()
                            ->row();
        return $query;
    }

    public function listData($id_karyawan=null){
        $query = $this->db->select("id_riwayat_pendidikan,
                                    nama_sekolah,
                                    jenjang,
                                    jurusan,
                                    lulusan_asal,
                                    gelar,
                                    tahun_masuk,
                                    tahun_lulus,
                                    ijazah,
                                    transkrip")
                            ->from($this->table)
                            ->where("MD5(id_karyawan)",$id_karyawan)
                            ->order_by("jenjang = 'SD', jenjang = 'SMP/MTS', jenjang = 'SMA/SMK/', jenjang = 'Dlipoma', jenjang = 'Sarjana', jenjang = 'Magister', jenjang = 'Doctor'")
                            ->get()
                            ->result();
        return $query;
    }

    public function save($data,$id = null){
        
        if(strlen($data['tahun_masuk']) > 4 || strlen($data['tahun_masuk']) < 4){
            $params = array("message"=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Format tahun masuk salah</font>'); 
            return __response_save(false,$params);
        }

        if(strlen($data['tahun_lulus']) > 4 || strlen($data['tahun_lulus']) < 4){
            $params = array("message"=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Format tahun lulus salah</font>'); 
            return __response_save(false,$params);
        }

        if($id != null){
            if($data['ijazah'] == ""){
                $predir_ijazah = $this->db->select("ijazah")
                                        ->from($this->table)
                                        ->where("md5(id_riwayat_pendidikan)",$id)
                                        ->where("id_company",$this->id_company)
                                        ->get()
                                        ->row("ijazah");
            }

            if($data['transkrip'] == ""){
                $predir_transkrip = $this->db->select("transkrip")
                                        ->from($this->table)
                                        ->where("md5(id_riwayat_pendidikan)",$id)
                                        ->where("id_company",$this->id_company)
                                        ->get()
                                        ->row("transkrip");
            }
            
            $this->db->where(array('md5(id_riwayat_pendidikan)'=>$id));
            $update = $this->db->update('riwayat_pendidikan',$data);
            if($update){
                if($data['ijazah'] == ""){
                    $this->fungsi->delete_fileupload($predir_ijazah);
                }
                if($data['transkrip'] == ""){
                    $this->fungsi->delete_fileupload($predir_transkrip);
                }
            }

            $new_params["new_params"] = ["ijazah"=>$data["ijazah"],"transkrip"=>$data["transkrip"]];
            return __response_update($update,$new_params);
        }else{
            $nextId = $this->fungsi->getNextId('riwayat_pendidikan','id_riwayat_pendidikan',$this->id_company,4);
            $id_pendidikan = array('id_riwayat_pendidikan' => $nextId);
            $save = $this->db->insert('riwayat_pendidikan', array_merge($data, $id_pendidikan));
            return __response_save($save);
    
        }
        
    }

    public function delete($id_riwayat_pendidikan=null){
        
        $predir = $this->db->select("ijazah,transkrip")
                            ->from($this->table)
                            ->where("md5(id_riwayat_pendidikan)",$id_riwayat_pendidikan)
                            ->where("id_company",$this->id_company)
                            ->get()
                            ->row();

        $this->fungsi->delete_fileupload($predir->ijazah);
        $this->fungsi->delete_fileupload($predir->transkrip);

        $this->db->where('md5(id_riwayat_pendidikan)',$id_riwayat_pendidikan);
        $this->db->where('id_company',$this->id_company);
        $delete =$this->db->delete($this->table);
        return __response_delete($delete);
    }

}