<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Karir_pekerjaan_m extends CI_Model {
    var $table = 'karir_pekerjaan';

    public function getDataByIdKaryawan($id_karyawan = null){
        $query = $this->db->select('id_karir_pekerjaan,
                                        nomor_surat_keputusan,
                                        id_karyawan,
                                        kode_jabatan,
                                        nama_jabatan,
                                        kode_cabang,
                                        nama_cabang,
                                        kode_departemen,
                                        nama_departemen,
                                        tgl_mulai,
                                        tgl_berakhir,
                                        status,
                                        keterangan_status')
                            ->where('id_karyawan',$id_karyawan)
                            ->order_by('tgl_mulai ASC')
                            ->from($this->table)
                            ->get()
                            ->result();

        return $query;
    }

    public function getDataById($id_karir_pekerjaan=null){
        $query = $this->db->select('id_karir_pekerjaan,
                                    nomor_surat_keputusan,
                                    id_karyawan,
                                    kode_jabatan,
                                    nama_jabatan,
                                    kode_cabang,
                                    nama_cabang,
                                    kode_departemen,
                                    nama_departemen,
                                    tgl_mulai,
                                    tgl_berakhir,
                                    status,
                                    keterangan_status')
                            ->where('MD5(id_karir_pekerjaan)',$id_karir_pekerjaan)
                            ->from($this->table)
                            ->get()
                            ->row();
        return $query;
    }

    public function save($data,$id = null){
        if($id != null){
            $this->db->where(array('md5(id_karir_pekerjaan)'=>$id));
            $update = $this->db->update('karir_pekerjaan',$data);
            return __response_update($update);
        }else{
            $id_company = $this->session->userdata('id_company');
            $nextId = $this->fungsi->getNextId('karir_pekerjaan','id_karir_pekerjaan',$id_company,4);
            $id_karir_pekerjaan = array('id_karir_pekerjaan' => $nextId);
            $save = $this->db->insert('karir_pekerjaan', array_merge($data, $id_karir_pekerjaan));
            return __response_save($save);
        }
        
    }

    public function delete($id=null){
        $this->db->where(array('md5(id_karir_pekerjaan)'=>$id));
        $delete =$this->db->delete($this->table);   
        return __response_delete($delete);
    }

}