<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Informasi_gaji_temp_m extends CI_Model {
    var $table = 'informasi_gaji_temp';
    public function __construct(){
        parent::__construct();
    }

    function get_datatables(){
        $this->get_datatables_query();
        if($_GET['length'] != -1){
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        // echo $this->db->last_query();
        return $query->result();
    }
    
    function count_filtered(){
        $this->get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
    
    public function count_all(){
        $this->db->select("id,
                        periode,
                        id_karyawan,
                        nik,
                        nama_karyawan,
                        kode_cabang,
                        nama_cabang,
                        kode_departemen,
                        nama_departemen,
                        kode_jabatan,
                        nama_jabatan,
                        gaji_pokok,
                        t_jabatan,
                        t_transport,
                        t_makan,
                        t_istri,
                        t_anak,
                        lembur,
                        komisi,
                        t_lain,
                        ttl_tunjangan,
                        ttl_penerimaan,
                        tbp_bpjs_tk,
                        tbp_bpjs_kesehatan,
                        tbp_lain,
                        ttl_tbp,
                        p_absensi,
                        p_keterlambatan,
                        p_koperasi,
                        p_asuransi_kesehatan,
                        p_bpjs_tk,
                        p_bpjs_kesehatan,
                        p_lain,
                        ttl_potongan,
                        gaji_diterima,
                        flag")
                ->from($this->table)
                ->where("id_company",$this->id_company);
        return $this->db->count_all_results();
    }
    private function get_datatables_query(){
        $this->db->select("id,
                            periode,
                            id_karyawan,
                            nik,
                            nama_karyawan,
                            kode_cabang,
                            nama_cabang,
                            kode_departemen,
                            nama_departemen,
                            kode_jabatan,
                            nama_jabatan,
                            gaji_pokok,
                            t_jabatan,
                            t_transport,
                            t_makan,
                            t_istri,
                            t_anak,
                            lembur,
                            komisi,
                            t_lain,
                            ttl_tunjangan,
                            ttl_penerimaan,
                            tbp_bpjs_tk,
                            tbp_bpjs_kesehatan,
                            tbp_lain,
                            ttl_tbp,
                            p_absensi,
                            p_keterlambatan,
                            p_koperasi,
                            p_asuransi_kesehatan,
                            p_bpjs_tk,
                            p_bpjs_kesehatan,
                            p_lain,
                            ttl_potongan,
                            gaji_diterima,
                            flag")
                ->from($this->table)
                ->where("id_company",$this->id_company);
    
        $column_search = array('nik','nama_karyawan','kode_cabang','nama_cabang','kode_departemen','nama_departemen','kode_jabatan','nama_jabatan');
        $i = 0;
    
        foreach ($column_search as $item){  // looping awal
            if($_GET['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST
                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                }else{
                    $this->db->or_like($item, $_GET['search']['value']);
                }
    
                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }
    
        $column_order = array('','nik','nama_karyawan',
                            'concat(kode_cabang,id)',
                            'concat(kode_departemen,id)',
                            'concat(kode_jabatan,id)',
                            'concat(gaji_pokok,id)',
                            'concat(t_jabatan,id)',
                            'concat(t_transport,id)',
                            'concat(t_makan,id)',
                            'concat(t_istri,id)',
                            'concat(t_anak,id)',
                            'concat(lembur,id)',
                            'concat(komisi,id)',
                            'concat(t_lain,id)',
                            'concat(ttl_tunjangan,id)',
                            'concat(ttl_penerimaan,id)',
                            'concat(tbp_bpjs_tk,id)',
                            'concat(tbp_bpjs_kesehatan,id)',
                            'concat(tbp_lain,id)',
                            'concat(ttl_tbp,id)',
                            'concat(p_absensi,id)',
                            'concat(p_keterlambatan,id)',
                            'concat(p_koperasi,id)',
                            'concat(p_asuransi_kesehatan,id)',
                            'concat(p_bpjs_tk,id)',
                            'concat(p_bpjs_kesehatan,id)',
                            'concat(p_lain,id)',
                            'concat(ttl_potongan,id)',
                            'concat(gaji_diterima,id)');
    
        if(isset($_GET['order'])){
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir'],false);
        } 
        else{            
            $this->db->order_by("kode_cabang","ASC", false);
            $this->db->order_by("kode_departemen","ASC", false);
            $this->db->order_by("kode_jabatan","ASC", false);
            $this->db->order_by("nik","ASC", false);
        }
    }

    public function getData($id=null){
        $this->db->select("*");
        $this->db->from("informasi_gaji_temp");
        $this->db->where("MD5(id)",$id);
        $this->db->where("id_company",$this->id_company);
        
        $result = $this->db->get();
        return $result->row();
    }

    public function getDataExisting($periode = null, $id_karyawan = null){
        $this->db->select("id");
        $this->db->from("informasi_gaji");
        $this->db->where("periode",$periode);
        $this->db->where("id_karyawan",$id_karyawan);
        $this->db->where("id_company",$this->id_company);
        
        $result = $this->db->get();
        return $result->num_rows();
    }

    public function update($data,$id = null){
        $this->db->where(array('md5(id)'=>$id, 'id_company'=>$this->id_company));
        $update = $this->db->update("informasi_gaji_temp",$data);
        return  __response_update($update);
    }

}