<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Gaji extends MY_Controller{

	public function __construct()
    {
        parent::__construct();
        $this->load->model('payroll/gaji/Komponen_m');
        $this->load->model('payroll/gaji/Gaji_m');
        $this->load->model('payroll/laporan_pph/Laporan_pph_m', 'laporan_pph');
        $this->load->helper(['pph21', 'payroll']);

    }

	public function index()
    {
		$data['judul'] = 'Hitung Gaji';
		$data['aktif'] = 'hitung_gaji';
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('payroll/gaji/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

    public function view($periode, $cabang, $departemen, $karyawan)
    {
        $data['periode']    = $periode;
        $data['cabang']     = $cabang;
        $data['departemen'] = $departemen;
        $data['karyawan']   = $karyawan;

        $data['komponen_tunj_tetap']     = $this->Komponen_m->master_trx(periode($periode), 'tetap', 'pendapatan');
        $data['komponen_tunj_tdk_tetap'] = $this->Komponen_m->master_trx(periode($periode), 'tidak tetap', 'pendapatan');
        $data['komponen_pot_tetap']      = $this->Komponen_m->master_trx(periode($periode), 'tetap', 'potongan');
        $data['komponen_pot_tdk_tetap']  = $this->Komponen_m->master_trx(periode($periode), 'tidak tetap', 'potongan');
        $this->load->view('payroll/gaji/view', $data);
    }

	public function list_data($bulan="", $id_cabang="all", $id_departemen="all", $id_karyawan="all")
    {
		$bulan = date_format(date_create("01-".$bulan),"Y-m");
		$list = $this->Gaji_m->get_datatables($bulan, $id_cabang, $id_departemen, $id_karyawan);
		$data = array();
		$no = $_GET['start'];
		foreach ($list as $field) {
			$no++;

			$row = array();
			$row[] = $no;
			$row[] = $field->nm_karyawan."<br><b>".$field->nik."</b>";
			$row[] = date("m-Y", strtotime($field->periode));
			$row[] = $field->nm_cabang."<br><b>".$field->kd_cabang."</b>";
			$row[] = $field->nm_departemen."<br><b>".$field->kd_departemen."</b>";
			$row[] = date("d-m-Y", strtotime($field->tgl_mulai)). '<br>s/d<br>' .date("d-m-Y", strtotime($field->tgl_selesai));
			$row[] = number_format($field->gapok,0,",",".");
            $data_tunj_tetap_trx = $this->Komponen_m->tunj_tetap_trx($bulan, $field->id_karyawan);
            if (count($data_tunj_tetap_trx->result()) > 0) {
                foreach($data_tunj_tetap_trx->result() as $val) {
                    $row[] = number_format($val->nominal_tunjangan,0,",",".");
                }
            }else{
                $row[] = 0;
            }
            $data_tunj_tdk_tetap_trx = $this->Komponen_m->tunj_tdk_tetap_trx($bulan, $field->id_karyawan);
            if (count($data_tunj_tdk_tetap_trx->result()) > 0) {
                foreach($data_tunj_tdk_tetap_trx->result() as $val) {
                    $row[] = number_format($val->nominal_tunjangan,0,",",".");
                }
            }else{
                $row[] = 0;
            }
			$row[] = number_format($field->ttl_tunjangan,0,",",".");
			$row[] = $field->lembur_menit;
			$row[] = number_format($field->lembur_per_jam,0,",",".");
			$row[] = number_format($field->lembur_rp,0,",",".");
            $data_pot_tetap_trx = $this->Komponen_m->pot_tetap_trx($bulan, $field->id_karyawan);
            if (count($data_pot_tetap_trx->result()) > 0) {
                foreach($data_pot_tetap_trx->result() as $val) {
                    $row[] = number_format($val->nominal_potongan,0,",",".");
                }
            }else{
                $row[] = 0;
            }
            $data_pot_tdk_tetap_trx = $this->Komponen_m->pot_tdk_tetap_trx($bulan, $field->id_karyawan);
            if (count($data_pot_tdk_tetap_trx->result()) > 0) {
                foreach($data_pot_tdk_tetap_trx->result() as $val) {
                    $row[] = number_format($val->nominal_potongan,0,",",".");
                }
            }else{
                $row[] = 0;
            }
			$row[] = number_format($field->pot_bpjs_kes,0,",",".");
			$row[] = number_format($field->pot_bpjs_tk,0,",",".");
			$row[] = number_format($field->pot_absensi_acc,0,",",".");
			$row[] = number_format($field->pot_pph21,0,",",".");
			$row[] = number_format($field->ttl_potongan,0,",",".");
			$row[] = number_format($field->thp,0,",",".");
            $row[] = number_format($field->tunj_bpjs_kes,0,",",".");
            $row[] = number_format($field->tunj_bpjs_tk,0,",",".");
			$row[] = number_format($field->ttl_tunj_dibiayai_perus,0,",",".");

			if ($field->publish_sch == "0000-00-00 00:00:00") {
				$row[] = "-";
			}else{
				$row[] = date("d-m-Y", strtotime($field->publish_sch));
			}

			if ($field->publish_tgl == "0000-00-00 00:00:00") {
				$row[] = "-";
			}else{
				$row[] = date("d-m-Y H:i:s", strtotime($field->publish_tgl));
			}

			if ($field->publish_user == '') {
				$checklist_publish = '';
				$btn 	= '<a href="#" id="'.md5($field->id_karyawan).'" bulan="'.$field->periode.'" class="btn_delete text-danger" title="HAPUS"><i class="fa fa-trash"></i></a>';
			}else{
				$checklist_publish = 'checked';
				$btn 	= '<a href="'.route('payroll.gaji.detail').'/'.md5($field->id_karyawan).'/'.$field->periode.'" class="btn_detail text-primary" title="DETAIL"><i class="fa fa-info-circle" aria-hidden="true"></i></a>';
			}

			$row[] 	= '<input class="btn_publish" id="'.md5($field->id_karyawan.$field->periode).'" type="checkbox" onclick="publish_unpublish(`'.md5($field->id_karyawan.$field->periode).'`)" publish="'.$field->publish_flag.'" '.$checklist_publish.' disabled>';
			$aksi 	= $btn;

			$row[] = $aksi;

			$data[] = $row;
		}

		$output = array("draw"            => $_GET['draw'],
						"recordsTotal"    => $this->Gaji_m->count_all($bulan, $id_cabang, $id_departemen, $id_karyawan),
						"recordsFiltered" => $this->Gaji_m->count_filtered($bulan, $id_cabang, $id_departemen, $id_karyawan),
						"data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

    public function detail($id="", $bulan="")
    {
		$data = $this->Gaji_m->get_datatables($bulan, $id_cabang="all", $id_departemen="all", $id);

        $data['judul'] = "Hitung Gaji Bulanan";
        $data['aktif'] = 'hitung_gaji';
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['data'] = $data[0];
		$data['tunj_tetap'] = $this->Gaji_m->tunjTetapKaryawan($id,$bulan);
		$data['tunj_tdk_tetap'] = $this->Gaji_m->tunjTdkTetapKaryawan($id,$bulan);
		$data['pot_tetap'] = $this->Gaji_m->potTetapKaryawan($id,$bulan);
		$data['pot_tdk_tetap'] = $this->Gaji_m->potTdkTetapKaryawan($id,$bulan);
		$data['content'] = $this->load->view('payroll/gaji/detail', $data, true);
		$this->load->view('main_template', $data, false);
    }

	public function form($id="")
    {
        $this->load->view('payroll/gaji/form');
	}

	public function form_publish($key = null)
    {
		$data['data'] = $this->Gaji_m->getDataById($key);
		$this->load->view('payroll/gaji/form_publish', $data);
	}

	public function hitung_gaji()
    {
        $this->load->model(['payroll/Pph21_m', 'payroll/gaji/Komponen_m']);

		$bulan 				= date_format(date_create("01-".$this->input->post('bulan')),"Y-m");
		$periode_mulai		= date_format(date_create($this->input->post('periode_mulai')),"Y-m-d");
		$periode_selesai	= date_format(date_create($this->input->post('periode_selesai')),"Y-m-d");
		$id_cabang 			= $this->input->post('id_cabang');
		$id_departemen 		= $this->input->post('id_departemen');
		$id_karyawan 		= $this->input->post('id_karyawan');

		// GET GAPOK
		$data_gapok = $this->Gaji_m->gapok();

		// GET TUNJANGAN TETAP
		$data_tunj_tetap = $this->Gaji_m->tunj_tetap();

        // GET TUNJANGAN TIDAK TETAP
		$data_tunj_tdk_tetap = $this->Gaji_m->tunj_tdk_tetap($bulan);

		// GET POTONGAN TETAP
		$data_pot_tetap = $this->Gaji_m->pot_tetap();

		// GET POTONGAN TIDAK TETAP
		$data_pot_tdk_tetap = $this->Gaji_m->pot_tdk_tetap($bulan);

        // GET POTONGAN ABSENSI
		$pengaturan_potongan = $this->Gaji_m->pengaturan_potongan();

		// GET TERLAMBAT
		if ($pengaturan_potongan['terlambat']['flag'] == '1') {
            $flag_persen_terlambat = $pengaturan_potongan['terlambat']['flag_persentase_gapok'];
            $persen_terlambat = $pengaturan_potongan['terlambat']['persentase'];
            $kelipatan_terlambat = $pengaturan_potongan['terlambat']['kelipatan'];
            $menit_terlambat = $pengaturan_potongan['terlambat']['menit'];
			$nominal_terlambat = $pengaturan_potongan['terlambat']['nominal_potongan'];
            $flag_terlambat = 1;
		}else{
            $menit_terlambat = 0;
            $flag_terlambat = 0;
        }
		// GET PC
		if ($pengaturan_potongan['pc']['flag'] == '1') {
            $flag_persen_pc = $pengaturan_potongan['pc']['flag_persentase_gapok'];
            $persen_pc = $pengaturan_potongan['pc']['persentase'];
            $kelipatan_pc = $pengaturan_potongan['pc']['kelipatan'];
            $menit_pc = $pengaturan_potongan['pc']['menit'];
			$nominal_pc = $pengaturan_potongan['pc']['nominal_potongan'];
            $flag_pc = 1;
        }else{
            $menit_pc = 0;
            $flag_pc = 0;
        }
		// GET TAP
		if ($pengaturan_potongan['tap']['flag'] == '1') {
            $flag_persen_tap = $pengaturan_potongan['tap']['flag_persentase_gapok'];
            $persen_tap = $pengaturan_potongan['tap']['persentase'];
            $nominal_tap = $pengaturan_potongan['tap']['nominal_potongan'];
            $flag_tap = 1;
		}else{
            $flag_tap = 0;
        }
		// GET ALPA
		if ($pengaturan_potongan['alpa']['flag'] == '1') {
            $flag_persen_alpa = $pengaturan_potongan['alpa']['flag_persentase_gapok'];
            $persen_alpa = $pengaturan_potongan['alpa']['persentase'];
            $nominal_alpa = $pengaturan_potongan['alpa']['nominal_potongan'];
            $flag_alpa = 1;
		}else{
            $flag_alpa = 0;
        }

        // GET TUNJ & POT BPJS KESEHATAN
		$data_bpjs_kes = $this->Gaji_m->bpjs_kes();

        // GET TUNJ & POT BPJS TK
		$data_bpjs_tk = $this->Gaji_m->bpjs_tk();

		// DATA KARYAWAN
		$data_absensi = $this->Gaji_m->data_absensi($id_cabang, $id_departemen, $id_karyawan, $periode_mulai, $periode_selesai, $menit_terlambat, $menit_pc);
        // JENIS PPH
        $jenis_pph = $this->Pph21_m->get_jenis();
		if ((count($data_absensi) > 0) && $data_absensi[0]->id_karyawan) {
            $data_gaji_karyawan        = [];
            $data_pot_absensi_karyawan = [];
            $data_pengaturan_potongan  = [];
            $data_pph21_karyawan       = [];
            $update_gaji_pph21         = [];
			foreach($data_absensi as $row) {
				// GAPOK
				$nominal_gapok		= $data_gapok[$row->id_karyawan]['nominal'];

				// TUNJANGAN
				$ttl_tunj_tetap		        = ($data_tunj_tetap[$row->id_karyawan]['nominal']) ? $data_tunj_tetap[$row->id_karyawan]['nominal'] : 0;
				$ttl_tunj_tdk_tetap         = ($data_tunj_tdk_tetap[$row->id_karyawan]['nominal']) ? $data_tunj_tdk_tetap[$row->id_karyawan]['nominal'] : 0;

                // PROTEKSI (TUNJANGAN DIIKUTSERTAKAN HITUNGAN POTONGAN ABSENSI)
                $ttl_tunj_tetap_maks	    = ($data_tunj_tetap[$row->id_karyawan]['proteksi']) ? $data_tunj_tetap[$row->id_karyawan]['proteksi'] : 0;
				$ttl_tunj_tdk_tetap_maks    = ($data_tunj_tdk_tetap[$row->id_karyawan]['proteksi']) ? $data_tunj_tdk_tetap[$row->id_karyawan]['proteksi'] : 0;
                $proteksi                   = ($ttl_tunj_tetap_maks + $ttl_tunj_tdk_tetap_maks);

				// POTONGAN
				$ttl_pot_tetap		= ($data_pot_tetap[$row->id_karyawan]) ? $data_pot_tetap[$row->id_karyawan] : 0;
				$ttl_pot_tdk_tetap	= ($data_pot_tdk_tetap[$row->id_karyawan]) ? $data_pot_tdk_tetap[$row->id_karyawan] : 0;

				// ASSIGN TOTAL POTONGAN ABSENSI
                $ttl_pot_absensi = 0;
				// POTONGAN TERLAMBAT
                $pot_absensi_t = 0;
                if ($flag_terlambat != 0) {
                    if ($flag_persen_terlambat != 0) {
                        $nominal_pot_dari_gapok = ($nominal_gapok*$persen_terlambat)/100;
                        if ($kelipatan_terlambat != 0) {
                            $ttl_pot_absensi += (floor($row->ttl_terlambat/$menit_terlambat)*$nominal_pot_dari_gapok);
                            $pot_absensi_t = (floor($row->ttl_terlambat/$menit_terlambat)*$nominal_pot_dari_gapok);
                        }else{
                            $ttl_pot_absensi += $row->terlambat*$nominal_pot_dari_gapok;
                            $pot_absensi_t = $row->terlambat*$nominal_pot_dari_gapok;
                        }
                    }else{
                        $nominal_pot_dari_gapok = $nominal_terlambat;
                        if ($kelipatan_terlambat != 0) {
                            $ttl_pot_absensi += (floor($row->ttl_terlambat/$menit_terlambat)*$nominal_terlambat);
                            $pot_absensi_t = (floor($row->ttl_terlambat/$menit_terlambat)*$nominal_terlambat);
                        }else{
                            $ttl_pot_absensi += $row->terlambat*$nominal_terlambat;
                            $pot_absensi_t = $row->terlambat*$nominal_terlambat;
                        }
                    }
                }
                $data_pengaturan_potongan['terlambat'] = [
                    'flag' => $flag_terlambat,
                    'nominal' => $nominal_pot_dari_gapok,
                    'menit' => $menit_terlambat,
                    'kelipatan' => $kelipatan_terlambat,
                ];

                // POTONGAN PC
                $pot_absensi_pc = 0;
                if ($flag_pc != 0) {
                    if ($flag_persen_pc != 0) {
                        $nominal_pot_dari_gapok = ($nominal_gapok*$persen_pc)/100;
                        if ($kelipatan_pc != 0) {
                            $ttl_pot_absensi += round(($row->ttl_pc/$menit_pc)*$nominal_pot_dari_gapok);
                            $pot_absensi_pc = round(($row->ttl_pc/$menit_pc)*$nominal_pot_dari_gapok);
                        }else{
                            $ttl_pot_absensi += $row->pc*$nominal_pot_dari_gapok;
                            $pot_absensi_pc = $row->pc*$nominal_pot_dari_gapok;
                        }
                    }else{
                        $nominal_pot_dari_gapok = $nominal_pc;
                        if ($kelipatan_pc != 0) {
                            $ttl_pot_absensi += round(($row->ttl_pc/$menit_pc)*$nominal_pc);
                            $pot_absensi_pc = round(($row->ttl_pc/$menit_pc)*$nominal_pc);
                        }else{
                            $ttl_pot_absensi += $row->pc*$nominal_pc;
                            $pot_absensi_pc = $row->pc*$nominal_pc;
                        }
                    }
                }
                $data_pengaturan_potongan['pc'] = [
                    'flag' => $flag_pc,
                    'nominal' => $nominal_pot_dari_gapok,
                    'menit' => $menit_pc,
                    'kelipatan' => $kelipatan_pc,
                ];

                // POTONGAN TAP
                $pot_absensi_tap = 0;
                if ($flag_tap != 0) {
                    if ($flag_persen_tap != 0) {
                        $nominal_pot_dari_gapok = ($nominal_gapok*$persen_tap)/100;
                        $ttl_pot_absensi += $row->tap*$nominal_pot_dari_gapok;
                        $pot_absensi_tap = $row->tap*$nominal_pot_dari_gapok;
                    }else{
                        $nominal_pot_dari_gapok = $nominal_tap;
                        $ttl_pot_absensi += $row->tap*$nominal_tap;
                        $pot_absensi_tap = $row->tap*$nominal_tap;
                    }
                }
                $data_pengaturan_potongan['tap'] = [
                    'flag' => $flag_tap,
                    'nominal' => $nominal_pot_dari_gapok,
                ];

				// POTONGAN ALPA
                $pot_absensi_alpa = 0;
                if ($flag_alpa != 0) {
                    if ($flag_persen_alpa != 0) {
                        $nominal_pot_dari_gapok = ($nominal_gapok*$persen_alpa)/100;
                        $ttl_pot_absensi += $row->alpa*$nominal_pot_dari_gapok;
                        $pot_absensi_alpa = $row->alpa*$nominal_pot_dari_gapok;
                    }else{
                        $nominal_pot_dari_gapok = $nominal_alpa;
                        $ttl_pot_absensi += $row->alpa*$nominal_alpa;
                        $pot_absensi_alpa = $row->alpa*$nominal_alpa;
                    }
                }
                $data_pengaturan_potongan['alpa'] = [
                    'flag' => $flag_alpa,
                    'nominal' => $nominal_pot_dari_gapok,
                ];

                // BPJS KESEHATAN
                if (count($data_bpjs_kes[$row->id_karyawan]) > 0) {
                    $tunj_bpjs_kes  = $data_bpjs_kes[$row->id_karyawan]['tunjangan'];
                    $pot_bpjs_kes   = $data_bpjs_kes[$row->id_karyawan]['potongan'];
                }else{
                    $tunj_bpjs_kes  = 0;
                    $pot_bpjs_kes   = 0;
                }

                // BPJS TK
                if (count($data_bpjs_tk[$row->id_karyawan]) > 0) {
                    $tunj_bpjs_tk  = $data_bpjs_tk[$row->id_karyawan]['tunjangan'];
                    $pot_bpjs_tk   = $data_bpjs_tk[$row->id_karyawan]['potongan'];
                }else{
                    $tunj_bpjs_tk  = 0;
                    $pot_bpjs_tk   = 0;
                }

				// TOTAL TUNJANGAN
				$ttl_tunjangan	= $ttl_tunj_tetap + $ttl_tunj_tdk_tetap;

                // LEMBUR
                $lembur_menit     = cek_empty($this->Gaji_m->ttl_lembur($row->id_karyawan, $periode_mulai, $periode_selesai));
                $lembur_per_menit = $data_gapok[$row->id_karyawan]['lembur_per_jam']/60;
                $lembur_rp        = round($lembur_menit*$lembur_per_menit);

				// TOTAL POTONGAN
                if ($ttl_pot_absensi > $proteksi) {
                    $ttl_pot_absensi_acc = $proteksi;
                }else{
                    $ttl_pot_absensi_acc = $ttl_pot_absensi;
                }
				$ttl_potongan	= $ttl_pot_tetap + $ttl_pot_tdk_tetap + $ttl_pot_absensi_acc + $pot_bpjs_kes + $pot_bpjs_tk;

                // GAJI KOTOR
                $gaji_kotor     = $nominal_gapok + $ttl_tunjangan + $lembur_rp;

				// THP
                $gaji_diterima	= $gaji_kotor - $ttl_potongan;

                if ($row->id_karyawan) {
                    $temp_data_gaji = [
                        "id_karyawan"             => $row->id_karyawan,
                        "nik"                     => $row->nik,
                        "nm_karyawan"             => $row->nm_karyawan,
                        "id_jabatan"              => $row->id_jabatan,
                        "kd_jabatan"              => $row->kd_jabatan,
                        "nm_jabatan"              => $row->nm_jabatan,
                        "id_cabang"               => $row->id_cabang,
                        "kd_cabang"               => $row->kd_cabang,
                        "nm_cabang"               => $row->nm_cabang,
                        "id_departemen"           => ($row->id_departemen) ? $row->id_departemen : '',
                        "kd_departemen"           => ($row->kd_departemen) ? $row->kd_departemen : '',
                        "nm_departemen"           => ($row->nm_departemen) ? $row->nm_departemen : '',
                        "periode"                 => $bulan,
                        "tgl_mulai"               => $periode_mulai,
                        "tgl_selesai"             => $periode_selesai,
                        "gapok"                   => $nominal_gapok,
                        "tunj_tetap_ttl"          => $ttl_tunj_tetap,
                        "tunj_tdk_tetap_ttl"      => $ttl_tunj_tdk_tetap,
                        "ttl_tunjangan"           => $ttl_tunjangan,
                        "lembur_menit"            => $lembur_menit,
                        "lembur_per_jam"          => $data_gapok[$row->id_karyawan]['lembur_per_jam'],
                        "lembur_rp"               => $lembur_rp,
                        "pot_tetap_ttl"           => $ttl_pot_tetap,
                        "pot_tdk_tetap_ttl"       => $ttl_pot_tdk_tetap,
                        "pot_absensi_pc"          => $pot_absensi_pc,
                        "pot_absensi_t"           => $pot_absensi_t,
                        "pot_absensi_a"           => $pot_absensi_alpa,
                        "pot_absensi_tap"         => $pot_absensi_tap,
                        "pot_absensi_mak"         => $proteksi,
                        "pot_absensi_actual"      => $ttl_pot_absensi,
                        "pot_absensi_acc"         => $ttl_pot_absensi_acc,
                        "tunj_bpjs_kes"           => $tunj_bpjs_kes,
                        "pot_bpjs_kes"            => $pot_bpjs_kes,
                        "tunj_bpjs_tk"            => $tunj_bpjs_tk,
                        "pot_bpjs_tk"             => $pot_bpjs_tk,
                        "ttl_potongan"            => $ttl_potongan,
                        "ttl_tunj_dibiayai_perus" => ($tunj_bpjs_kes + $tunj_bpjs_tk),
                        "thp"                     => $gaji_diterima,
                        "bank_rek"                => '',
                        "bank_nama"               => '',
                        "no_ktp"                  => $row->no_ktp,
                        "tanggungan"              => $row->tanggungan,
                        "npwp"                    => $row->npwp,
                        "publish_user"            => '',
                        "publish_sch"             => '',
                        "publish_tgl"             => '',
                        "id_company"              => $this->id_company,
                        "user_input"              => $this->nik_karyawan .' - '. $this->nm_karyawan
                    ];

                    $data_gaji_karyawan[]        = $temp_data_gaji;
                    $data_pot_absensi_karyawan[] = $this->Gaji_m->getPotAbsensi($row->id_cabang, $row->id_departemen, $row->id_karyawan, $bulan, $periode_mulai, $periode_selesai, $data_pengaturan_potongan);

                    // if($row->tanggungan != '') {
                    // }
                    $nominal_pph21               = [
                        'gapok'          => $nominal_gapok,
                        'tunj_lain'      => $data_tunj_tetap[$row->id_karyawan]['nominal_pph21']+$data_tunj_tdk_tetap[$row->id_karyawan]['nominal_pph21'],
                        'premi_asuransi' => cek_empty($data_bpjs_kes[$row->id_karyawan]['tunjangan']+$data_bpjs_tk[$row->id_karyawan]['premi_asuransi']),
                        'iuran_pensiun'  => cek_empty($data_bpjs_tk[$row->id_karyawan]['iuran_pensiun'])
                    ];
                    $temp_pph21            = $this->Pph21_m->get_pph21($row, $bulan, $nominal_pph21, $jenis_pph);
                    $data_pph21_karyawan[] = $temp_pph21;
                    if($jenis_pph == 'gross') {
                        $update_gaji_pph21[] = [
                            'id_karyawan'  => $row->id_karyawan,
                            'pot_pph21'    => $temp_pph21['pph21_non_dtp'],
                            'ttl_potongan' => $temp_data_gaji['ttl_potongan']+$temp_pph21['pph21_non_dtp'],
                            'thp'          => $temp_data_gaji['thp']-$temp_pph21['pph21_non_dtp']
                        ];
                    }
                }
			}
		}else{
			$message = ["message" => "<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Data tidak ditemukan</font>"];
			return __response_save(false, $message);
		}

        $this->db->trans_start();
        $this->Komponen_m->insert($bulan);
        $this->Gaji_m->save($data_gaji_karyawan, $data_pot_absensi_karyawan, $bulan, $id_cabang, $id_departemen, $id_karyawan);
        if(count($data_pph21_karyawan) > 0) {
            $this->Pph21_m->delete_pph($bulan, $id_cabang, $id_departemen, $id_karyawan);
            $this->db->insert_batch('payroll_pph21_trx', $data_pph21_karyawan);
            if(count($update_gaji_pph21) > 0) {
                $this->Pph21_m->update_gaji($update_gaji_pph21);
            }

        }
        $this->db->trans_complete();

		if($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return __response_save(false);
		}else{
			$this->db->trans_commit();
			$message = ["message"=>'<font color="#009900"><i class="fa fa-check-square">&nbsp;</i>Gaji bulan '.date('m-Y',strtotime($bulan.'-01')).' berhasil dihitung</font>'];
			return __response_save(true, $message);
		}
	}

	public function publish_all(){
		$bulan = date_format(date_create("01-".$this->input->post("bulan")),"Y-m");
		$jadwal = $this->input->post("jadwal");
		$jadwal = ($jadwal) ? date("Y-m-d", strtotime($jadwal)) : date("Y-m-d") ;

		$data = array(
            "publish_flag"  =>"1",
            "publish_user"	=> $this->nik_karyawan.' - '.$this->nm_karyawan,
            "publish_sch"   => $jadwal,
            "publish_tgl" 	=> date("Y-m-d H:i:s"),
            "user_update" 	=> $this->nik_karyawan.' - '.$this->nm_karyawan,
            "tgl_update" 	=> date("Y-m-d H:i:s"),
        );

		// $this->send_messageBroker('Informasi Gaji','Gaji Bulan '.$this->fungsi->get_bulan($periode).' Sudah dipublish', $periode);

        $this->db->where('periode',$bulan);
        $this->db->where('id_company',$this->id_company);
        $update = $this->db->update('payroll_gaji_trx',$data);
        if($update){
			$message = array("message"=>'<font color="#ffffff"><i class="fa fa-check-square">&nbsp;</i>Gaji periode '.date('m-Y',strtotime($bulan.'-01')).' berhasil di publish semua</font>');
			return __response_save(true,$message);
        }else{
            $message = array('message'=>'<font color="#ffffff"><i class="fa fa-exclamation-triangle">&nbsp;</i>Gaji periode '.date('m-Y',strtotime($bulan.'-01')).' gagal di publish semua</font>');
			return __response_save(false,$message);
        }
	}

	public function unpublish_all(){
		$bulan = date_format(date_create("01-".$this->input->post("bulan")),"Y-m");
		$data = array(
            "publish_flag"  =>"0",
            "publish_user"	=> "",
            "publish_sch"   => "",
            "publish_tgl" 	=> "",
            "user_update" 	=> $this->nik_karyawan.' - '.$this->nm_karyawan,
            "tgl_update" 	=> date("Y-m-d H:i:s")
        );

        $this->db->where('periode',$bulan);
        $this->db->where('id_company',$this->id_company);
        $update = $this->db->update('payroll_gaji_trx',$data);
        if($update){
			$message = array("message"=>'<font color="#ffffff"><i class="fa fa-check-square">&nbsp;</i>Gaji periode '.date('m-Y',strtotime($bulan.'-01')).' berhasil di unpublish semua</font>');
			return __response_save(true,$message);
        }else{
            $message = array('message'=>'<font color="#ffffff"><i class="fa fa-exclamation-triangle">&nbsp;</i>Gaji periode '.date('m-Y',strtotime($bulan.'-01')).' gagal di unpublish semua</font>');
			return __response_save(false,$message);
        }
	}

    public function publish_unpublish(){
		$key = $this->input->post("id");

		$this->db->select("id_karyawan, bulan");
		$this->db->where("md5(concat(id_karyawan,bulan))",$key);
		$data_karyawan = $this->db->get("payroll_gaji")->row();

		$publish = $this->input->post("publish");
		$data = array("flag_publish" => $publish,
						"tgl_publish" => date("Y-m-d H:i:s"),
						"user_publish" => $this->id_karyawan);

        $this->db->where(array('md5(concat(id_karyawan,bulan))'=>$key, 'id_company'=>$this->id_company));
        $update = $this->db->update('payroll_gaji',$data);
		if($update){
			if($publish == "1"){
				$message = array("message"=>'<font color="#ffffff"><i class="fa fa-check-square">&nbsp;</i>Gaji berhasil di publish</font>');
				// $this->send_messageBroker_perId('Informasi Gaji', 'Gaji Bulan '.$this->fungsi->get_bulan($data_karyawan->bulan).' Sudah dipublish', $data_karyawan->id_karyawan, $data_karyawan->bulan);
			}else{
				$message = array("message"=>'<font color="#ffffff"><i class="fa fa-check-square">&nbsp;</i>Gaji berhasil di unpublish</font>');
			}
			return __response_save(true,$message);
		}else{
			if($publish == "1"){
				$message = '<font color="#ffffff"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data gagal di publish</font>';
			}else{
				$message = '<font color="#ffffff"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data gagal di unpublish</font>';
			}
			return __response_save(false,$message);
		}
	}


	public function delete(){
		$id_karyawan = $this->input->post("id");
		$bulan = $this->input->post("bulan");

		$this->db->trans_start();

		// DELETE GAJI
		$this->db->where("md5(id_karyawan)",$id_karyawan);
		$this->db->where("periode",$bulan);
		$this->db->where("id_company",$this->id_company);
		$this->db->delete("payroll_gaji_trx");

		$where_update = [
			"md5(id_karyawan)"	=> $id_karyawan,
			"periode" 			=> $bulan,
			"id_company"		=> $this->id_company
		];

        // UPDATE POT TIDAK TETAP
		$this->db->update("payroll_pot_tdk_tetap_m",["flag_gaji"=>"1"], $where_update);
		$this->db->update("payroll_pot_tdk_tetap_m",["flag_gaji"=>"0"], $where_update);

		// UPDATE TUNJ TIDAK TETAP
		$this->db->update("payroll_tunj_tdk_tetap_m",["flag_gaji"=>"1"], $where_update);
		$this->db->update("payroll_tunj_tdk_tetap_m",["flag_gaji"=>"0"], $where_update);

		$this->db->trans_complete();

		if($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return __response_delete(false);
		}else{
			$this->db->trans_commit();
			$message = ["message"=>'<font color="#ffffff"><i class="fa fa-check-square">&nbsp;</i>Berhasil menghapus data gaji bulan '.date('m-Y',strtotime($bulan.'-01')).'</font>'];
			return __response_delete(true, $message);
		}
	}

	public function download_excel($bulan=null, $id_cabang = null, $id_departemen= null, $id_karyawan= null ){
		if ($id_cabang == 'undefined' || $id_departemen == 'undefined' || $id_karyawan == 'undefined') {
			$id_cabang = 'all';
			$id_departemen = 'all';
			$id_karyawan = 'all';
		}

		$bulan1 = $this->fungsi->get_bulan($bulan);
		$tahun = $this->fungsi->get_tahun($bulan);

		$bulan2 = date_format(date_create("01-".$bulan),"Y-m");

		$data["data"] = $this->Gaji_m->download_excel($bulan2, $id_cabang, $id_departemen, $id_karyawan);

		if($id_cabang == "all" && $id_departemen == "all" && $id_karyawan == "all"){
            $filename = "GAJI SEMUA CABANG";
        }else{
            $filename = "GAJI";
        }

        if($id_karyawan != "all"){
            $nama_karyawan = $this->db->select("nama_lengkap")
                                    ->from("data_karyawan")
                                    ->where("md5(id_karyawan)",$id_karyawan)
                                    ->where("id_company",$this->id_company)
                                    ->get()
                                    ->row("nama_lengkap");
            $filename .= " ".$nama_karyawan;
        }

        if($id_cabang != "all"){
            $nama_cabang = $this->db->select("nama")
                                    ->from("master_cabang")
                                    ->where("id_cabang",$id_cabang)
                                    ->where("id_company",$this->id_company)
                                    ->get()
                                    ->row("nama");

            $filename .= " CABANG ".$nama_cabang;
        }

        if($id_departemen != "all"){
            $nama_departemen = $this->db->select("nama")
                                    ->from("master_departemen")
                                    ->where("id_departemen",$id_departemen)
                                    ->where("id_company",$this->id_company)
                                    ->get()
                                    ->row("nama");

            $filename .= " DEPARTEMEN ".$nama_departemen;
        }

        $data["filename"]                = $filename;
        $data["periode"]                 = $bulan1." ".$tahun;
        $data['komponen_tunj_tetap']     = $this->Komponen_m->master_trx($bulan2, 'tetap', 'pendapatan');
        $count_komponen_tunj_tetap       = count($data['komponen_tunj_tetap']->result());
        $data['komponen_tunj_tdk_tetap'] = $this->Komponen_m->master_trx($bulan2, 'tidak tetap', 'pendapatan');
        $count_komponen_tunj_tdk_tetap   = count($data['komponen_tunj_tdk_tetap']->result());
        $data['komponen_pot_tetap']      = $this->Komponen_m->master_trx($bulan2, 'tetap', 'potongan');
        $count_komponen_pot_tetap        = count($data['komponen_pot_tetap']->result());
        $data['komponen_pot_tdk_tetap']  = $this->Komponen_m->master_trx($bulan2, 'tidak tetap', 'potongan');
        $count_komponen_pot_tdk_tetap    = count($data['komponen_pot_tdk_tetap']->result());

        $data['data_tunj_tetap_trx']     = json_decode($this->Komponen_m->tunj_tetap_trx($bulan2), true);
        $data['data_tunj_tdk_tetap_trx'] = json_decode($this->Komponen_m->tunj_tdk_tetap_trx($bulan2), true);
        $data['data_pot_tetap_trx']      = json_decode($this->Komponen_m->pot_tetap_trx($bulan2), true);
        $data['data_pot_tdk_tetap_trx']  = json_decode($this->Komponen_m->pot_tdk_tetap_trx($bulan2), true);

        $sb_view                         = $this->load->view('payroll/gaji/download_excel', $data, true);
        // echo $sb_view;exit;
        $total_komponen = $count_komponen_tunj_tetap+$count_komponen_tunj_tdk_tetap+$count_komponen_pot_tetap+$count_komponen_pot_tdk_tetap;

        $format_columns = [
            'A'  => ['width' => 5, 'align' => 'center', 'valign' => 'middle'],
            'B'  => ['align' => 'left', 'format'=>'text', 'valign' => 'middle'],
            'C'  => ['width' => 9,'align' => 'left', 'format'=>'text', 'valign' => 'middle'],
            'D'  => ['align' => 'left', 'format'=>'text', 'valign' => 'middle'],
            'E'  => ['align' => 'left', 'format'=>'text', 'valign' => 'middle'],
            'F'  => ['align' => 'center', 'valign' => 'middle'],
            'G'  => ['width' => 12, 'valign' => 'middle', 'format'=>'text', 'rupiah' => true],
        ];

        $initial_column = 'H';
        // KOMPONEN TUNJANGAN
        if ($count_komponen_tunj_tetap > 0) {
            for ($i = 0; $i < $count_komponen_tunj_tetap; $i++) {
                $format_columns[$initial_column] = ['width' => 20, 'valign' => 'middle', 'format'=>'text', 'rupiah' => true];
                $initial_column++;
            }
        }
        if ($count_komponen_tunj_tdk_tetap > 0) {
            for ($i = 0; $i < $count_komponen_tunj_tdk_tetap; $i++) {
                $format_columns[$initial_column] = ['width' => 20, 'valign' => 'middle', 'format'=>'text', 'rupiah' => true];
                $initial_column++;
            }
        }
        // TOTAL TUNJANGAN & LEMBUR
        for ($i=0; $i < 5; $i++) {
            $format_columns[$initial_column] = ['width' => 11, 'valign' => 'middle', 'format'=>'text', 'rupiah' => true];
            $initial_column++;
        }
        // KOMPONEN POTONGAN
        if ($count_komponen_pot_tetap > 0) {
            for ($i = 0; $i < $count_komponen_pot_tetap; $i++) {
                $format_columns[$initial_column] = ['width' => 20, 'valign' => 'middle', 'format'=>'text', 'rupiah' => true];
                $initial_column++;
            }
        }
        if ($count_komponen_pot_tdk_tetap > 0) {
            for ($i = 0; $i < $count_komponen_pot_tdk_tetap; $i++) {
                $format_columns[$initial_column] = ['width' => 20, 'valign' => 'middle', 'format'=>'text', 'rupiah' => true];
                $initial_column++;
            }
        }
        // NEXT COLUMN
        for ($i=0; $i < 10; $i++) {
            $format_columns[$initial_column] = ['width' => 12, 'valign' => 'middle', 'format'=>'text', 'rupiah' => true];
            $initial_column++;
        }
        // PUBLISH
        for ($i=0; $i < 3; $i++) {
            $format_columns[$initial_column] = ['width' => 15, 'align' => 'center', 'valign' => 'middle'];
            $initial_column++;
        }

        $c_length       = 24+$total_komponen;
        $param          = [
            'download'    => true,
            'cLength'     => $c_length,
            'file_name'   => strtoupper(str_replace(" ","_",$filename)),
            'paper_size'  => 'A4',
            'font-size'   => 9,
            // 'pagebreak'   => true,
            'page_margin' => ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
            'orientation' => 'potrait',
            'header'      => [
                '1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],

            ],
            'freezecolumn' => ['G7'],
            'thead'        => ['4', '5', '6'],
            'tbody'        => [
                'start'  => '4',
                'height' => 13,
                'column' => $format_columns,
                // 'wrap'   => ['H', 'I', 'N', 'O', 'P', 'U'],
            ],
        ];

        $this->load->library('PHPExcel/Excel');
        $this->excel->generateExcel($sb_view, $param);
	}

	public function download_pdf($token) {
		$this->load->library('mpdf');

		$slip = $this->Gaji_m->slip($token);
		if($slip->publish_flag == '0') {
			echo 'slip gaji belum dipublish';
			exit;
		} elseif(date('Y-m-d H:i:s') < $slip->publish_sch) {
			echo 'schedule publish slip gaji pada '.date('d-m-Y H:i:s');
			exit;
		}

		$data['data']           = $slip;
		$data['tunj_tetap']     = $this->Gaji_m->tunjTetapKaryawan($id,$bulan,$token);
		$data['tunj_tdk_tetap'] = $this->Gaji_m->tunjTdkTetapKaryawan($id,$bulan,$token);
		$data['pot_tetap']      = $this->Gaji_m->potTetapKaryawan($id,$bulan,$token);
		$data['pot_tdk_tetap']  = $this->Gaji_m->potTdkTetapKaryawan($id,$bulan,$token);
        // echo $this->db->last_query();exit;
		$html                   = $this->load->view('payroll/gaji/download_pdf', $data, true);

		$param['page_number']    = true;
		$param['show_watermark'] = false;
		$param['custom_font']    = false;
		$param['download']       = true;
        $param['nama_company']	 = 'www.absenku.com';
		$filename                = "SLIP GAJI BULAN ". date("m-Y", strtotime($slip->periode.'-01'))." ".$slip->nik." - ".$slip->nm_karyawan;
		$this->mpdf->generate($html,  $filename, 'A4', 'P', $param);

	}

    public function download_excel_bank($bulan="00-0000", $cabang="all", $departemen="all", $karyawan="all")
    {
        $bulanDefault = $bulan;
        $bulan = periode($bulan);
        // FILENAME
        $nama_bulan = substr($bulan, -2);
        if($karyawan != "all"){
            $nama_karyawan = $this->laporan_pph->nama_karyawan($karyawan);
            $filename      = "Daftar Transfer Bank ". $nama_karyawan;
        }else{
            if ($departemen != "all") {
                $nama_cab = $this->laporan_pph->nama_cabang($cabang);
                $nama_dep = $this->laporan_pph->nama_departemen($departemen);
                $nama     = "Daftar Transfer Bank Cabang ". $nama_cab . " Departemen " . str_replace("/","-",$nama_dep);
                $filename = $nama;
            } else {
                if($cabang != "all") {
                    $nama     = $this->laporan_pph->nama_cabang($cabang);
                    $filename = "Daftar Transfer Bank Cabang ". $nama . " Semua Departemen";
                } else {
                    $nama     = "Daftar Transfer Bank Semua Cabang";
                    $filename = $nama;
                }
            }
        }

		$bulan1 = $this->fungsi->get_bulan($bulanDefault);
		$tahun = $this->fungsi->get_tahun($bulanDefault);

        $data["filename"]                = $filename;
        $data["periode"]                 = $bulan1." ".$tahun;
		$data["data"]                    = $this->Gaji_m->download_excel_transfer_bank($bulan, $cabang, $departemen, $karyawan);
        $sb_view                         = $this->load->view('payroll/gaji/download_excel_transfer_bank', $data, true);

        $param          = [
            'download'    => true,
            'cLength'     => 5,
            'file_name'   => strtoupper(str_replace(" ","_", $filename).'_'.$bulan1),
            'paper_size'  => 'A4',
            'font-size'   => 9,
            // 'pagebreak'   => true,
            'page_margin' => ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
            'orientation' => 'potrait',
            'header'      => [
                '1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
            ],
            'freezecolumn' => ['A5'],
            'thead'        => ['4'],
            'tbody'        => [
                'start'  => '4',
                'height' => 15,
                'wrap'   => ['B', 'C'],
                'column' => [
                    'A'  => ['width' => 10, 'align' => 'center', 'valign' => 'middle'],
                    'B'  => ['align' => 'left', 'format'=>'text', 'valign' => 'middle'],
                    'C'  => ['align' => 'left', 'format'=>'text', 'valign' => 'middle'],
                    'D'  => ['rupiah' => true, 'format'=>'text', 'valign' => 'middle'],
                    'E'  => ['rupiah' => true, 'format'=>'text', 'valign' => 'middle'],
                    'F'  => ['rupiah' => true, 'format'=>'text', 'valign' => 'middle'],
                ],
            ],
        ];

        $this->load->library('PHPExcel/Excel');
        $this->excel->generateExcel($sb_view, $param);
    }
}
