<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Import extends MY_Controller {
  public function __construct() {
    parent::__construct();
    $this->load->model('payroll/bpjs/import_m', 'model');
	$this->load->model([
		'payroll/bpjs/Bpjs_kes_m',
		'payroll/bpjs/Bpjs_tk_m',
		'Data_diri_m',
		'payroll/bpjs/Bpjs_master_m',
		'payroll/Master_gapok_m',
	]);
    $this->load->library(['PHPExcel/Excel', 'PHPExcel/PHPExcel', 'Uploadfile']);
    $this->id_karyawan = $this->session->userdata('id_karyawan');
    $this->nama_user   = $this->session->userdata('nama_user');
    $this->id_company  = $this->session->userdata('id_company');
  }

  public function index(){
    $data['judul']   = 'Import Data BPJS';
    $data['aktif']   = 'bpjs';
    $data['menu']    = $this->load->view('main_menu', $data, true);
    $data['script']  = $this->load->view('payroll/bpjs/master/import/script', $data, true);
    $data['content'] = $this->load->view('payroll/bpjs/master/import/home', $data, true);
    $this->load->view('main_template', $data, false);
  }

  public function list_data() {
		$this->load->helper('numeric');
		
		$list = $this->model->get_datatables();
		$data = array();
		$no = $_GET['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = $field->nama_lengkap.'<br>'.$field->nik;
			$row[] = dec_to_num($field->ttl_gaji_terdaftar);
			$row[] = $field->no_bpjs_kes;
			$row[] = $field->jml_anak;
			$row[] = dec_to_num($field->bpjs_kes_tunj_perus_rp, 2);
			$row[] = dec_to_num($field->bpjs_kes_pot_kry_rp, 2);
			$row[] = $field->no_bpjs_tk;
			$row[] = dec_to_num($field->bpjs_tk_tunj_jht_perus_rp, 2);
			$row[] = dec_to_num($field->bpjs_tk_pot_jht_kry_rp, 2);
			$row[] = dec_to_num($field->bpjs_tk_tunj_jkk_rp, 2);
			$row[] = dec_to_num($field->bpjs_tk_tunj_jkm_rp, 2);
			$row[] = dec_to_num($field->bpjs_tk_tunj_jp_perus_rp, 2);
			$row[] = dec_to_num($field->bpjs_tk_pot_jp_kry_rp, 2);
			$row[] = dec_to_num($field->ttl_pot_karyawan, 2);
			$row[] = dec_to_num($field->ttl_tunj_dibiayai_perus, 2);
			$row[] = '<a class="text-warning" onclick="edit(\''.md5($field->id_karyawan).'\');"><i class="fa fa-edit"></i></a><br><a class="text-danger" onclick="hapus(\''.md5($field->id_karyawan).'\');"><i class="fa fa-trash"></i></a>';
			$row[] = $field->flag_import;
			$data[] = $row;
		}

		$output = array(
						"draw"            => $_GET['draw'],
						"recordsTotal"    => $this->model->count_all(),
						"recordsFiltered" => $this->model->count_filtered(),
						"data"            => $data
          );

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

  public function form_template_import(){
		$this->load->view('payroll/bpjs/master/import/form_template_import');
	}

  function download_template($id_cabang, $id_departemen){
    
    if($id_cabang != "-") {
      $nama_cabang = $this->db->select("nama")
                  ->from("master_cabang")
                  ->where("id_cabang",$id_cabang)
                  ->where("id_company",$this->id_company)
                  ->get()
                  ->row("nama");
      $nama_cabang = " Cabang ".$nama_cabang;
    } else {
      $nama_cabang = " Semua Cabang";
    }

		if($id_departemen != "-") {
			$nama_departemen = $this->db->select("nama")
								->from("master_departemen")
								->where("id_departemen",$id_departemen)
								->where("id_company",$this->id_company)
								->get()
								->row("nama");
      $nama_departemen = " Departemen ".$nama_departemen;
		}else{
      $nama_departemen = "";
    }

		$data['header']   = $header;
		$data['nama']     = "Template Import Data BPJS".$nama_cabang.$nama_departemen;
		$data_karyawan    = $this->model->getDataKaryawan($id_cabang, $id_departemen);
		$data['data']     = $data_karyawan;
		$output           = true;
		$data['is_excel'] = true;
		$sb_view = $this->load->view('payroll/bpjs/master/import/download', $data, $output);

		$param = [
			'download' => true,
			'cLength'    => 8,
			'file_name'    => strtoupper($data['nama']),
			'paper_size'	=> 'A4',
			'font-size'		=> 12,
			// 'pagebreak'		=> false,
			'page_margin'	=> ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
			'orientation'	=> 'potrait',
      		'header'    => [
				'1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
				'2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
				'3' => ['merge' => true]
			],
			'freezecolumn'	   => ['D5'],
			'thead'        => ['4'],
			'tbody'        => [
				'start' => '4',
				'height'	=> 30,
				'wrap' => ['E', 'F'],
				'column' => [
					'A'    => ['width' => 5, 'align' => 'center', 'valign' => 'middle'],
					'B'    => ['width' => 20, 'align' => 'left', 'valign' => 'middle','format'=>'text'],
					'C'    => ['width' => 40, 'valign' => 'middle'],
					'D'    => ['width' => 20,'format'=>'text', 'valign' => 'middle', 'rupiah' => true],
					'E'    => ['width' => 20,'format'=>'text', 'valign' => 'middle', 'rupiah' => true],
					'F'    => ['width' => 20,'format'=>'text', 'valign' => 'middle', 'rupiah' => true],
					'G'    => ['width' => 10, 'valign' => 'middle'],
					'H'    => ['width' => 0,'format'=>'text'],
					'I'    => ['width' => 0,'format'=>'text']
				],
			],
		];
		$this->excel->generateExcel($sb_view, $param);
	}

  public function import_data_excel() {
		if(!empty($_FILES['file']['name'])) {
            $fileUpload['fname']    = 'file';
            $fileUpload['location'] = 'template_master_bpjs';
            $fileUpload['allowed']  = 'xls|xlsx';
            $fileUpload['compress_image']  = false;

            $upload = $this->uploadfile->doUpload($fileUpload);
			if($upload["success"] == true){
				$dir_file = $this->config->item('base_upload').$upload['url'];
			}else{
				$message = ["message"=>$upload["message"]];
				return __response_save(false,$message);
			}
        }else{
			$message = ["message"=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data gagal import</font>'];
			return __response_save(false,["message"=>$message]);
        }

        try{
            $inputFileType = PHPExcel_IOFactory::identify($dir_file);
            $objReader 	   = PHPExcel_IOFactory::createReader($inputFileType);
            $objPHPExcel   = $objReader->load($dir_file);
        }catch(Exception $e){
			$message = ["message"=>'Error loading file "' . pathinfo($dir_file, PATHINFO_BASENAME) . '": ' . $e->getMessage()];
			return __response_save(false,["message"=>$message]);
        }
		
		$master_bpjs_kes = $this->model->master_bpjs_kes();
		$bpjs_kes_config = $this->Bpjs_kes_m->get_config();
		$bpjs_tk_config  = $this->Bpjs_tk_m->get_config();
		$highestRow      = $objPHPExcel->setActiveSheetIndex(0)->getHighestRow();
		$data_bpjs_kes	 = [];
		$data_bpjs_tk	 = [];
		
		// $highestColumm++;
		for ($row = 5; $row < $highestRow; $row++) {
			$gaji_daftar = $objPHPExcel->setActiveSheetIndex(0)->getCell("F".$row)->getValue();
			$jml_anak    = $objPHPExcel->setActiveSheetIndex(0)->getCell("G".$row)->getValue();
			$id_karyawan = $objPHPExcel->setActiveSheetIndex(0)->getCell("H". $row)->getValue();
			$id_cabang   = $objPHPExcel->setActiveSheetIndex(0)->getCell("I". $row)->getValue();
			if(empty($gaji_daftar)){
				$flag = '2';
			}elseif(in_array($id_karyawan, $master_bpjs_kes)) {
				$flag = '3';
			} else {
				$flag = '1';
			}

			if(!empty($id_karyawan)){
				$data_bpjs_kes_temp = array(
					'id_karyawan'        => $id_karyawan,
					'flag'               => $bpjs_kes_config->flag,
					'flag_import'        => $flag,
					'jml_anak'           => $jml_anak,
					'ttl_gaji_terdaftar' => $gaji_daftar,
					'tunj_perus_persen'  => $bpjs_kes_config->tunj_perus,
					'tunj_perus_rp'      => $bpjs_kes_config->flag == '1' ? $this->aturan_maksimal_gaji_bpjs_kes($gaji_daftar)*($bpjs_kes_config->tunj_perus/100) : 0,
					'pot_kry_persen'	 => $bpjs_kes_config->pot_kry,
					'id_company'         => $this->id_company,
					'user_input'         => $this->id_karyawan
				);

				if($jml_anak > 3) {
					$data_bpjs_kes_temp['pot_kry_rp'] = $bpjs_kes_config->flag == '1' ? $this->aturan_maksimal_gaji_bpjs_kes($gaji_daftar)*($jml_anak-2/100) : 0;
				} else {
					$data_bpjs_kes_temp['pot_kry_rp'] = $bpjs_kes_config->flag == '1' ? $this->aturan_maksimal_gaji_bpjs_kes($gaji_daftar)*($bpjs_kes_config->pot_kry/100) : 0;
				}

				$data_bpjs_tk_temp = [
					'id_karyawan'           => $id_karyawan,
					'ttl_gaji_terdaftar'    => $gaji_daftar,
					'tunj_jht_perus_persen' => $bpjs_tk_config->tunj_jht_perus,
					'tunj_jht_perus_rp'     => $bpjs_tk_config->flag_jht == '1' ? $gaji_daftar*($bpjs_tk_config->tunj_jht_perus/100) : 0,
					'pot_jht_kry_persen'    => $bpjs_tk_config->pot_jht_kry,
					'pot_jht_kry_rp'        => $bpjs_tk_config->flag_jht == '1' ? $gaji_daftar*($bpjs_tk_config->pot_jht_kry/100) : 0,
					'flag_jht'              => $bpjs_tk_config->flag_jht,
					'tunj_jkk_persen'       => $bpjs_tk_config->tunj_jkk,
					'tunj_jkk_rp'           => $bpjs_tk_config->flag_jkk == '1' ? $gaji_daftar*($bpjs_tk_config->tunj_jkk/100) : 0,
					'flag_jkk'              => $bpjs_tk_config->flag_jkk,
					'tunj_jp_perus_persen'  => $bpjs_tk_config->tunj_jp_perus,
					'tunj_jp_perus_rp'      => $bpjs_tk_config->flag_jp == '1' ? $this->aturan_maksimal_gaji_bpjs_tk_jp($gaji_daftar)*($bpjs_tk_config->tunj_jp_perus/100) : 0,
					'pot_jp_kry_persen'     => $bpjs_tk_config->pot_jp_kry,
					'pot_jp_kry_rp'         => $bpjs_tk_config->flag_jp == '1' ? $this->aturan_maksimal_gaji_bpjs_tk_jp($gaji_daftar)*($bpjs_tk_config->pot_jp_kry/100) : 0,
					'flag_jp'               => $bpjs_tk_config->flag_jp,
					'tunj_jkm_persen'       => $bpjs_tk_config->tunj_jkm,
					'tunj_jkm_rp'           => $bpjs_tk_config->flag_jkm == '1' ? $gaji_daftar*($bpjs_tk_config->tunj_jkm/100) : 0,
					'flag_jkm'              => $bpjs_tk_config->flag_jkm,
					'id_company'            => $this->id_company,
					'user_input'            => $this->id_karyawan
				];

				$data_bpjs_tk_temp['ttl_pot_karyawan']        = $data_bpjs_tk_temp['pot_jht_kry_rp']+$data_bpjs_tk_temp['pot_jp_kry_rp']+$data_bpjs_kes_temp['pot_kry_rp'];
				$data_bpjs_tk_temp['ttl_tunj_dibiayai_perus'] = $data_bpjs_kes_temp['tunj_perus_rp']+$data_bpjs_tk_temp['tunj_jht_perus_rp']+$data_bpjs_tk_temp['tunj_jkk_rp']+$data_bpjs_tk_temp['tunj_jp_perus_rp']+$data_bpjs_tk_temp['tunj_jkm_rp'];
				
				$data_bpjs_kes[] = $data_bpjs_kes_temp;
				$data_bpjs_tk[]  = $data_bpjs_tk_temp;
			}

		}
		
		$this->db->trans_start();
		$this->model->delete_bpjs_kes_temp_all();
		$this->model->delete_bpjs_tk_temp_all();
		$this->db->insert_batch('payroll_bpjs_kes_temp', $data_bpjs_kes);
		$this->db->insert_batch('payroll_bpjs_tk_temp', $data_bpjs_tk);
		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			$message = ["message"=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data gagal diimport</font>'];
			return __response_save(false,$message);
		}else{
			unlink($dir_file);
			$this->db->trans_commit();
			$message = ["message"=>'<font color="#009900"><i class="fa fa-check-square">&nbsp;</i>Data berhasil diimport</font>'];
			return __response_save(true,$message);
		}
	}

	private function aturan_maksimal_gaji_bpjs_kes($gaji) {
        if($gaji > 12000000) {
            return 12000000;
        } else {
            return $gaji;
        }
    }

	private function aturan_maksimal_gaji_bpjs_tk_jp($gaji) {
        if($gaji > 9559600) {
            return 9559600;
        } else {
            return $gaji;
        }
    }

	public function delete_all_temp(){
		$this->db->trans_start();
		$this->model->delete_bpjs_kes_temp_all();
		$this->model->delete_bpjs_tk_temp_all();
		$this->db->trans_complete();
		$delete = $this->db->trans_status();
		return __response_delete($delete);
	}

	public function form($id=null){
		$data['id']              = $id;
		$data['data_bpjs_kes']   = $this->Bpjs_kes_m->get_config();
		$data['data_bpjs_tk']    = $this->Bpjs_tk_m->get_config();
		$data['data_bpjs_kes_m'] = $this->model->get_data_bpjs_kes($id);
		$data['data_bpjs_tk_m']  = $this->model->get_data_bpjs_tk($id);
		$data['data_diri']       = $this->Data_diri_m->getDataById($id);
		$data_gapok              = $this->Master_gapok_m->getDataById($id)->nominal;
		$data_tunj_tetap         = $this->Bpjs_master_m->get_ttl_tunj_tetap($data['data_diri']->id_karyawan);
		$data['data_gapok']      = $data_gapok      == null ? 0 : $data_gapok;
		$data['data_tunj_tetap'] = $data_tunj_tetap == null ? 0 : $data_tunj_tetap;
		$this->load->view('payroll/bpjs/master/import/form', $data);
	}

	public function save() {
		$this->load->helper('numeric');
		
		$id = $this->input->post('id');
		$update = $this->model->update($id);
		__response_update($update);
	}

	public function delete() {
		$id = $this->input->post('id');
		$this->db->trans_start();
		$this->model->delete_bpjs_kes_temp($id);
		$this->model->delete_bpjs_tk_temp($id);
		$this->db->trans_complete();
		$delete = $this->db->trans_status();
		__response_delete($delete);
	}

	public function publish_all(){
		$data_insert_bpjs_kes      = [];
		$data_insert_bpjs_tk       = [];
		$data_update_bpjs_kes_temp = [];
		$data_update_bpjs_kes      = [];
		$data_update_bpjs_tk       = [];
		$data_bpjs                 = $this->model->get_data_bpjs_temp();

		foreach($data_bpjs as $rows){
			if($rows->flag_import == 1) {
				array_push($data_insert_bpjs_kes, [
					'id_karyawan'        => $rows->id_karyawan,
					'flag'               => $rows->flag,
					'jml_anak'           => $rows->jml_anak,
					'ttl_gaji_terdaftar' => $rows->ttl_gaji_terdaftar,
					'tunj_perus_persen'  => $rows->tunj_perus_persen,
					'tunj_perus_rp'      => $rows->tunj_perus_rp,
					'pot_kry_persen'     => $rows->pot_kry_persen,
					'pot_kry_rp'         => $rows->pot_kry_rp,
					'id_company'         => $this->id_company,
					'user_input'         => $this->id_karyawan."-".$this->nama_user
				]);

				array_push($data_insert_bpjs_tk, [
					'id_karyawan'             => $rows->id_karyawan,
					'ttl_gaji_terdaftar'      => $rows->ttl_gaji_terdaftar,
					'tunj_jht_perus_persen'   => $rows->tunj_jht_perus_persen,
					'tunj_jht_perus_rp'       => $rows->tunj_jht_perus_rp,
					'pot_jht_kry_persen'      => $rows->pot_jht_kry_persen,
					'pot_jht_kry_rp'          => $rows->pot_jht_kry_rp,
					'flag_jht'                => $rows->flag_jht,
					'tunj_jkk_persen'         => $rows->tunj_jkk_persen,
					'tunj_jkk_rp'             => $rows->tunj_jkk_rp,
					'flag_jkk'                => $rows->flag_jkk,
					'tunj_jp_perus_persen'    => $rows->tunj_jp_perus_persen,
					'tunj_jp_perus_rp'        => $rows->tunj_jp_perus_rp,
					'pot_jp_kry_persen'       => $rows->pot_jp_kry_persen,
					'pot_jp_kry_rp'           => $rows->pot_jp_kry_rp,
					'flag_jp'                 => $rows->flag_jp,
					'tunj_jkm_persen'         => $rows->tunj_jkm_persen,
					'tunj_jkm_rp'             => $rows->tunj_jkm_rp,
					'flag_jkm'                => $rows->flag_jkm,
					'ttl_pot_karyawan'        => $rows->ttl_pot_karyawan,
					'ttl_tunj_dibiayai_perus' => $rows->ttl_tunj_dibiayai_perus,
					'id_company'              => $this->id_company,
					'user_input'              => $this->id_karyawan."-".$this->nama_user
				]);
			} elseif($rows->flag_import == 3) {
				array_push($data_update_bpjs_kes, [
					'id_karyawan'        => $rows->id_karyawan,
					'flag'               => $rows->flag,
					'jml_anak'           => $rows->jml_anak,
					'ttl_gaji_terdaftar' => $rows->ttl_gaji_terdaftar,
					'tunj_perus_persen'  => $rows->tunj_perus_persen,
					'tunj_perus_rp'      => $rows->tunj_perus_rp,
					'pot_kry_persen'     => $rows->pot_kry_persen,
					'pot_kry_rp'         => $rows->pot_kry_rp,
					'user_update'        => $rows->id_karyawan."-".$rows->nama_user,
					'tgl_update'         => date('Y-m-d H:i:s')
				]);

				array_push($data_update_bpjs_tk, [
					'id_karyawan'             => $rows->id_karyawan,
					'ttl_gaji_terdaftar'      => $rows->ttl_gaji_terdaftar,
					'tunj_jht_perus_persen'   => $rows->tunj_jht_perus_persen,
					'tunj_jht_perus_rp'       => $rows->tunj_jht_perus_rp,
					'pot_jht_kry_persen'      => $rows->pot_jht_kry_persen,
					'pot_jht_kry_rp'          => $rows->pot_jht_kry_rp,
					'flag_jht'                => $rows->flag_jht,
					'tunj_jkk_persen'         => $rows->tunj_jkk_persen,
					'tunj_jkk_rp'             => $rows->tunj_jkk_rp,
					'flag_jkk'                => $rows->flag_jkk,
					'tunj_jp_perus_persen'    => $rows->tunj_jp_perus_persen,
					'tunj_jp_perus_rp'        => $rows->tunj_jp_perus_rp,
					'pot_jp_kry_persen'       => $rows->pot_jp_kry_persen,
					'pot_jp_kry_rp'           => $rows->pot_jp_kry_rp,
					'flag_jp'                 => $rows->flag_jp,
					'tunj_jkm_persen'         => $rows->tunj_jkm_persen,
					'tunj_jkm_rp'             => $rows->tunj_jkm_rp,
					'flag_jkm'                => $rows->flag_jkm,
					'ttl_pot_karyawan'        => $rows->ttl_pot_karyawan,
					'ttl_tunj_dibiayai_perus' => $rows->ttl_tunj_dibiayai_perus,
					'user_update'             => $rows->id_karyawan."-".$rows->nama_user,
					'tgl_update'              => date('Y-m-d H:i:s')
				]);
			}

			array_push($data_update_bpjs_kes_temp, [
				'id_karyawan' => $rows->id_karyawan,
				'flag_import' => 4
			]);
		}
		
		$this->db->trans_start();
		if(count($data_insert_bpjs_kes) > 0) {
			$this->db->insert_batch('payroll_bpjs_kes_m', $data_insert_bpjs_kes);
		}
		if(count($data_insert_bpjs_tk) > 0) {
			$this->db->insert_batch('payroll_bpjs_tk_m', $data_insert_bpjs_tk);
		}
		if(count($data_update_bpjs_kes) > 0) {
			$this->db->where('id_company', $this->id_company);
			$this->db->update_batch('payroll_bpjs_kes_m', $data_update_bpjs_kes, 'id_karyawan');
		}
		if(count($data_update_bpjs_tk) > 0) {
			$this->db->where('id_company', $this->id_company);
			$this->db->update_batch('payroll_bpjs_tk_m', $data_update_bpjs_tk, 'id_karyawan');
		}
		if(count($data_update_bpjs_kes_temp) > 0) {
			$this->db->where('id_company', $this->id_company);
			$this->db->update_batch('payroll_bpjs_kes_temp', $data_update_bpjs_kes_temp, 'id_karyawan');
		}
		$this->db->trans_complete();

		if($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return __response_save(false);
		}else{
			$this->db->trans_commit();
			return __response_save(true);
		}
	}
}