<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Kepala_departemen extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('Kepala_departemen_m');
    }

	public function index(){
		$data['judul'] = 'Pengaturan Kepala Departemen';
		$data['aktif'] = 'kepala_departemen';
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('pengaturan/kepala_departemen/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function list_data(){
		$list = $this->Kepala_departemen_m->get_datatables();
		$data = array();
		$no = $_GET['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = $field->nik." - ".$field->nama_lengkap;
			$row[] = $field->kode_cabang." - ".$field->nama_cabang;

			if($field->jumlah_departemen > 1){
				$data_departemen = $this->Kepala_departemen_m->getDataDepartemen(md5($field->id_karyawan));
				
				$departemen = "";
				foreach($data_departemen as $rows){
					if($rows->flag == "1"){
						$badge = "badge-secondary";
					}else{
						$badge = "badge-primary";
					}

					$departemen .= "<h6 class='badge ".$badge."'>".$rows->kode." - ".$rows->nama."</h6>";
					$departemen .=" ";
					
				}
			}else{
				$departemen = "<label class='badge badge-secondary'>".$field->kode_departemen." - ".$field->nama_departemen."</label>";
			}
			
			$row[] = $departemen;

			if(in_array($this->level_user, array("1","5"))) {
				$row[] = '<a href="#" class="text-warning" title="EDIT">
							<i id="'.md5($field->id_karyawan).'" class="btn_edit fa fa-edit (alias) "> </i></a>';
			}
	
			$data[] = $row;
		}
	
			$output = array("draw"            => $_GET['draw'],
							"recordsTotal"    => $this->Kepala_departemen_m->count_all(),
							"recordsFiltered" => $this->Kepala_departemen_m->count_filtered(),
							"data"            => $data);
	
		$output = __response($this->MY_response, $output);
				
		echo json_encode($output);
	}

	public function form($id_karyawan=null){
		$data_karyawan = $this->Kepala_departemen_m->getKaryawan($id_karyawan);
		$data["karyawan"] = $data_karyawan;
		$data["departemen"] = $this->Kepala_departemen_m->getDataDepartemen($id_karyawan);

		$this->load->view('pengaturan/kepala_departemen/form',$data);	
	}

	public function update(){
		$id_karyawan = $this->input->post('id_karyawan');
		$data_departemen = $this->input->post('data_departemen');
		$data_insert = [];

		$nextId = $this->fungsi->getNextId('p_kedep','id',$this->id_company,3);
		$nomor_urut = substr($nextId,-3);
		foreach($data_departemen as $rows){
			$id = substr_replace($nextId,(sprintf("%03d",$nomor_urut)),-3);

			$data_insert[] = array("id" =>$id,
								"id_karyawan" => $id_karyawan,
								"id_cabang" => $rows["cabang"],
								"id_departemen" => $rows["departemen"],
								"id_company" => $this->id_company);

			$nomor_urut++;
		}
	
		$this->Kepala_departemen_m->update($data_insert,$id_karyawan); 
	}
}
