<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Departemen extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('Departemen_m');
    }

	public function index(){
		$data['judul'] = 'Departemen';
		$data['aktif'] = 'departemen';
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('departemen/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function list_data(){
		$list = $this->Departemen_m->get_datatables();
		$data = array();
		$no = $_GET['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = $field->kode;
			$row[] = $field->nama;

            if(in_array($this->session->userdata('level_user'), array("1"))) {

				$row[] = '<a href="#" class="text-warning" title="EDIT">
							<i id="'.md5($field->id_departemen).'" class="btn_edit fa fa-edit (alias) "> </i></a>&nbsp;
						<a href="#" class="text-danger" title="HAPUS">
							<i id="'.md5($field->id_departemen).'" class="btn_delete fa fa-trash"></i>
						</a>';
			}
	
			$data[] = $row;
		}
	
			$output = array("draw"            => $_GET['draw'],
							"recordsTotal"    => $this->Departemen_m->count_all(),
							"recordsFiltered" => $this->Departemen_m->count_filtered(),
							"data"            => $data);
	
		$output = __response($this->MY_response, $output);
				
		echo json_encode($output);
	}

	public function form($id=null){
		if($id==null){
			$this->load->view('departemen/form');
		}else{
			$data['data'] = $this->Departemen_m->getDataById($id);
			$this->load->view('departemen/form',$data);
		}
		
	}

	public function save(){
		$id = $this->input->post('id_departemen');
	
		$data = array('kode'		=>$this->input->post('kd_departemen'),
					'nama'			=>$this->input->post('nm_departemen'),
					'id_company' 	=>$_SESSION['id_company']);
	
		$this->Departemen_m->save($data,$id); 
	}

	public function delete(){
		$id = $this->input->post("id_departemen");
		$this->Departemen_m->delete($id);
	}
}
