<script type="text/javascript">
    $(document).ready(function() {
        tanggal();
        list_data();
        dropdown_karyawan();
        dropdown_cabang();
        dropdown_departemen();

        $('#btn_cari').click(function(){
            var value = $('#btn_cari').val();

            var id_cabang       = "all";
            var id_departemen   = "all";
            var id_karyawan     = ($("#karyawan").val() == null)?"all":$("#karyawan").val();
            var tanggal_mulai   = ($("#tanggal_mulai").val() == null)?"00-00-0000":$("#tanggal_mulai").val();
            var tanggal_selesai = ($("#tanggal_selesai").val() == null)?"00-00-0000":$("#tanggal_selesai").val();

            var loading = Ladda.create(this);
            loading.start();

            if(value == "habis_masa_kerja"){
                list_data_habis_masa_kerja.ajax.url("<?= route('pkwt.kayawan.tabs.content.habis.masa.kerja') ?>"+"/"+tanggal_mulai+"/"+tanggal_selesai+"/"+id_cabang+"/"+id_departemen+"/"+id_karyawan)
                list_data_habis_masa_kerja.ajax.reload(function(){
                    loading.stop();
                });
            }else if(value == "draft_pkwt"){
                list_data_draft_pkwt.ajax.url("<?= route('pkwt.kayawan.tabs.content.draft.pkwt') ?>"+"/"+tanggal_mulai+"/"+tanggal_selesai+"/"+id_cabang+"/"+id_departemen+"/"+id_karyawan)
                list_data_draft_pkwt.ajax.reload(function(){
                    loading.stop();
                });
            }else if(value == "verifikasi"){
                list_data_verifikasi.ajax.url("<?= route('pkwt.kayawan.tabs.content.verifikasi') ?>"+"/"+tanggal_mulai+"/"+tanggal_selesai+"/"+id_cabang+"/"+id_departemen+"/"+id_karyawan)
                list_data_verifikasi.ajax.reload(function(){
                    loading.stop();
                });
            }
        });

        $('#btn_filter').click(function(){
            var value = $('#btn_cari').val();

            var id_cabang       = ($("#cabang").val() == null)?"all":$("#cabang").val();
            var id_departemen   = ($("#departemen").val() == null)?"all":$("#departemen").val();
            var id_karyawan     = "all";
            var tanggal_mulai   = ($("#tanggal_mulai").val() == null)?"00-00-0000":$("#tanggal_mulai").val();
            var tanggal_selesai = ($("#tanggal_selesai").val() == null)?"00-00-0000":$("#tanggal_selesai").val();

            var loading = Ladda.create(this);
            loading.start();

            if(value == "habis_masa_kerja"){
                list_data_habis_masa_kerja.ajax.url("<?= route('pkwt.kayawan.tabs.content.habis.masa.kerja') ?>"+"/"+tanggal_mulai+"/"+tanggal_selesai+"/"+id_cabang+"/"+id_departemen+"/"+id_karyawan)
                list_data_habis_masa_kerja.ajax.reload(function(){
                    loading.stop();
                });
            }else if(value == "draft_pkwt"){
                list_data_draft_pkwt.ajax.url("<?= route('pkwt.kayawan.tabs.content.draft.pkwt') ?>"+"/"+tanggal_mulai+"/"+tanggal_selesai+"/"+id_cabang+"/"+id_departemen+"/"+id_karyawan)
                list_data_draft_pkwt.ajax.reload(function(){
                    loading.stop();
                });
            }else if(value == "verifikasi"){
                list_data_verifikasi.ajax.url("<?= route('pkwt.kayawan.tabs.content.verifikasi') ?>"+"/"+tanggal_mulai+"/"+tanggal_selesai+"/"+id_cabang+"/"+id_departemen+"/"+id_karyawan)
                list_data_verifikasi.ajax.reload(function(){
                    loading.stop();
                });
            }
        });
    });

    function tanggal() {
        var d = new Date();
        d.setDate(d.getDate()); // - 1
        $('.input-daterange input').each(function() {
            $(this).datepicker({
                orientation: "bottom",
                format: "dd-mm-yyyy",
                // endDate: d,
                autoclose: true,
            });
        });
    }

    function list_data() {
        $('#btn_cari').val('habis_masa_kerja');
        $('#btn_filter').val('habis_masa_kerja');
        $('#tab_content').load("<?= route('pkwt.tabs')."/habis_masa_kerja" ?>");
    }

    $(document).on('click','#tabs_habis_masa_kerja',function(){
        $('#tab_content').load("<?= route('pkwt.tabs')."/habis_masa_kerja" ?>");
        $('#btn_cari').val('habis_masa_kerja');
        $('#btn_filter').val('habis_masa_kerja');
    });
    $(document).on('click','#tabs_draft_pkwt',function(){
        $('#tab_content').load("<?= route('pkwt.tabs')."/draft_pkwt" ?>");
        $('#btn_cari').val('draft_pkwt');
        $('#btn_filter').val('draft_pkwt');
    });
    $(document).on('click','#tabs_verifikasi',function(){
        $('#tab_content').load("<?= route('pkwt.tabs')."/verifikasi" ?>");
        $('#btn_cari').val('verifikasi');
        $('#btn_filter').val('verifikasi');
    });

    function dropdown_karyawan() {
        $('#karyawan').select2({
            placeholder: 'Semua Karyawan',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.karyawan")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    function dropdown_cabang(){
        $('#cabang').select2({
            placeholder: 'Semua Cabang',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.cabang")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    function onchange_dropdown_cabang(){
        $("#departemen").val('').trigger('change');
        dropdown_departemen();
    }

    function dropdown_departemen(){

        var level_user = '<?= $level_user ?>';
        var multi_cabang = '<?= $multi_cabang ?>';
        if(level_user == "1" || level_user == "4" || (level_user == 5 && multi_cabang == true)){
            var id_cabang = $("#cabang").val();
        }else{
            var id_cabang = '<?= $this->session->userdata('id_cabang') ?>';
        }

        $("#departemen").select2({
            placeholder: "Semua Departemen",
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.departemen.by.cabang") ?>'+'/'+id_cabang,
                dataType: 'json',
                delay: 250,
                processResults:function(data) {
                    return {
                            results: data
                        };
                },
                cache: false
            }
        });
    }

    function dropdown_template() {
        $("#template").select2({
            placeholder   : "Semua Template",
            allowClear    : true,
            dropdownParent: $('#tampil_form_pkwt'),
            ajax          : {
                url: '<?= route("dropdown.pkwt.template") ?>',
                dataType: 'json',
                delay: 250,
                processResults:function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }

    function show_parameter(id_template, id_pkwt) {
        $('#parameter').load('<?= route("pkwt.baru.form.parameter", ["id_template" => "'+id_template+'", "id_pkwt" => "'+id_pkwt+'"]) ?>');
    }

    $(document).on('click','.btn_tambah_pkwt',function(){
        event.preventDefault();
        $('#tampil_form_pkwt').load("<?= route('pkwt.form.tambah') ?>"+"/"+$(this).attr('id'),function(){
            $('#modal_form_pkwt').modal('show');
            $(".title").text("Form Tambah Data");
            $(".btn_save").addClass("btn_save btn btn-primary");
            $(".btn_save").append('<i class="fa fa-save"></i> ');
            $(".btn_save").append('SIMPAN');
            $("#btn_new_input").hide();
            dropdown_template();
        });
    });

    $(document).on('click','.btn_edit_pkwt',function(){
        event.preventDefault();
        $('#tampil_form_pkwt').load("<?= route('pkwt.form.edit') ?>"+"/"+$(this).attr('id'),function(){
            $('#modal_form_pkwt').modal('show');
            $(".title").text("Form Tambah Data");
            $(".btn_save").addClass("btn_save btn btn-primary");
            $(".btn_save").append('<i class="fa fa-save"></i> ');
            $(".btn_save").append('PERBARUI');
            $("#btn_new_input").hide();
        });
    });

    // ACTION SAVE/EDIT
    $(document).on("click",".btn_save",function(e){
        e.preventDefault();
        $('#tampil_form_pkwt #message').html("");
        var loading = Ladda.create(this);

        var valid_tgl_pkwt          =  document.getElementById("form_input_tanggal_pkwt").value;
        var valid_tgl_pkwt_mulai    =  document.getElementById("form_input_tanggal_mulai").value;
        var valid_tgl_pkwt_selesai  =  document.getElementById("form_input_tanggal_selesai").value;

        if($('#template').val() == null){
            $('#tampil_form_pkwt #message').show();
            $('#tampil_form_pkwt #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Template harus dipilih</font>");
            $("#template").focus();
            return false;
        } else if(valid_tgl_pkwt==""){
            $('#tampil_form_pkwt #message').show();
            $('#tampil_form_pkwt #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Tanggal pkwt harus diisi</font>");
            $("#tampil_form_pkwt #form_input_tanggal_pkwt").focus();
            return false;
        }else if(valid_tgl_pkwt_mulai==""){
            $('#tampil_form_pkwt #message').show();
            $('#tampil_form_pkwt #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Tanggal mulai kontrak harus diisi</font>");
            $("#tampil_form_pkwt #form_input_tanggal_mulai").focus();
            return false;
        }else if(valid_tgl_pkwt_selesai==""){
            $('#tampil_form_pkwt #message').show();
            $('#tampil_form_pkwt #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Tanggal selesai kontrak harus diisi</font>");
            $("#tampil_form_pkwt #form_input_tanggal_selesai").focus();
            return false;
        }

        const parameter = $('input[name^="param_"]').toArray();
        for(let i = 0; i < parameter.length; i++) {
            if(parameter[i].value == ""){
                const name = parameter[i].name.replace("param_", "");
                $('#tampil_form_pkwt #message').show();
                $('#tampil_form_pkwt #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> "+name+" harus diisi</font>");
                $("input[name='param_"+name+"']").focus();
                return false;
            }
        }

        loading.start();
    
        var param                      = {};
            param.id_pkwt              = document.getElementById("form_input_id_pkwt").value;
            param.id_karyawan          = document.getElementById("form_input_id_karyawan").value;
            param.nik                  = document.getElementById("form_input_nik").value;
            param.nm_karyawan          = document.getElementById("form_input_nm_karyawan").value;
            param.lahir_tempat         = document.getElementById("form_input_lahir_tempat").value;
            param.lahir_tgl            = document.getElementById("form_input_lahir_tgl").value;
            param.alamat               = document.getElementById("form_input_alamat").value;
            param.nm_level_user        = document.getElementById("form_input_nm_level_user").value;
            param.nm_jabatan           = document.getElementById("form_input_nm_jabatan").value;
            param.nm_departemen        = document.getElementById("form_input_nm_departemen").value;
            param.nm_cabang            = document.getElementById("form_input_nm_cabang").value;
            param.id_template          = $('#template').val();
            param.nm_draft_pkwt        = $("#form_input_nm_draft_pkwt").val()        != "" ? $("#form_input_nm_draft_pkwt").val() : $('#template').select2('data')[0].template;
            param.draft_pkwt_parameter = $("#form_input_draft_pkwt_parameter").val() != "" ? decodeURI($("#form_input_draft_pkwt_parameter").val()) : $('#template').select2('data')[0].parameter;
            param.tgl_pkwt             = valid_tgl_pkwt;
            param.tgl_pkwt_mulai       = valid_tgl_pkwt_mulai;
            param.tgl_pkwt_selesai     = valid_tgl_pkwt_selesai;

        for(let i = 0; i < parameter.length; i++) {
            param[parameter[i].name] = parameter[i].value;
        }

        $.ajax({
            type: 'POST',
            url: "<?= route('pkwt.save') ?>",
            data: param,
            dataType:'JSON',
            success: function(result) {
                if(result.success == true){
                    if(result.type == 'save'){
                        $('#modal_form_pkwt').modal('hide');
                        $('#modal_alert_pkwt').modal('show');
                        $('#modal_alert_pkwt #icon_success').show();
                        $('#modal_alert_pkwt #icon_fail').hide();
                        $('#modal_alert_pkwt #keterangan_alert').html("Data PKWT telah berhasil ditambahkan ke Draft PKWT");
                        setTimeout(function() {
                            $('#modal_alert_pkwt').modal('hide');
                        }, 3000);
                    }else if(result.type == 'update'){
                        $('#tab_content').load("<?= route('pkwt.tabs')."/draft_pkwt" ?>");
                    }
                }
                loading.stop();
                $('#tampil_form_pkwt #message').show();
                $('#tampil_form_pkwt #message').html(result.message);
            },
            error:function(){
                loading.stop();
                $('#tampil_form_pkwt #message').show();
                $('#tampil_form_pkwt #message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
            }
        });
    });

    // BUTTON FORM DELETE
     $(document).on('click','.btn_delete_pkwt',function(){
        event.preventDefault();
        var id_pkwt = $(this).attr('id');
        $("#modal_hapus_pkwt #id_pkwt").val(id_pkwt);
        $("#modal_hapus_pkwt .card-body").show();
        $("#modal_hapus_pkwt .card-footer").show();
        $('#modal_hapus_pkwt').modal('show');
        $(".title").text("Apakah Anda ingin menghapus data ini?");
        $(".btn_hapus_pkwt").removeClass("btn_hapus_pkwt").addClass("btn_hapus_pkwt btn btn-danger");
    });

    // ACTION DELETE
    $(document).on('click','.btn_hapus_pkwt',function(){
        var loading = Ladda.create(this);
        loading.start();
        id_pkwt = $("#modal_hapus_pkwt #id_pkwt").val();
        $.ajax({
            type: 'POST',
            url: "<?= route('pkwt.delete') ?>",
            data: 'id_pkwt='+id_pkwt,
            dataType:'JSON',
            success: function(result){
                loading.stop();
                $('#modal_hapus_pkwt').modal('hide');
                $('#modal_alert_pkwt').modal('show');
                $('#modal_alert_pkwt #icon_success').hide();
                $('#modal_alert_pkwt #icon_fail').show();
                $('#modal_alert_pkwt #keterangan_alert').html("Data Draft PKWT telah berhasil dihapus");
                setTimeout(function() {
                    $('#modal_alert_pkwt').modal('hide');
                }, 3000);
            },
            error:function(){
                loading.stop();
                $("#modal_hapus_pkwt .card-body").hide();
                $("#modal_hapus_pkwt .card-footer").hide();
                $("#modal_hapus_pkwt .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
            }
        });
    });

    // BUTTON ACTION CHEKLIST KIRIM (TABEL)
    $(document).on('click', '.cek_pkwt_kirim', function(event) {
        var checkedItems = [];
        $(".cek_pkwt_kirim:checked").each(function () {
            checkedItems.push($(this).val());
        });

        if(checkedItems.length > 0){
            $(".btn_send_pkwt").prop('disabled', false);
            $(".btn_send_pkwt").removeClass("btn-light text-white").addClass("btn-primary");
        }else{
            $(".btn_send_pkwt").prop('disabled', true);
            $(".btn_send_pkwt").removeClass("btn-primary").addClass("btn-light text-white");
        }
    });

    // BUTTON ACTION CHEKLIST KIRIM (CEK SEMUA)
    $(document).on('click', '.cek_semua', function(event) {
        var isChecked = $(".cek_semua").prop('checked');
        $(".cek_pkwt_kirim").prop('checked', isChecked);

        var checkedItems = [];
        $(".cek_pkwt_kirim:checked").each(function () {
            checkedItems.push($(this).val());
        });

        if(checkedItems.length > 0){
            $(".btn_send_pkwt").prop('disabled', false);
            $(".btn_send_pkwt").removeClass("btn-light text-white").addClass("btn-primary");
        }else{
            $(".btn_send_pkwt").prop('disabled', true);
            $(".btn_send_pkwt").removeClass("btn-primary").addClass("btn-light text-white");
        }
    });

    // BUTTON FORM KIRIM
    $(document).on('click','.btn_send_pkwt',function(){
        event.preventDefault();
        $("#modal_kirim_pkwt .card-body").show();
        $("#modal_kirim_pkwt .card-footer").show();
        $('#modal_kirim_pkwt').modal('show');
        $(".title").text("Apakah Anda ingin mengirim data ini?");
        $(".btn_kirim_pkwt").removeClass("btn_kirim_pkwt").addClass("btn_kirim_pkwt btn btn-primary");
    });

    // ACTION KIRIM SEMUA
    $(document).on('click','.btn_kirim_pkwt', function () {
        var loading = Ladda.create(this);
        loading.start();
        
        var array_kirim = [];
        $(".cek_pkwt_kirim:checked").each(function () {
            array_kirim.push({ id_pkwt: $(this).val(),
                                tgl_pkwt: $(this).attr('data-tglpkwt')
                            })
        })

        var param = {};
        param.array_kirim        =  array_kirim;
        
        $.ajax({
            type: 'POST',
            url: "<?= route('pkwt.kirim.draft') ?>",
            data: param,
            dataType:'JSON',
            success: function(result){
                loading.stop();
                $(".btn_send_pkwt").prop('disabled', true);
                $(".btn_send_pkwt").removeClass("btn-primary").addClass("btn-light text-white");

                $('#modal_kirim_pkwt').modal('hide');
                $('#modal_alert_pkwt').modal('show');
                $('#modal_alert_pkwt #icon_success').show();
                $('#modal_alert_pkwt #icon_fail').hide();
                $('#modal_alert_pkwt #keterangan_alert').html("Data Draft PKWT telah berhasil dikirim");
                setTimeout(function() {
                    $('#modal_alert_pkwt').modal('hide');
                }, 3000);
            },
            error:function(){
                loading.stop();
                $("#modal_kirim_pkwt .card-body").hide();
                $("#modal_kirim_pkwt .card-footer").hide();
                $("#modal_kirim_pkwt .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
            }
        });
    });

    // BUTTON FORM APPROVE PER SATU DATA
    $(document).on('click', '.btn_verifikasi_pkwt', function() {
        event.preventDefault();
        $('#tampil_verifikasi_pkwt').load("<?= route('pkwt.verifikasi.form') ?>"+"/"+$(this).attr('id'), function() {
            $('#modal_verifikasi_pkwt').modal('show');
            $(".title").text("Form Approval PKWT");
        });
    });

    // ACTION APPROVE PER SATU DATA
    $(document).on("click", ".btn_submit_approve", function(e) {
        e.preventDefault();
        $('#message_approval').html("");

        var loading = Ladda.create(this);

        loading.start();

        var status = $("input[name=status]:checked").val();

        var param = new FormData();
        param.append('id', $("#form_input_approval #id").val());  // id_pkwt md5
        param.append('status',status);
        param.append('path_ttd',$("#form_input_approval #path_ttd").val());
        param.append('nm_direktur',$("#form_input_approval #ttd_direktur").val() == null ? "" : $('#ttd_direktur').select2('data')[0].text);
        param.append('tgl_pkwt_mulai',$("#form_input_approval #tgl_pkwt_mulai").val());
        param.append('tgl_pkwt_selesai',$("#form_input_approval #tgl_pkwt_selesai").val());
        param.append('tgl_pkwt_selesai',$("#form_input_approval #tgl_pkwt_selesai").val());
        param.append('no_pkwt',$("#form_input_approval #no_pkwt").val());
        param.append('ket_tolak',$("#form_input_approval #ket_tolak").val());

        $.ajax({
            type: 'POST',
            url: "<?= route('pkwt.verifikasi.approve') ?>",
            data: param,
            dataType: 'JSON',
            contentType: false,
            processData: false,
            cache: false,
            success: function(result) {
                if(result.success == true) {
                    $('#modal_verifikasi_pkwt').modal('hide');
                    $('#modal_alert_pkwt').modal('show');
                    
                    if(status == "4"){
                        $('#modal_alert_pkwt #icon_success').show();
                        $('#modal_alert_pkwt #icon_fail').hide();
                    }else{
                        $('#modal_alert_pkwt #icon_success').hide();
                        $('#modal_alert_pkwt #icon_fail').show();
                    }

                    $('#modal_alert_pkwt #keterangan_alert').html(result.message);
                    setTimeout(function() {
                        $('#modal_alert_pkwt').modal('hide');
                    }, 3000);
                }
                loading.stop();
                $('#modal_verifikasi_pkwt #message').show();
                $('#modal_verifikasi_pkwt #message').html(result.message);
            },
            error: function() {
                loading.stop();
                $('#modal_verifikasi_pkwt #message').show();
                $('#modal_verifikasi_pkwt #message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
            }
        });
    });

    // BUTTON ACTION CHEKLIST VERIFIKASI (TABEL)
    $(document).on('click', '.cek_pkwt_verifikasi', function(event) {
        var checkedItems = [];
        $(".cek_pkwt_verifikasi:checked").each(function () {
            checkedItems.push($(this).val());
        });

        if(checkedItems.length > 0){
            $(".btn_verified_pkwt_all").prop('disabled', false);
            $(".btn_verified_pkwt_all").removeClass("btn-light text-white").addClass("btn-primary");
        }else{
            $(".btn_verified_pkwt_all").prop('disabled', true);
            $(".btn_verified_pkwt_all").removeClass("btn-primary").addClass("btn-light text-white");
        }
    });

    // BUTTON ACTION CHEKLIST VERIFIKASI (CEK SEMUA)
    $(document).on('click', '.verifikasi_semua', function(event) {
        var isChecked = $(".verifikasi_semua").prop('checked');
        $(".cek_pkwt_verifikasi:not(:disabled)").prop('checked', isChecked);

        var checkedItems = [];
        $(".cek_pkwt_verifikasi:checked").each(function () {
            checkedItems.push($(this).val());
        });

        if(checkedItems.length > 0){
            $(".btn_verified_pkwt_all").prop('disabled', false);
            $(".btn_verified_pkwt_all").removeClass("btn-light text-white").addClass("btn-primary");
        }else{
            $(".btn_verified_pkwt_all").prop('disabled', true);
            $(".btn_verified_pkwt_all").removeClass("btn-primary").addClass("btn-light text-white");
        }
    });

    // BUTTON FORM APPROVE SEMUA
    $(document).on('click','.btn_verified_pkwt_all',function(){
        event.preventDefault();
        $('#tampil_verifikasi_semua').load("<?= route('pkwt.verifikasi.form.all') ?>", function() {
            $('#modal_verifikasi_semua').modal('show');
            $(".title").text("Form Approval Semua PKWT");
        });
    });

    // ACTION APPROVE SEMUA
    $(document).on("click", ".btn_submit_approve_all", function(e) {

        e.preventDefault();
        $('#message_approval_semua').html("");

        var loading = Ladda.create(this);

        loading.start();

        var status = $("input[name=verifikasi_all]:checked").val();
        var array_verifikasi = [];
        $(".cek_pkwt_verifikasi:checked").each(function () {
            array_verifikasi.push({ value: $(this).val() });
        })

        var param = new FormData();
        param.append('status',status);
        param.append('array_verifikasi',JSON.stringify(array_verifikasi));
        param.append('path_ttd',$("#form_input_approval_semua #path_ttd").val());
        param.append('nm_direktur',$("#form_input_approval_semua #ttd_direktur").val() == null ? "" : $('#ttd_direktur').select2('data')[0].text);
        param.append('ket_tolak',$("#form_input_approval_semua #ket_tolak").val());

        $.ajax({
            type: 'POST',
            url: "<?= route('pkwt.verifikasi.approve.all') ?>",
            data: param,
            dataType: 'JSON',
            contentType: false,
            processData: false,
            cache: false,
            complete: function(data) {
                reconfigure(data);
            },
            success: function(result) {
                if(result.success == true) {
                    $(".btn_verified_pkwt_all").prop('disabled', true);
                    $(".btn_verified_pkwt_all").removeClass("btn-primary").addClass("btn-light text-white");
                    
                    $('#modal_verifikasi_semua').modal('hide');
                    $('#modal_alert_pkwt').modal('show');
                    
                    if(status == "4"){
                        $('#modal_alert_pkwt #icon_success').show();
                        $('#modal_alert_pkwt #icon_fail').hide();
                    }else{
                        $('#modal_alert_pkwt #icon_success').hide();
                        $('#modal_alert_pkwt #icon_fail').show();
                    }

                    $('#modal_alert_pkwt #keterangan_alert').html(result.message);
                    setTimeout(function() {
                        $('#modal_alert_pkwt').modal('hide');
                    }, 3000);
                }
                loading.stop();
                $('#message_approval_semua').show();
                $('#message_approval_semua').html(result.message);
            },
            error: function() {
                loading.stop();
                $('#message_approval_semua').show();
                $('#message_approval_semua').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
            }
        });
    });
</script>

<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        </li>
                        <li class="breadcrumb-item"><a href="#">PKWT</a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <div class="float-md-right">
                <a href="<?= route('pkwt.import.home') ?>">
                    <button type="button" class="btn_tambah btn btn-biru">
                        <i class="fa fa-plus"></i> Perpanjang PKWT Masal
                    </button>
                </a>
            </div>
        </div>
    </div>
    <hr>
    <div id="kolom_filter">
        <div class="row">
            <div class="col-md-1">
                PERIODE
            </div>
            <div class="col-md-5">
                <div class="form-group">
                    <div class="input-group input-daterange">
                        <input type="text" id="tanggal_mulai" class="form-control masktanggal" autocomplete="off" placeholder="dd-mm-yyyy" value="<?= $periode_awal ?>">
                        <div class="align-self-center">&nbsp;s/d&nbsp;</div>
                        <input type="text" id="tanggal_selesai" class="form-control masktanggal" autocomplete="off" placeholder="dd-mm-yyyy" value="<?= $periode_akhir ?>">
                    </div>
                </div>
            </div>
        </div>
        <?php
            if($level_user != "3") {
        ?>
                <div class="row mb-1">
                    <label class="col-md-1">KARYAWAN</label>
                    <div class="col-md-5">
                        <select class="form-control" name="karyawan" id="karyawan" class="select2 form-control">
                        </select>
                    </div>
                    <div class="col-md-1">
                        <button type="button" id="btn_cari" class="btn btn-primary btn-block ladda-button" data-style="expand-left" value="btn_cari">CARI</button>
                    </div>
                </div>
        <?php
            }
        ?>
        <div class="row mb-1">
            <?php
            if(in_array($level_user, array("1", "4")) || $multi_cabang == true) {
            ?>
                <label class="col-md-1">CABANG</label>
                <div class="col-md-2">
                    <select id="cabang" class="form-control" onchange="onchange_dropdown_cabang()"></select>
                </div>
            <?php } ?>
            <?php
                if (in_array($level_user, array("1", "4", "5")) || $multi_departemen == true) {

                    if(in_array($level_user, array("1", "4"))){
                        $class = "col-md-2";
                    }else if($level_user == "5"){
                        if($multi_cabang == true){
                            $class = "col-md-2";
                        }else{
                            $class = "col-md-5";
                        }
                    }else{
                        $class = "col-md-5";
                    }
            ?>
                <div class="col-lg-1">
                    <label>DEPARTEMEN</label>
                </div>
                <div class="<?= $class ?>">
                    <select id="departemen" class="form-control"></select>
                </div>
                <div class="col-md-1">
                    <button type="button" id="btn_filter" class="ladda-button btn-block btn btn-primary" data-style="expand-left">FILTER</button>
                </div>
            <?php } ?>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="nav-tabs-boxed">
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item"><a href="#" id="tabs_habis_masa_kerja" class="nav-link active" data-toggle="tab" role="tab"><h6>Habis Masa Kerja</h6></a></li>
                    <li class="nav-item"><a href="#" id="tabs_draft_pkwt" class="nav-link" data-toggle="tab" role="tab"><h6>Draft PKWT</h6></a></li>
                    <li class="nav-item"><a href="#" id="tabs_verifikasi" class="nav-link" data-toggle="tab" role="tab"><h6>Verifikasi</h6></a></li>
                </ul>
            </div>
            <div class="row mt-2">
                <div id="tab_content" class="col-md-12"></div>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form_pkwt" class="modal fade in">
    <div class="modal-dialog modal-lg">
        <div id="tampil_form_pkwt" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

<!-- START TAMPIL MODAL -->
<div id="modal_hapus_pkwt" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form_hapus" class="modal-content">
            <input type="hidden" id="id_pkwt">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-7 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-5 text-right">
                        <button class="btn_hapus_pkwt ladda-button" id="btn_hapus_pkwt" data-style="expand-left">HAPUS</button>
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

<!-- START TAMPIL MODAL -->
<div id="modal_kirim_pkwt" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form_kirim" class="modal-content">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-7 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-5 text-right">
                        <button class="btn_kirim_pkwt ladda-button" id="btn_kirim_pkwt" data-style="expand-left">KIRIM</button>
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

<!-- START TAMPIL MODAL -->
<div id="modal_verifikasi_pkwt" class="modal fade in">
    <div class="modal-dialog modal-md modal-dialog-centered">
        <div id="tampil_verifikasi_pkwt" class="modal-content">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-7 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-5 text-right">
                        <button class="btn_verifikasi_pkwt ladda-button" id="btn_kirim_pkwt" data-style="expand-left">SUBMIT</button>
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

<!-- START TAMPIL MODAL -->
<div id="modal_alert_pkwt" class="modal fade in">
    <div class="modal-dialog modal-sm modal-dialog-centered">
        <div id="tampil_alert_pkwt" class="modal-content">
            <div class="card-body text-center">
                <i id="icon_success" class="fa fa-check-circle text-success fa-9x" aria-hidden="true" style="font-size: 9em;"></i>
                <i id="icon_fail" class="fa fa-times-circle text-danger fa-9x" aria-hidden="true" style="font-size: 9em;"></i>
                <p id="keterangan_alert" class="mt-2 font-weight-bold"></p>
                <button class="btn btn-primary mt-2" data-dismiss="modal" style="width: 120px !important;">OK</button>
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL -->


<!-- START TAMPIL MODAL -->
<!-- <div id="modal_verifikasi_semua" class="modal fade in">
    <div class="modal-dialog modal-md modal-dialog-centered">
        <div id="tampil_verifikasi_semua" class="modal-content">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-7 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-5 text-right">
                        <button class="btn_verifikasi_semua ladda-button" id="btn_kirim_pkwt" data-style="expand-left">SUBMIT SEMUA</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div> -->
<!-- END TAMPIL MODAL -->

<!-- START TAMPIL MODAL -->
<div id="modal_verifikasi_semua" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_verifikasi_semua" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->