<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <h4 class="text-primary">KPI Saya</h4>
            <hr class="mb-2">
            <form action="">
                <div class="form-group row">
                    <label for="periode" class="col-sm-1 form-label">Periode</label>
                    <div class="col-sm-2">
                        <input type="text" name="periode" id="periode" class="form-control">
                    </div>
                    <div class="col-sm-1">
                        <button type="button" class="btn btn-primary ladda-button" data-style="expand-left" id="filter" onclick="filterData();">Filter</button>
                    </div>
                </div>
            </form>
            <table id="list_data" class="table table-striped table-bordered">
                <thead>
                    <tr style="font-family: Poppins SemiBold;">
                        <th height=50 width=25% class="_center align-middle">Bulan</th>
                        <th width=25% class="_center align-middle">Aksi</th>
                        <th width=25% class="_center align-middle">Status</th>
                        <th class="_center align-middle" width=25%>Tanggal Pengajuan</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
</div>
<script>
    $(function() {
        $('#periode').datepicker({
            format     : "yyyy",
            minViewMode: 2,
            autoclose  : true,
            orientation: "bottom",
            language   : "id"
        });
        $('#periode').datepicker('setDate', new Date());

        list_data = $('table').DataTable({
            searching: false,
            ordering : false,
            paging   : false,
            info     : false,
            language : {
                url: '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>'
            },
            columnDefs: [
                { targets: '_center', className: "text-center" },
            ],
            processing: true,
            serverSide: true,
            ajax      : {
                url : '<?= route("kpi.saya.list-data") ?>',
                data: function(d) {
                    delete d.columns;
                    delete d.search;
                    
                    d.periode = $('#periode').val();
                }
            }
        });
    });

    function filterData() {
        event.preventDefault();
        var loading = Ladda.create(document.querySelector('#filter'));
        loading.start();
        list_data.ajax.reload(function() {
            loading.stop();
        });
    }
</script>