<style>
    #data_karyawan, #join_termination {
        width: 100% !important;
        height: 100% !important;
        box-sizing: border-box;
    }
</style>

<script type="text/javascript">
    var level_user = '<?= $this->level_user ?>';
    var multi_cabang = '<?= $this->multi_cabang ?>';

    $(function() {
        $(".form_pendidikan #cabang, .form_status #cabang").select2({
            placeholder: '<?= $this->lang->line('semua') ?>',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });

        sessionStorage.clear();


        if(level_user == "1" || level_user == "4" || level_user == "5"){

            // bar data karyawan
            dropdown_dk_cabang();
            dropdown_dk_departemen();
            change_dropdown_dk_cabang();

            // join vs termination
            dropdown_jt_tahun();
            dropdown_jt_cabang();
            change_dropdown_jt_cabang();

            dd_cabang();
        }
    });

    function onchange_cabang(obj) {
        form = $(obj).attr('form');
        jenis = $(obj).attr('jenis');
        id_cabang = $("." + form + " #cabang").val();
        if (jenis == 'pendidikan') {
            getPendidikan(id_cabang);
        } else {
            getStatusKaryawan(id_cabang);
        }
    }

    function detailStatusPegawai(jenis = "") {
        var form = "form_status";

        if (level_user == "1" || level_user == "4" || multi_cabang == "1") {
            var id_cabang = (!$("." + form + " #cabang").val()) ? "all" : $("." + form + " #cabang").val();
        } else {
            var id_cabang = "<?= $this->id_cabang ?>";
        }

        var url = "<?= route('dashboard.kepegawaian.detail.main.status.pegawai') ?>" + "/" + jenis + "/" + id_cabang;
        $('#modal_chart #tampil_form').load(url, function() {
            $('#modal_chart').modal('show');
        });
    }

    function detailPendidikan(jenis = "") {
        var form = "form_pendidikan";

        if (level_user == "1" || level_user == "4" || multi_cabang == "1") {
            var id_cabang = (!$("." + form + " #cabang").val()) ? "all" : $("." + form + " #cabang").val();
        } else {
            var id_cabang = "<?= $this->id_cabang ?>";
        }

        var url = "<?= route('dashboard.kepegawaian.detail.main.pendidikan') ?>" + "/" + jenis + "/" + id_cabang;
        $('#modal_chart #tampil_form').load(url, function() {
            $('#modal_chart').modal('show');
        });
    }

    function getPendidikan(id_cabang = 0) {
        $.ajax({
            type: 'GET',
            dataType: 'JSON',
            url: '<?= route("dashboard.kepegawaian.diagram.pendidikan") ?>' + '/' + id_cabang,
            success: function(data) {
                $("#sd").html(data['sd']);
                $("#smp").html(data['smp']);
                $("#sma").html(data['sma']);
                $("#d3").html(data['d3']);
                $("#d4").html(data['d4']);
                $("#s1").html(data['s1']);
                $("#s2").html(data['s2']);
                $("#s3").html(data['s3']);
                $("#tidak_diketahui").html(data['tidak_diketahui']);
                document.getElementById("chart-pendidikan").innerHTML = "";
                new Morris.Donut({
                    // ID of the element in which to draw the chart.
                    element: 'chart-pendidikan',
                    // Chart data records -- each entry in this array corresponds to a point on
                    // the chart.
                    data: [{
                            label: "<?= $this->lang->line('sd_mi') ?>",
                            value: data['sd']
                        },
                        {
                            label: "<?= $this->lang->line('smp_mts') ?>",
                            value: data['smp']
                        },
                        {
                            label: "<?= $this->lang->line('sma_smk') ?>",
                            value: data['sma']
                        },
                        {
                            label: "<?= $this->lang->line('d3') ?>",
                            value: data['d3']
                        },
                        {
                            label: "<?= $this->lang->line('d4') ?>",
                            value: data['d4']
                        },
                        {
                            label: "<?= $this->lang->line('s1') ?>",
                            value: data['s1']
                        },
                        {
                            label: "<?= $this->lang->line('s2') ?>",
                            value: data['s2']
                        },
                        {
                            label: "<?= $this->lang->line('s3') ?>",
                            value: data['s3']
                        },
                        {
                            label: "<?= $this->lang->line('tidak_diketahui') ?>",
                            value: data['tidak_diketahui']
                        }
                    ],
                    colors: [
                        "#8B0000", //sd
                        "#000080", //smp
                        "#D3D3D3", //sma
                        "#D2691E", //d3
                        "#006400", //d4
                        "#2F4F4F", //s1
                        "#9370DB", //s2
                        "#FFFF00", //s3
                        "#000000" //s3
                    ]
                });
            },
        });
    }

    function getStatusKaryawan(id_cabang = 0) {
        $.ajax({
            type: 'GET',
            dataType: 'JSON',
            url: '<?= route("dashboard.kepegawaian.diagram.status") ?>' + '/' + id_cabang,
            success: function(data) {
                $("#tetap").html(data['tetap']);
                $("#kontrak").html(data['kontrak']);
                $("#resign").html(data['resign']);
                $("#phk").html(data['phk']);
                $("#pensiuan").html(data['pensiuan']);

                document.getElementById("chart-kepegawaian").innerHTML = "";
                new Morris.Donut({
                    // ID of the element in which to draw the chart.
                    element: 'chart-kepegawaian',
                    // Chart data records -- each entry in this array corresponds to a point on
                    // the chart.
                    data: [{
                            label: "<?= $this->lang->line('kontrak') ?>",
                            value: data.kontrak
                        },
                        {
                            label: "<?= $this->lang->line('tetap') ?>",
                            value: data.tetap
                        },
                        // {
                        //     label: "<?= $this->lang->line('resign') ?>",
                        //     value: data.resign
                        // },
                        // {
                        //     label: "<?= $this->lang->line('dikeluarkan') ?>)",
                        //     value: data.phk
                        // },
                        // {
                        //     label: "<?= $this->lang->line('pensiun') ?>",
                        //     value: data.pensiun
                        // }
                    ],
                    colors: [
                        "#F63939", //kontrak
                        "#2883FA", //tetap
                        // "#BA47E4", //Resign
                        // "#FAC800", //PHK
                        // "#A9A9A9", //Pensiun
                    ]
                });
            },
        });
    }

    function save_filter_session() {
        sessionStorage.setItem("back_kepegawaian", "<?= route('dashboard.kepegawaian') ?>");
    }

    // BEGIN DROPDOWN GRAFIK DATA KARYAWAN
    function dropdown_dk_cabang(){
        $("#dk #cabang").select2({
            placeholder: '<?= $this->lang->line('semua')." ".$this->lang->line('cabang') ?>',
            allowClear: true,
            ajax: {
                url: '<?= route("dashboard.absensi.grafik.data.karyawan.dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }

    function change_dropdown_dk_cabang(){
        $("#dk #departemen").val("");
        dropdown_dk_departemen();
    }

    function dropdown_dk_departemen(){
        var level_user = "<?= $this->level_user ?>";
        if (level_user == "1" || level_user == "4" || multi_cabang == "1") {
             var id_cabang = (!$("#dk #cabang").val())? "all":$("#dk #cabang").val();
        } else {
            var id_cabang = "<?= $this->id_cabang ?>";
        }

        $("#dk #departemen").select2({
            placeholder: '<?= $this->lang->line('semua')." ".$this->lang->line('departemen') ?>',
            allowClear: true,
            ajax: {
                url: '<?= route("dashboard.absensi.grafik.data.karyawan.dropdown.departemen") ?>'+'/'+id_cabang,
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            }
        });

        updateGrafikBarDataKaryawan();
    }
    // END DROPDOWN GRAFIK DATA KARYAWAN


    // BEGIN DROPDOWN GRAFIK JOINT VS TERMINATION
    function dropdown_jt_tahun() {
        $("#jt #tahun").select2({
            placeholder: '<?= $this->lang->line('tahun') ?>',
            // allowClear: true,
            minimumResultsForSearch: Infinity,
            ajax: {
                url: '<?= route("dashboard.absensi.grafik.joint.termination.dropdown.tahun") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            }
        });
        }

    function dropdown_jt_cabang(){
        $("#jt #cabang").select2({
            placeholder: '<?= $this->lang->line('semua')." ".$this->lang->line('cabang') ?>',
            allowClear: true,
            ajax: {
                url: '<?= route("dashboard.absensi.grafik.joint.termination.dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }

    function change_dropdown_jt_cabang(){
        $("#jt #departemen").val("");
        var id_cabang = (!$("#jt #cabang").val())? "all":$("#jt #cabang").val();
        $("#jt #departemen").select2({
            placeholder: '<?= $this->lang->line('semua')." ".$this->lang->line('departemen') ?>',
            allowClear: true,
            ajax: {
                url: '<?= route("dashboard.absensi.grafik.joint.termination.dropdown.departemen") ?>'+'/'+id_cabang,
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            }
        });

        updateGrafikBarJoinTermination();
    }

    // END DROPDOWN GRAFIK JOINT VS TERMINATION

    function modalChart(url=""){
        $('#modal_chart #tampil_form').load(url,function(){
            $('#modal_chart').modal('show');
        });
    }
</script>

<div class="row">
    <div class="col-md-7">
        <div class="row">
            <div id="dk" class="col-md-12">
                <div class="card card-rounded" style="height:520px !important">
                    <div class="card-absenku card-header card-info-absenku">
                        <h4 class="card-title"><label><?= $this->lang->line('karyawan') ?></label></h4>
                    </div>
                    <div class="card-content collpase show daftar-pengajuan">
                        <div class="card-body">
                            <div class="row">
                                <?php
                                    if (in_array($this->level_user, ["1", "4"]) || $this->multi_cabang == "1") {
                                ?>
                                        <div class="col-md-6">
                                            <label><?= $this->lang->line('cabang') ?></label>
                                            <select id="cabang" class="form-control" onchange="change_dropdown_dk_cabang()"></select>
                                        </div>
                                <?php
                                    }
                                ?>
                                <div class="col-md-6">
                                    <label><?= $this->lang->line('departemen') ?></label>
                                    <select id="departemen" class="form-control" onchange="updateGrafikBarDataKaryawan()"></select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12" style="height: 370px !important;">
                                    <canvas id="data_karyawan" class="p-1"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div id="jt" class="col-md-12">
                <div class="card card-rounded" style="height:520px !important">
                    <div class="card-absenku card-header card-info-absenku">
                        <h4 class="card-title">Join vs Termination</h4>
                    </div>
                    <div class="card-content collpase show daftar-pengajuan">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-2">
                                    <label><?= $this->lang->line('tahun') ?></label>
                                    <select id="tahun" class="form-control" onchange="updateGrafikBarJoinTermination()">
                                        <option id="<?= date('Y') ?>"><?= date('Y') ?></option>
                                    </select>
                                </div>
                                <div class="col-md-5">
                                    <label><?= $this->lang->line('cabang') ?></label>
                                    <select id="cabang" class="form-control" onchange="change_dropdown_jt_cabang()"></select>
                                </div>
                                <div class="col-md-5">
                                    <label><?= $this->lang->line('departemen') ?></label>
                                    <select id="departemen" class="form-control" onchange="updateGrafikBarJoinTermination()"></select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12" style="height: 370px !important;">
                                    <canvas id="join_termination" class="p-1"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-5">
        <?php
            if (in_array($this->level_user, ["1", "4"])) {
        ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="card card-rounded" style="height:520px !important">
                            <div class="card-absenku card-header">
                                <h4 class="card-title" style="text-transform: initial;"><?= $this->lang->line('title_daftar_karyawan_kontrak_segera_berakhir') ?> <span class="badge badge-primary" id="total_karyawan_kontrak_berakhir">0</span></h4>
                            </div>
                            <div class="card-content collpase show daftar-pengajuan">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-12 col-sm-12" style="height: 370px; overflow-y: auto;">
                                            <?php
                                            $list_karyawan_kontrak_berakhir = [];
                                            foreach ($data_karyawan as $row) {
                                                if (!in_array($row->id_karyawan, $list_karyawan_kontrak_berakhir)) {
                                                    $list_karyawan_kontrak_berakhir[] = $row->id_karyawan;
                                                }
                                            ?>
                                                <div class="card">
                                                    <div class="card-header">
                                                        <div class="row">
                                                            <div class="col-md-6">
                                                                <h4 class="card-title">
                                                                    <i class="fa fa-user-o"></i>
                                                                    <div>
                                                                        <?= $row->nama_lengkap; ?>
                                                                    </div>
                                                                    <small class="block">
                                                                        <?= $row->nik; ?>
                                                                    </small>
                                                                </h4>
                                                            </div>
                                                            <div class="col-md-6 text-right">
                                                                <div class="mt-1">
                                                                    <a href="<?= site_url('master/karyawan/detail') ?>/<?= md5($row->id_karyawan) ?>" class="btn btn-success">Detail</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="card-content collapse show">
                                                        <div class="card-body">
                                                            <?php
                                                            if ($row->jml_hari < 0) {
                                                            ?>
                                                                <p>
                                                                    <small class="badge badge-danger" style="color: white;"><?= $this->lang->line('kontrak_sudah_berakhir') ?></small>
                                                                </p>
                                                            <?php
                                                            } else {
                                                            ?>
                                                                <p>
                                                                    <small class="badge badge-warning" style="color: white;">
                                                                        <?= $this->lang->line('kontrak') ?> <?= $row->jml_hari ?> <?= $this->lang->line('hari_lagi') ?>
                                                                    </small>
                                                                </p>
                                                            <?php
                                                            }
                                                            ?>
                                                            <div class="infotgl">
                                                                <font color="#11c086"><?= $this->lang->line('mulai') ?> :</font> <?= $this->fungsi->format_date_strip($row->tgl_aktif_bekerja); ?> <font color="#fc5656" class="ml-1"> <?= $this->lang->line('berakhir') ?> :</font> <?= $this->fungsi->format_date_strip($row->tgl_berhenti_bekerja); ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php
                                            }
                                            ?>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12 col-sm-12 text-center">
                                            <a href="<?= route('dashboard.kepegawaian.data.kontrak.berakhir'); ?>">
                                                <button type="button" class="btn btn-outline-biru round btn-min-width">
                                                    <?= $this->lang->line('lihat_semua') ?>
                                                </button>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        <?php
            }
        ?>

        <?php
            if (in_array($this->level_user, ["1"])) {
        ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="card card-rounded" style="height:520px !important">
                            <div class="card-absenku card-header">
                                <h4 class="card-title" style="text-transform: initial;"><?= $this->lang->line('title_karyawan_mengajukan_perubahan_data') ?> <span class="badge badge-primary" id="total_karyawan_mengajukan_approval">0</span></h4>
                            </div>
                            <div class="card-content collpase show daftar-pengajuan">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-12 col-sm-12" style="height: 370px; overflow-y: auto;">
                                            <?php
                                            $list_karyawan_mengajukan_approval = [];
                                            foreach ($notif_kepegawaian as $row) {
                                                if (!in_array($row->id_karyawan_pengajuan, $list_karyawan_mengajukan_approval)) {
                                                    $list_karyawan_mengajukan_approval[] = $row->id_karyawan_pengajuan;
                                                }
                                            ?>
                                                <div class="card">
                                                    <div class="card-header">
                                                        <div class="row">
                                                            <div class="col-md-6">
                                                                <h4 class="card-title">
                                                                    <i class="fa fa-user-o"></i>
                                                                    <div>
                                                                        <?= $row->nama_lengkap; ?>
                                                                    </div>
                                                                    <small class="block">
                                                                        <?= $row->nik; ?>
                                                                    </small>
                                                                </h4>
                                                            </div>
                                                            <div class="col-md-6 text-right">
                                                                <div class="mt-1">
                                                                    <a href="<?= route('master.karyawan.detail', ['id' => md5($row->id_karyawan_pengajuan)]) ?>" class="btn btn-success" onclick="save_filter_session();">Detail</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="card-content collapse show">
                                                        <div class="card-body">
                                                            <p>
                                                                <?php foreach ($row->menu as $key => $menu) { ?>
                                                                    <a href="<?= $menu ?>" class="badge badge-primary" style="margin-bottom: 5px;" onclick="save_filter_session();"><?= ucwords($this->lang->line(str_replace(' ', '_', strtolower(keterangan_menu($key))))) ?></a>
                                                                <?php } ?>
                                                            </p>
                                                            <p class="mt-1"><?= $this->lang->line('mengajukan_perubahan_data') ?></p>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php
                                            }
                                            ?>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12 col-sm-12 text-center">
                                            <a href="<?= route('dashboard.kepegawaian.notif'); ?>">
                                                <button type="button" class="btn btn-outline-biru round btn-min-width">
                                                    <?= $this->lang->line('lihat_semua') ?>
                                                </button>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        <?php
        }
        ?>
    </div>
</div>

<div class="row">
    <?php $css = in_array($this->session->userdata('level_user'), array("1", "4")) ? " class='col-md-6' " : "class='col-md-12'"; ?>
    <div <?= $css ?>>
        <div class="card card-rounded" style="height:520px !important">
            <div class="card-absenku card-header card-info-absenku">
                <h4 class="card-title"><?= $this->lang->line('title_kepegawaian_berdasarkan_status') ?></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
            </div>
            <div class="card-content collpase show" style="height: 584px;">
                <div class="card-body">
                    <div class="row form_status">
                        <div class="col-md-6">
                            <div class="form-group row">
                                <div class="col-md-12">
                                    <label><?= $this->lang->line('cabang') ?></label>
                                    <select id="cabang" jenis="status_karyawan" form="form_status" class="form-control" onchange="onchange_cabang(this)"></select>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="row mt-1">
                        <div class="col-md-6">
                            <div id="chart-kepegawaian" style="height: 250px;"></div>
                        </div>
                        <div class="col-md-6">
                            <div>
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Status</th>
                                            <th class="text-center"><?= $this->lang->line('jumlah') ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td><i class="fa fa-stop" style="color: #F63939"></i> <?= $this->lang->line('kontrak') ?></td>
                                            <td class="text-center text-primary cursor-pointer" id="kontrak" onclick="detailStatusPegawai('kontrak')"><?= $status_karyawan["kontrak"] ?></td>
                                        </tr>
                                        <tr>
                                            <td><i class="fa fa-stop" style="color: #2883FA"></i> <?= $this->lang->line('tetap') ?></td>
                                            <td class="text-center text-primary cursor-pointer" id="tetap" onclick="detailStatusPegawai('tetap')"><?= $status_karyawan["tetap"] ?></td>
                                        </tr>
                                        <!-- <tr>
                                            <td><i class="fa fa-stop" style="color: #BA47E4"></i> <?= $this->lang->line('resign') ?></td>
                                            <td class="text-center" id="resign"><?= $status_karyawan["resign"] ?></td>
                                        </tr>
                                        <tr>
                                            <td><i class="fa fa-stop" style="color: #FAC800"></i> <?= $this->lang->line('dikeluarkan') ?></td>
                                            <td class="text-center" id="phk"><?= $status_karyawan["phk"] ?></td>
                                        </tr>
                                        <tr>
                                            <td><i class="fa fa-stop" style="color: #A9A9A9"></i> <?= $this->lang->line('pensiun') ?></td>
                                            <td class="text-center" id="pensiun"><?= $status_karyawan["pensiun"] ?></td>
                                        </tr> -->
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div <?= $css ?>>
        <div class="card card-rounded" style="height:520px !important">
            <div class="card-absenku card-header card-info-absenku">
                <h4 class="card-title"><?= $this->lang->line('title_kepegawaian_berdasarkan_pendidikan') ?></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
            </div>
            <div class="card-content collpase show">
                <div class="card-body" style="height: 655px;">
                    <div class="row form_pendidikan">
                        <div class="col-md-6">
                            <div class="form-group row">
                                <div class="col-md-12">
                                    <label><?= $this->lang->line('cabang') ?></label>
                                    <select id="cabang" jenis="pendidikan" form="form_pendidikan" class="form-control" onchange="onchange_cabang(this)"></select>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="row mt-1">
                        <div class="col-md-6">
                            <div id="chart-pendidikan" style="height: 250px;"></div>
                        </div>
                        <div class="col-md-6" style="height: 310px; overflow-y: auto;">
                            <div>
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th><?= $this->lang->line('pendidikan') ?></th>
                                            <th class="text-center"><?= $this->lang->line('jumlah') ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td><i class="fa fa-stop" style="color: #8B0000"></i> <?= $this->lang->line('sd_mi') ?></td>
                                            <td class="text-center text-primary cursor-pointer" id="sd" onclick="detailPendidikan('sd')"><?= $pendidikan["sd"] ?></td>
                                        </tr>
                                        <tr>
                                            <td><i class="fa fa-stop" style="color: #000080"></i> <?= $this->lang->line('smp_mts') ?></td>
                                            <td class="text-center text-primary cursor-pointer" id="smp" onclick="detailPendidikan('smp')"><?= $pendidikan["smp"] ?></td>
                                        </tr>
                                        <tr>
                                            <td><i class="fa fa-stop" style="color: #D3D3D3"></i> <?= $this->lang->line('sma_smk') ?></td>
                                            <td class="text-center text-primary cursor-pointer" id="sma" onclick="detailPendidikan('sma')"><?= $pendidikan["sma"] ?></td>
                                        </tr>
                                        <tr>
                                            <td><i class="fa fa-stop" style="color: #D2691E"></i> <?= $this->lang->line('d3') ?></td>
                                            <td class="text-center text-primary cursor-pointer" id="d3" onclick="detailPendidikan('d3')"><?= $pendidikan["d3"] ?></td>
                                        </tr>
                                        <tr>
                                            <td><i class="fa fa-stop" style="color: #006400"></i> <?= $this->lang->line('d4') ?></td>
                                            <td class="text-center text-primary cursor-pointer" id="d4" onclick="detailPendidikan('d4')"><?= $pendidikan["d4"] ?></td>
                                        </tr>
                                        <tr>
                                            <td><i class="fa fa-stop" style="color: #2F4F4F"></i> <?= $this->lang->line('s1') ?></td>
                                            <td class="text-center text-primary cursor-pointer" id="s1" onclick="detailPendidikan('s1')"><?= $pendidikan["s1"] ?></td>
                                        </tr>
                                        <tr>
                                            <td><i class="fa fa-stop" style="color: #9370DB"></i> <?= $this->lang->line('s2') ?></td>
                                            <td class="text-center text-primary cursor-pointer" id="s2" onclick="detailPendidikan('s2')"><?= $pendidikan["s2"] ?></td>
                                        </tr>
                                        <tr>
                                            <td><i class="fa fa-stop" style="color: #FFFF00"></i> <?= $this->lang->line('s3') ?></td>
                                            <td class="text-center text-primary cursor-pointer" id="s3" onclick="detailPendidikan('s3')"><?= $pendidikan["s3"] ?></td>
                                        </tr>
                                        <tr>
                                            <td><i class="fa fa-stop" style="color: #000000"></i> Belum Diatur</td>
                                            <td class="text-center text-primary cursor-pointer" id="tidak_diketahui" onclick="detailPendidikan('tidak_diketahui')"><?= $pendidikan["tidak_diketahui"] ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_chart" class="modal fade in">
    <div class="modal-dialog modal-xl">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->


<!-- <script src="<?= base_url('assets/js/home_realtime_date.js') ?>"></script> -->
<script>
    $(function() {
        setInterval(function() {
            var d = new Date();
            var months = <?= $this->lang->line('array_bulan') ?>;
            var days = <?= $this->lang->line('array_hari') ?>;
            var timezone = ["", "", "", "", "", "", "", "WIB", "WITA", "WIT"];
            var gmt = -(d.getTimezoneOffset() / 60);
            var date_time = days[d.getDay()] + ', ' + d.getDate() + ' ' + months[d.getMonth()] + ' ' + d.getFullYear() + ' ' + (d.getHours() < 10 ? '0' : '') + d.getHours() + ':' + (d.getMinutes() < 10 ? '0' : '') + d.getMinutes() + ' ' + timezone[gmt];
            $('.tgls').html(date_time);
        });

        //status_kerja
        new Morris.Donut({
            // ID of the element in which to draw the chart.
            element: 'chart-kepegawaian',
            // Chart data records -- each entry in this array corresponds to a point on
            // the chart.
            data: [{
                    label: "<?= $this->lang->line('kontrak') ?>",
                    value: <?= $status_karyawan["kontrak"] ?>
                },
                {
                    label: "<?= $this->lang->line('tetap') ?>",
                    value: <?= $status_karyawan["tetap"] ?>
                },
                // {
                //     label: "<?= $this->lang->line('resign') ?>",
                //     value: <?= $status_karyawan["resign"] ?>
                // },
                // {
                //     label: "<?= $this->lang->line('dikeluarkan') ?>",
                //     value: <?= $status_karyawan["phk"] ?>
                // },
                // {
                //     label: "<?= $this->lang->line('pensiun') ?>",
                //     value: <?= $status_karyawan["pensiun"] ?>
                // }
            ],
            colors: [
                "#F63939", //kontrak
                "#2883FA", //tetap
                // "#BA47E4", //Resign
                // "#FAC800", //PHK
                // "#A9A9A9", //Pensiun
            ]
        });
        <?php if (in_array($this->level_user, [1, 4])) { ?>
            var total_karyawan_kontrak_berakhir = <?= count($list_karyawan_kontrak_berakhir) ?>;
            $('#total_karyawan_kontrak_berakhir').html(total_karyawan_kontrak_berakhir);
        <?php } ?>
        <?php if ($this->level_user == 1) { ?>
            var total_karyawan_mengajukan_approval = <?= count($list_karyawan_mengajukan_approval) ?>;
            $('#total_karyawan_mengajukan_approval').html(total_karyawan_mengajukan_approval);
        <?php } ?>
    });
</script>

<script type="text/javascript">
    $(function() {
        //pendidikan
        new Morris.Donut({
            // ID of the element in which to draw the chart.
            element: 'chart-pendidikan',
            // Chart data records -- each entry in this array corresponds to a point on
            // the chart.
            data: [{
                    label: "<?= $this->lang->line('sd_mi') ?>",
                    value: <?= $pendidikan['sd']; ?>
                },
                {
                    label: "<?= $this->lang->line('smp_mts') ?>",
                    value: <?= $pendidikan['smp']; ?>
                },
                {
                    label: "<?= $this->lang->line('sma_smk') ?>",
                    value: <?= $pendidikan['sma']; ?>
                },
                {
                    label: "<?= $this->lang->line('d3') ?>",
                    value: <?= $pendidikan['d3']; ?>
                },
                {
                    label: "<?= $this->lang->line('d4') ?>",
                    value: <?= $pendidikan['d4']; ?>
                },
                {
                    label: "<?= $this->lang->line('s1') ?>",
                    value: <?= $pendidikan['s1']; ?>
                },
                {
                    label: "<?= $this->lang->line('s2') ?>",
                    value: <?= $pendidikan['s2']; ?>
                },
                {
                    label: "<?= $this->lang->line('s3') ?>",
                    value: <?= $pendidikan['s3'];; ?>
                },
                {
                    label: "<?= $this->lang->line('tidak_diketahui') ?>",
                    value: <?= $pendidikan['tidak_diketahui']; ?>
                },
            ],
            colors: [
                "#8B0000", //sd
                "#000080", //smp
                "#D3D3D3", //sma
                "#D2691E", //d3
                "#006400", //d4
                "#2F4F4F", //s1
                "#9370DB", //s2
                "#FFFF00", //s3
                "#000000" //s3
            ]
        });
    });
</script>


<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.4.0/Chart.min.js"></script>
<!-- BEGIN GRAFIK BAR DATA KARYAWAN-->
<script>
    var barOptions_dk = {
        pointLabelFontFamily: "Quadon Extra Bold",
        scaleFontFamily: "Quadon Extra Bold",
        tooltips: {
            enabled: false,
        },
        hover: {
            animationDuration: 0,
            onHover: function(e) {
                $("#data_karyawan").css("cursor", e[0] ? "pointer" : "default");
            }
        },
        scales: {

            xAxes: [
                {
                    ticks: {
                        beginAtZero: true,
                        fontFamily: "Poppins SemiBold",
                        fontSize: 11,
                    },
                    scaleLabel: {
                        display: false
                    },
                    gridLines: {
                        display: false,
                        color: "#fff",
                        zeroLineColor: "#fff",
                        zeroLineWidth: 0
                    },
                    stacked: true
                }
            ],
            yAxes: [
                {
                    gridLines: {},
                    ticks: {
                        fontFamily: "Poppins SemiBold",
                        fontSize: 11,
                        beginAtZero: true,
                        userCallback: function(label, index, labels) {
                            // when the floored value is the same as the value we have a whole number
                            if (Math.floor(label) === label) {
                                return label;
                            }
                        },
                        // min: 0, // minimum value
                        // max: 140
                    },
                    stacked: true
                }
            ]
        },
        legend: {
            display: false
        },
        animation: {
            onComplete: function() {
                var chartInstance = this.chart;
                var ctx = chartInstance.ctx;
                ctx.textAlign = "center";
                ctx.font = "12px";
                ctx.fillStyle = "#1C77D4";
                ctx.fontWeight = "bold";
                // ctx.fillStyle = "#fff";

                Chart.helpers.each(
                    this.data.datasets.forEach(function(dataset, i) {
                        var meta = chartInstance.controller.getDatasetMeta(i);
                        Chart.helpers.each(
                            meta.data.forEach(function(bar, index) {
                            data = dataset.data[index];
                                if(i == 0) {
                                    ctx.fillText(data, bar._model.x, bar._model.y - 10);
                                }
                            }),
                            this
                        );
                    }),
                    this
                );
            }
        },
        onClick: (event, item) => {
            var tahun           = chart_dk.getElementAtEvent(event)[0]._view['label'];
            var id_cabang       = (!$("#dk #cabang").val())?"all":$("#dk #cabang").val();
            var id_departemen   = (!$("#dk #departemen").val())?"all":$("#dk #departemen").val();

            var url = "<?= route('dashboard.absensi.grafik.data.karyawan.form') ?>"+"/"+tahun+"/"+id_cabang+"/"+id_departemen;

            return modalChart(url);
        },
    };

    var idDk = document.getElementById("data_karyawan");
    var chart_dk = new Chart(idDk, {
                    type: "bar",
                    data: {
                            labels: [],
                                datasets: [
                                        {
                                            data: [],
                                            backgroundColor: "rgb(11, 98, 164)"
                                        }
                                    ]},
                    options: barOptions_dk
                });

    function updateGrafikBarDataKaryawan(){
        var id_cabang       = (!$("#dk #cabang").val())?"all":$("#dk #cabang").val();
        var id_departemen   = (!$("#dk #departemen").val())?"all":$("#dk #departemen").val();
        $.ajax({
                type: 'GET',
                dataType: 'json',
                url: '<?= route("dashboard.absensi.grafik.data.karyawan.data") ?>'+'/'+id_cabang+'/'+id_departemen,
                success: function (result, textStatus, jqXHR){
                    // max_value =  Math.max.apply(Math,result.data.ttl_karyawan);
                    max_value =  (Math.max.apply(Math,result.data.ttl_karyawan)).toString();
                    satuan = max_value.substring((max_value.length) - 1);
                    // alert(satuan);
                    val_plus = 20 - parseInt(satuan);


                    chart_dk.data.labels = result.data.label;
                    chart_dk.data.datasets[0].data = result.data.ttl_karyawan;
                    chart_dk.options.scales.yAxes[0].ticks.max = Math.max.apply(Math,result.data.ttl_karyawan) + val_plus;
                    chart_dk.update();
                }
            });

    }

</script>
<!-- END GRAFIK BAR DATA KARYAWAN-->

<!-- BEGIN GRAFIK BAR JOIN VS TERMINTAION -->
<script>
    var barOptions_jt = {
        // indexAxis: 'y',
        tooltips: {
            enabled: false,
        },
        legend: {
            display: true,
        },
        hover: {
            animationDuration: 0,
            onHover: function(e) {
                $("#join_termination").css("cursor", e[0] ? "pointer" : "default");
            }
        },



        animation: {
            onComplete: function() {
                var chartInstance = this.chart;
                var ctx = chartInstance.ctx;
                ctx.textAlign = "center";
                ctx.font = "12px";
                // ctx.fillStyle = "#fff";
                ctx.fillStyle = "#1C77D4";

                Chart.helpers.each(
                    this.data.datasets.forEach(function(dataset, i) {
                        var meta = chartInstance.controller.getDatasetMeta(i);
                        Chart.helpers.each(
                            meta.data.forEach(function(bar, index) {
                            data = dataset.data[index];
                                if(i == 0) {
                                    data = Math.abs(data);
                                    if(data != 0){
                                        ctx.fillText(data, bar._model.x, bar._model.y + 5);
                                    }
                                }else{
                                    if(data != 0){
                                        ctx.fillText(data, bar._model.x, bar._model.y - 15);
                                    }
                                }
                            }),
                            this
                        );
                    }),
                    this
                );
            }
        },
        pointLabelFontFamily: "Quadon Extra Bold",
        scaleFontFamily: "Quadon Extra Bold",
        scales: {
            xAxes: [
                {
                    ticks: {
                        beginAtZero: true,
                        fontFamily: "Poppins SemiBold",
                        fontSize: 11,
                    },
                    scaleLabel: {
                        display: false
                    },
                    gridLines: {
                        display: false,
                        color: "#fff",
                        zeroLineColor: "#fff",
                        zeroLineWidth: 0
                    },
                    stacked: true,
                }
            ],
            yAxes: [
                {

                    gridLines: {},
                    ticks: {
                        fontFamily: "Poppins SemiBold",
                        fontSize: 11,
                        beginAtZero: true,
                        userCallback: function(label, index, labels) {
                            // when the floored value is the same as the value we have a whole number
                            if (Math.floor(label) === label) {
                                return label;
                            }

                        },


                        // min: -30, // minimum value
                        // max: 10
                    },
                    stacked: true,
                }
            ]
        },
        onClick: (event, item) => {
            var jenis           = chart_jt.getElementAtEvent(event)[0]._view['datasetLabel']
            var tahun           = $("#jt #tahun").val();
            var bulan           = chart_jt.getElementAtEvent(event)[0]._view['label'];
            var id_cabang       = (!$("#jt #cabang").val())?"all":$("#jt #cabang").val();
            var id_departemen   = (!$("#jt #departemen").val())?"all":$("#jt #departemen").val();

            var url = "<?= route('dashboard.absensi.grafik.joint.termination.form') ?>"+"/"+jenis+"/"+tahun+"/"+bulan+"/"+id_cabang+"/"+id_departemen;

            return modalChart(url)
        },

    };

    var idJt = document.getElementById("join_termination");
    var chart_jt = new Chart(idJt, {
                    type: "bar",
                    data: {
                            labels: [],
                                datasets: [
                                        {
                                            label : "Termination",
                                            data: [],
                                            backgroundColor: "rgb(122, 146, 163)"
                                        },
                                        {
                                            label : "Join",
                                            data: [],
                                            backgroundColor: "rgb(11, 98, 164)"
                                        },
                                    ]},
                    options: barOptions_jt
                });

    function updateGrafikBarJoinTermination(){
        var tahun           = $("#jt #tahun").val();
        var id_cabang       = (!$("#jt #cabang").val())?"all":$("#jt #cabang").val();
        var id_departemen   = (!$("#jt #departemen").val())?"all":$("#jt #departemen").val();
        $.ajax({
                type: 'GET',
                dataType: 'json',
                url: '<?= route("dashboard.absensi.grafik.joint.termination.data") ?>'+'/'+tahun+'/'+id_cabang+'/'+id_departemen,
                success: function (result, textStatus, jqXHR){
                    max_value =  (Math.max.apply(Math,result.data.joint)).toString();
                    max_value = max_value.substring((max_value.length) - 1);
                    max_value = parseInt(max_value);

                    if(max_value < 10){
                        val_plus = 10 - max_value;
                    }else{
                        val_plus = Math.trunc((30/100) * satuan) + 10 ;
                    }


                    chart_jt.data.labels = result.data.label;
                    chart_jt.data.datasets[0].data = result.data.termination;
                    chart_jt.data.datasets[1].data = result.data.joint;
                    chart_jt.options.scales.yAxes[0].ticks.max = Math.max.apply(Math,result.data.joint) + val_plus;
                    chart_jt.update();
                }
            });

    }

    function handleClick(tahun, bulan, id_cabang, id_departemen){
        alert("tahun = "+tahun+", bulan ="+bulan+", id_cabang ="+id_cabang+", id_departemen ="+id_departemen);
    }

</script>
<!-- END GRAFIK BAR JOIN VS TERMINATION -->
