<?php
foreach ($keluarga as $key) {
?>
    <div class="card card-rounded card-abu">
        <div class="card-header">
            <h4 class="card-title" id="heading-labels">
                <i class="fa fa-user-o"></i> Data <?= $key->hub_keluarga ?>
                <div class="row form-detail-karyawan">
                    <div class="col-md-8">&nbsp;</div>
                    <div class="col-md-4 text-right">
                        <a href="#" class="btn btn_edit_keluarga btn-outline-secondary round" id="<?= md5($key->id_keluarga) ?>"> <i id="<?= md5($key->id_keluarga) ?>" class="fa fa-pencil"></i> Edit Data</a>
                        <a href="#" class="btn btn_delete_keluarga btn-outline-secondary round" id="<?= md5($key->id_keluarga) ?>"> <i id="<?= md5($key->id_keluarga) ?>" class="fa fa-trash"></i> <?= ucwords(strtolower($this->lang->line('hapus'))) ?> Data</a>
                    </div>
                </div>
            </h4>
        </div>
        <div class="card-body">
            <div class="row form-detail-karyawan">
                <div class="col-md-12">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('nama_lengkap') ?>
                        </label>
                        <p class="form-control-static">
                            <?= $key->nama ?>
                        </p>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('ttl') ?>
                        </label>
                        <p class="form-control-static">
                            <?= $key->tempat_lahir ?>, <?= $this->fungsi->tgl_indo($key->tanggal_lahir) ?>
                        </p>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('nik') ?>
                        </label>
                        <p class="form-control-static">
                            <?= isset($key->nik) ? $key->nik : '-' ?>
                        </p>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('no_bpjs_kes') ?>
                        </label>
                        <p class="form-control-static">
                            <?= isset($key->no_bpjs) ? $key->no_bpjs : '-' ?>
                        </p>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('no_telp') ?>
                        </label>
                        <p class="form-control-static">
                            <?= $key->telepon ?>
                        </p>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('jenis_kelamin') ?>
                        </label>
                        <p class="form-control-static">
                            <?= $this->fungsi->jkel($key->jenis_kelamin) ?>
                        </p>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('agama') ?>
                        </label>
                        <p class="form-control-static">
                            <?= $key->agama ?>
                        </p>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('pekerjaan') ?>
                        </label>
                        <p class="form-control-static">
                            <?= $key->pekerjaan ?>
                        </p>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('hubungan_keluarga') ?>
                        </label>
                        <p class="form-control-static">
                            <?= $key->hub_keluarga ?>
                        </p>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('tgl_perkawinan') ?>
                        </label>
                        <p class="form-control-static">
                            <?php
                            if ($key->tanggal_perkawinan != '0000-00-00') {
                                if ($this->code_lang == 'id') {
                                    $periode = $this->fungsi->tgl_indo($key->tanggal_perkawinan);
                                } else {
                                    $periode = date('d F Y', strtotime($key->tanggal_perkawinan));
                                }
                            } else {
                                $periode = "-";
                            }

                            echo $periode;
                            ?>
                        </p>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('pendidikan_terakhir') ?>
                        </label>
                        <p class="form-control-static">
                            <?= $key->pendidikan_terakhir ?>
                        </p>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('status_perkawinan') ?>
                        </label>
                        <p class="form-control-static">
                            <?= $key->status_perkawinan ?>
                        </p>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            Status
                        </label>
                        <p class="form-control-static">
                            <?= $key->status ?>
                        </p>
                    </fieldset>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
