<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Bpjs_kes_m extends CI_Model {

	public function __construct(){
		parent::__construct();

        $this->id_company = $this->session->userdata('id_company');
	}

	public function get_config() {
		$this->db->from('payroll_bpjs_kes_comp_p');
		$this->db->where('id_company', $this->session->userdata('id_company'));
		return $this->db->get()->row();
	}

	public function save($flag) {
		$this->db->trans_start();
		$this->save_pengaturan($flag);
		$this->save_master($flag);
		$this->db->trans_complete();
		return $this->db->trans_status();
	}

	private function save_pengaturan($flag) {
		$this->db->set('flag', $flag);
		$this->db->set('user_update', $this->session->userdata('nik').'-'.$this->session->userdata('nama_user'));
		$this->db->set('tgl_update', date('Y-m-d H:i:s'));
		$this->db->where('id_company', $this->session->userdata('id_company'));
		$this->db->update('payroll_bpjs_kes_comp_p');
	}

	private function save_master($flag) {
		if($flag == 1) {
			$this->db->set('tunj_perus_rp', 'ttl_gaji_terdaftar*(tunj_perus_persen/100)', FALSE);
			$this->db->set('pot_kry_rp', 'if(jml_anak > 3, ttl_gaji_terdaftar*(jml_anak-2/100), ttl_gaji_terdaftar*(pot_kry_persen/100))', FALSE); // jika anak lebih dari 3, dihitung tambahan 1% per kepala
		} else {
			$this->db->set('tunj_perus_rp', 0.00);
			$this->db->set('pot_kry_rp', 0.00);
		}
		$this->db->set('flag', $flag);
		$this->db->set('user_update', $this->session->userdata('nik').'-'.$this->session->userdata('nama_user'));
		$this->db->set('tgl_update', date('Y-m-d H:i:s'));
		$this->db->where('id_company', $this->session->userdata('id_company'));
		$this->db->update('payroll_bpjs_kes_m');
	}

	public function cek_data($id_karyawan, $md5 = FALSE) {
		if($md5 == TRUE) {
        	$this->db->where('md5(id_karyawan)', $id_karyawan);
		} else {
        	$this->db->where('id_karyawan', $id_karyawan);
		}
        $this->db->where('id_company', $this->id_company);
        return $this->db->get('payroll_bpjs_kes_m')->num_rows();
    }

    public function get_data($id_karyawan) {
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->get('payroll_bpjs_kes_m')->row();
    }

    public function hitung_bpjs_kes_pot_kry($id_karyawan, $jml_anak) {
    	if($jml_anak > 3) {
    		$this->db->set('pot_kry_rp', "if(flag = '1', cast(ttl_gaji_terdaftar AS DECIMAL(9,2))*((".$jml_anak."-2)/100), 0.00)", FALSE);
    	} else {
    		$this->db->set('pot_kry_rp', "if(flag = '1', cast(ttl_gaji_terdaftar AS DECIMAL(9,2))*(pot_kry_persen/100), 0.00)", FALSE);
    	}
    	$this->db->set('jml_anak', $jml_anak);
    	$this->db->where('md5(id_karyawan)', $id_karyawan);
    	$this->db->where('id_company', $this->id_company);
    	$this->db->set('user_update', $this->session->userdata('nik').'-'.$this->session->userdata('nama_user'));
		$this->db->set('tgl_update', date('Y-m-d H:i:s'));
    	$this->db->update('payroll_bpjs_kes_m');
    }

    public function update_total_pot_kry($id_karyawan) {
    	$sql = "UPDATE payroll_bpjs_kes_m 
    			JOIN payroll_bpjs_tk_m ON payroll_bpjs_kes_m.id_karyawan = payroll_bpjs_tk_m.id_karyawan AND payroll_bpjs_kes_m.id_company = payroll_bpjs_tk_m.id_company 
    			SET ttl_pot_karyawan = IF(payroll_bpjs_kes_m.flag = '1', payroll_bpjs_kes_m.pot_kry_rp, 0)+
    					IF(payroll_bpjs_tk_m.flag_jht = '1', payroll_bpjs_tk_m.pot_jht_kry_rp, 0)+
    					IF(payroll_bpjs_tk_m.flag_jp = '1', payroll_bpjs_tk_m.pot_jp_kry_rp, 0)
    			WHERE md5(payroll_bpjs_kes_m.id_karyawan) = ? and payroll_bpjs_kes_m.id_company = ?";
    	$this->db->query($sql, array($id_karyawan, $this->id_company));
    }

}