<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Data_keluarga_pengajuan extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('karyawan/Data_keluarga_pengajuan_m', 'model');
        $this->load->model('data_keluarga_m');
        $this->load->model('notif_kepegawaian_m', 'notif');
        $this->load->helper('approval');
    }

    public function home($id_karyawan_md5)
    {
        $data['judul']           = $this->lang->line('menu_karyawan');
        $data['aktif']           = 'karyawan';
        $data['tab_karyawan']    = 'keluarga_pengajuan';
        $data['id_karyawan_md5'] = $id_karyawan_md5;
        $data['menu']            = $this->load->view('main_menu', $data, true);
        $data['content']         = $this->load->view('karyawan/menu', $data, true);
        $this->load->view('main_template', $data);
    }

    public function main($id_karyawan_md5 = null)
    {
        $data['id_karyawan_md5'] = $id_karyawan_md5;
        $data['tab_aktif']       = 'pengajuan';
        $data['tab']             = $this->load->view('karyawan/data_keluarga/tab', $data, true);
        $this->load->view('karyawan/data_keluarga/pengajuan/home', $data);
    }

    function form($jenis, $id)
    {
        $data['id'] = $id;
        if ($jenis == 'approve') {
            $this->load->view('karyawan/data_keluarga/pengajuan/form_approve', $data);
        } elseif ($jenis == 'hapus') {
            $this->load->view('karyawan/form_hapus', $data);
        } else {
            $this->load->view('karyawan/data_keluarga/pengajuan/form_revisi', $data);
        }
    }

    public function list_data($id_karyawan = null)
    {
        $data['keluarga'] = $this->model->list_data($id_karyawan);
        $get_data         = $this->model->get_data($id_karyawan)->num_rows();
        if ($get_data > 0) {
            $this->load->view('karyawan/data_keluarga/pengajuan/list_data', $data);
        } else {
            echo $this->lang->line('data_tidak_ditemukan');
        }
    }

    function approve()
    {
        $id = $this->input->get('id');
        $approve = $this->model->approve($id, '2');
        if ($approve) {
            $this->logger->create_log('keluarga_pengajuan', 'approve', $this->db->last_query());
            $cek_id          = $this->model->cek_id($id);
            $data_temp       = $this->model->getDataById($id);
            $id_karyawan_dec = $this->fungsi->decrypt_idkaryawan($data_temp->id_karyawan);
            //mengecek apakah id keluarga tersebut sudah ada atau belum
            if ($cek_id == 0) {
                //belum memiliki id keluarga
                $insert_master = $this->model->insert_master($id);
                if ($insert_master) {
                    $this->model->insert_history($id);
                    $id_history = $this->db->insert_id();
                    notif_approval('detail_data_keluarga', $id_karyawan_dec, ucwords(keterangan_action($this->lang->line('data_keluarga'), $data_temp->action)), $this->lang->line('disetujui'), $id_history);
                    notif_kepegawaian($id_karyawan_dec, 'data_keluarga', $id_history, 'tambah', 'setuju');
                    $this->logger->create_log('keluarga_pengajuan', 'approve insert keluarga', $this->db->last_query());
                    $this->notif->update_flag_baca('data_keluarga', $id_karyawan_dec, $data_temp->id_keluarga);
                }
            } else {
                //sudah memiliki id keluarga
                $insert_history = $this->model->insert_history($id);
                if ($insert_history) {
                    $id_history = $this->db->insert_id();
                    $this->logger->create_log('keluarga_pengajuan', 'approve insert histori', $this->db->last_query());
                    $update_data_diri = $this->model->update_data($id);
                    if ($update_data_diri) {
                        notif_approval('detail_data_keluarga', $id_karyawan_dec, ucwords(keterangan_action($this->lang->line('data_keluarga'), $data_temp->action)), $this->lang->line('disetujui'), $id_history);
                        notif_kepegawaian($id_karyawan_dec, 'data_keluarga', $id_history, 'update', 'setuju');
                        $this->logger->create_log('keluarga_pengajuan', 'approve update data keluarga', $this->db->last_query());
                        $this->notif->update_flag_baca('data_keluarga', $id_karyawan_dec, $data_temp->id_keluarga);
                    }
                }
            }
            $this->model->delete($id);
        }

        __response_approve($approve);
    }

    function hapus()
    {
        $id              = $this->input->get('id');
        $approve         = $this->model->approve($id, '2');
        $data_temp       = $this->model->getDataById($id);
        $id_karyawan_dec = $this->fungsi->decrypt_idkaryawan($data_temp->id_karyawan);
        if ($approve) {
            $this->logger->create_log('keluarga_pengajuan', 'hapus', $this->db->last_query());
            $insert_history = $this->model->insert_history($id);
            $id_history     = $this->db->insert_id();
            $this->model->delete($id);
            notif_approval('detail_data_keluarga', $id_karyawan_dec, ucwords(keterangan_action($this->lang->line('data_keluarga'), $data_temp->action)), $this->lang->line('disetujui'), $id_history);
            notif_kepegawaian($id_karyawan_dec, 'data_keluarga', $id_history, 'hapus', 'setuju');
            $this->notif->update_flag_baca('data_keluarga', $id_karyawan_dec, $data_temp->id_keluarga);
            $hapus_data = $this->model->hapus_data($id);
            if ($hapus_data) {
                $this->logger->create_log('keluarga_pengajuan', 'hapus data keluarga', $this->db->last_query());
            }
            $this->model->delete($id);
        }

        __response_delete($approve);
    }

    function revisi()
    {
        $id                = $this->input->get('id');
        $keterangan        = $this->input->get('keterangan');
        $approve           = $this->model->approve($id, '3', $keterangan);
        $data_temp         = $this->model->getDataById($id);
        $id_karyawan_dec   = $this->fungsi->decrypt_idkaryawan($data_temp->id_karyawan);
        $cek_data_keluarga = $this->model->cek_id($id);
        if ($approve) {
            notif_approval('detail_data_keluarga', $id_karyawan_dec, ucwords(keterangan_action($this->lang->line('data_keluarga'), $data_temp->action)), $this->lang->line('revisi') . ' ' . $keterangan, $data_temp->id_keluarga);
            notif_kepegawaian($id_karyawan_dec, 'data_keluarga', $data_temp->id_keluarga, jenis_revisi($cek_data_keluarga), 'revisi');
            $this->logger->create_log('data_diri_pengajuan', 'revisi', $this->db->last_query());
            $this->notif->update_flag_baca('data_keluarga', $id_karyawan_dec, $data_temp->id_keluarga);
        }
        __response_revisi($approve);
    }
}
