<div class="table-responsive">
    <table id="list_data" class="table table-striped" width="100%">
        <thead>
            <tr>
                <th scope="col" class="w50">NO</th>
                <th scope="col" class="text-left">KODE CABANG</th>
                <th scope="col" class="text-left">NAMA CABANG</th>
                <th scope="col">LOKASI</th>
                <th scope="col" class="w50">RADIUS</th>
                <th scope="col-6" class="w50">AKSI</th>
            </tr>
        </thead>
        <tbody></tbody>
    </table>
</div>
<script type="text/javascript">
    $(function() {
        // reconfigure();
        var list_data = $('#list_data').DataTable({
                    'searching'   : true,
                    'searchDelay' : 1000,
                    'paging'      : true,
                    'lengthChange': true,
                    'ordering'    : true,
                    'info'        : true,
                    'scrollX'     : true,
                    // 'scrollCollapse': true,
                    // 'fixedColumns': true,
                    'language'    :{
                                    'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                    'sEmptyTable' : 'Tidak ada data untuk ditampilkan',
                                    'searchPlaceholder': 'Cabang/radius/lokasi'
                                },
                    "processing"  : true,
                    "serverSide"  : true,
                    "order"       : [],

                    "ajax"        : {
                                        "url": "<?= route('quick-setup.cabang.list_data') ?>",
                                        "type": "POST",
                                        "complete" : function(data){
                                            reconfigure(data);
                                        }
                                    },

                    "aoColumnDefs": [
                                        { "aTargets": [0,4], "bSortable": false }
                                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center'});
                            $('td:eq(1)', nRow).css({'text-align':'center'});
                            $('td:eq(2)', nRow).css({'text-align':'center'});
                            $('td:eq(3)', nRow).css({'text-align':'center'});
                            $('td:eq(4)', nRow).css({'text-align':'center'});
                    }

        });
    });
</script>
