<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Rekap_absensi_m extends CI_Model {
    public function __construct(){
		parent::__construct();

        $this->level_user           = $this->session->userdata('level_user');
        $this->id_company           = $this->session->userdata('id_company');
        $this->multi_cabang         = $this->session->userdata('multi_cabang');
        $this->id_cabang            = $this->session->userdata('id_cabang');
        $this->id_cabang_arr        = $this->session->userdata('id_cabang_arr');
        $this->multi_departemen     = $this->session->userdata('multi_departemen');
        $this->id_departemen        = $this->session->userdata('id_departemen');
        $this->id_departemen_arr    = $this->session->userdata('id_departemen_arr');
        $this->id_karyawan          = $this->session->userdata('id_karyawan');
	}

    function get_datatables($tanggal_mulai, $tanggal_selesai, $cabang, $departemen){
        $limit = false;
        if(!empty($_POST['length']) && $_POST['length'] != -1) {
            $limit = true;
        }
        $query = $this->_get_datatables_query($tanggal_mulai, $tanggal_selesai, $cabang, $departemen, $limit, $groupby=true);
        return $query->result();
    }

    public function count_all($tanggal_mulai, $tanggal_selesai, $cabang, $departemen){
      $this->db->select('id_karyawan');
      $this->db->from('data_karyawan');
      $this->db->where('id_company', $this->id_company);
      if($this->level_user == "7"){
        $this->db->group_start();
        $this->db->where("supervisi", $this->id_karyawan);
        $this->db->or_where("id_karyawan", $this->id_karyawan);
        $this->db->group_end();
      }else if($this->level_user == "3"){
        $this->db->where("id_karyawan", $this->id_karyawan);
      }else{
          if($cabang != "0") {
            $this->db->where("id_cabang", $cabang);
          }else{
              if($this->level_user == "5"){
                  if($this->multi_cabang== true){
                    $this->db->where_in("id_cabang", $this->id_cabang_arr);
                  }else{
                    $this->db->where("id_cabang", $cabang);
                  }
              }else if($this->level_user == "2"){
                $this->db->where("id_cabang", $cabang);
              }
          }

          if($departemen != "0") {
            $this->db->where("id_departemen", $departemen);
          }else{
              if($this->level_user == "2"){
                  if($this->multi_departemen == true){
                    $this->db->where_in("id_departemen", $this->id_departemen_arr);
                  }else{
                      $this->db->where('id_departemen', $this->id_departemen);
                  }
              }
          }
      }
      return $this->db->count_all_results();
    }

    private function _get_datatables_query($tanggal_mulai=0, $tanggal_selesai=0, $id_cabang=0, $id_departemen=0, $limit=false, $groupby=true){

        $date_now = date("Y-m-d");

        $query_binding [] = $tanggal_mulai;
        $query_binding [] = $tanggal_selesai;

        $where_and = "";
        if($this->level_user == "7"){
            $where_and      .= " AND (dk.supervisi = ? or dk.id_karyawan = ?) ";
            $query_binding[] = $this->id_karyawan;
            $query_binding[] = $this->id_karyawan;
        }else if($this->level_user == "3"){
            $where_and      .= " AND dk.id_karyawan = ?";
            $query_binding[] = $this->id_karyawan;
        }else{
            if($id_cabang != "0") {
                $where_and      .= " AND dk.id_cabang = ?";
                $query_binding[] = $id_cabang;
            }else{
                if($this->level_user == "5"){
                    if($this->multi_cabang== true){
                        $where_and      .= " AND dk.id_cabang IN ?";
                        $query_binding[] = $this->id_cabang_arr;
                    }else{
                        $where_and      .= " AND dk.id_cabang = ?";
                        $query_binding[] =$this->id_cabang;
                    }
                }else if($this->level_user == "2"){
                    $where_and      .= " AND dk.id_cabang = ?";
                    $query_binding[] = $this->id_cabang;
                }
            }

            if($id_departemen != "0") {
                $where_and      .= " AND dk.id_departemen = ?";
                $query_binding[] = $id_departemen;
            }else{
                if($this->level_user == "2"){
                    if($this->multi_departemen == true){
                        $where_and      .= " AND dk.id_departemen IN ?";
                        $query_binding[] = $this->id_departemen_arr;
                    }else{
                        $this->db->where('id_departemen', $this->id_departemen);
                        $where_and      .= " AND dk.id_departemen = ?";
                        $query_binding[] = $id_departemen;
                    }
                }
            }
        }


        $where_search = "";
        $where_search_m = "";
        $where_search_r = "";
        $column_search = array('nama_karyawan','nik');

        if($groupby == true){
            $groupby_h = " GROUP BY id_karyawan ";
            $groupby_r = " GROUP BY dk.id_karyawan ";
        }else{
            $groupby_h = " ";
            $groupby_r = " ";
        }
        $i = 0;

        foreach ($column_search as $item){  // looping awal
            if(isset($_POST['search']['value']) && !empty($_POST['search']['value'])){  // jika datatable mengirimkan pencarian dengan metode POST

                if($i===0){ // looping awal
                    if($tanggal_mulai == $date_now || $tanggal_selesai == $date_now){
                        $where_search_m .= " AND (";
                        $where_search_m .= " dk.nama_lengkap LIKE ? ";
                        // $query_binding[] = "%".$_POST['search']['value']."%";

                        $where_search_r .= " AND (";
                        $where_search_r .= " dk.nama_karyawan LIKE ? ";
                        $query_binding[] = "%".$_POST['search']['value']."%";
                    }else{
                        $where_search_r .= " AND (";
                        $where_search_r .= " dk.nama_karyawan LIKE ? ";
                        $query_binding[] = "%".$_POST['search']['value']."%";
                    }
                }
                else{
                    $where_search_m .= " OR dk.nik LIKE ? ";
                    // $query_binding[] = "%".$_POST['search']['value']."%";

                    $where_search_r .= " OR dk.nik LIKE ? ";
                    $query_binding[] = "%".$_POST['search']['value']."%";
                }

                if(count($column_search) - 1 == $i){
                    $where_search_m .= " ) ";
                    $where_search_r .= " ) ";
                }
            }
            $i++;
        }


        if($limit){
            $where_limit = " LIMIT ".$_POST['start'].",".$_POST['length'];
        }else{
            $where_limit = " ";
        }

        if($tanggal_mulai == $date_now || $tanggal_selesai == $date_now){
            $select = "SELECT * FROM (SELECT dk.id_karyawan,
                                                dk.nik,
                                                dk.nama_lengkap as nama_karyawan,
                                                mc.kode as kode_cabang,
                                                mc.nama as nama_cabang,
                                                md.kode as kode_departemen,
                                                md.nama as nama_departemen,
                                                mj.kode_jabatan,
                                                mj.nama as nama_jabatan,
                                                am.kode_absen AS kode_absensi,
                                                am.tgl_absen,
                                                am.jenis_absen,
                                                am.terlambat,
                                                ap.pulang_cepat,
                                                concat(am.id_karyawan,am.tgl_absen) AS key_absensi
                                        FROM absensi_masuk as am
                                        LEFT JOIN absensi_pulang as ap ON ap.id_karyawan = am.id_karyawan AND ap.tgl_absen = am.tgl_absen
                                        JOIN data_karyawan as dk ON dk.id_karyawan = am.id_karyawan
                                        JOIN master_cabang as mc ON mc.id_cabang = dk.id_cabang
                                        JOIN master_departemen as md ON md.id_departemen = dk.id_departemen
                                        JOIN master_jabatan as mj ON mj.id_jabatan = dk.id_jabatan
                                        WHERE am.id_company = '$this->id_company'
                                        AND am.tgl_absen = ? ".
                                        $where_and.
                                        $where_search_m.
                                        " UNION ALL
                                        SELECT dk.id_karyawan,
                                            dk.nik,
                                            dk.nama_karyawan,
                                            dk.kode_cabang,
                                            dk.nama_cabang,
                                            dk.kode_departemen,
                                            dk.nama_departemen,
                                            dk.kode_jabatan,
                                            dk.nama_jabatan,
                                            dk.kode_absensi,
                                            dk.tgl_absen,
                                            dk.jenis_absen,
                                            dk.terlambat,
                                            dk.pulang_cepat,
                                            concat(dk.id_karyawan,dk.tgl_absen) AS key_absensi
                                        FROM r_absensi AS dk
                                        WHERE dk.id_company = '$this->id_company'
                                        AND dk.tgl_absen >= ?
                                        AND dk.tgl_absen <= ? ".
                                        $where_and.
                                        $where_search_r." ) AS u ".
                                $groupby_h.
                                " ORDER BY kode_cabang, kode_departemen, kode_jabatan, nik ASC ".
                                $where_limit;
            # MERGE ARRAY
            $binding = array_merge($query_binding,$query_binding);

            # HAPUS ARRAY PERTAMA
            unset($binding[0]);

            $query = $this->db->query($select,$binding);
        }else{
            $select = "SELECT dk.id_karyawan,
                                dk.nik,
                                dk.nama_karyawan,
                                dk.kode_cabang,
                                dk.nama_cabang,
                                dk.kode_departemen,
                                dk.nama_departemen,
                                dk.kode_jabatan,
                                dk.nama_jabatan,
                                dk.kode_absensi,
                                dk.tgl_absen,
                                dk.jenis_absen,
                                dk.terlambat,
                                dk.pulang_cepat,
                                concat(dk.id_karyawan,dk.tgl_absen) AS key_absensi
                        FROM r_absensi as dk
                        WHERE dk.id_company = '$this->id_company'
                        AND dk.tgl_absen >= ?
                        AND dk.tgl_absen <= ? ".
                        $where_and.
                        $where_search_r.
                        $groupby_r.
                        " ORDER BY dk.kode_cabang, dk.kode_departemen, dk.kode_jabatan, dk.nik ASC ".
                        $where_limit;
            $query = $this->db->query($select,$query_binding);
        }

        return $query;
    }

    public function data_absensi_arr($tanggal_mulai, $tanggal_selesai, $cabang, $departemen){
        $query = $this->_get_datatables_query($tanggal_mulai, $tanggal_selesai, $cabang, $departemen, $limit=false, $groupby=false);
        return $query->result_array();
    }


    function download($tanggal_mulai, $tanggal_selesai, $cabang, $departemen){
        $this->_get_datatables_query($tanggal_mulai, $tanggal_selesai, $cabang, $departemen);
        $query = $this->db->get();
        return $query->result();
    }

    public function getMasterIzin(){
        $this->db->select('kode_izin, nama')
                ->where('id_company', $this->session->userdata('id_company'))
                ->order_by('jenis_izin','ASC')
                ->from('master_jenis_izin');

        $query = $this->db->get();
        return $query->result();
    }

    public function getMasterShift(){
        $this->db->select('kode_shift, nama_shift')
                ->where('id_company', $this->session->userdata('id_company'))
                ->from('master_shift');

        $query = $this->db->get();
        return $query->result();
    }

    public function getNmKode(){
        $nm_kode["H"]   = "Reguler";
        $nm_kode["T"]   = "Terlambat";
        $nm_kode["PC"]  = "Pulang Cepat";
        $nm_kode["TAP"] = "Tidak Absen Pulang";
        $nm_kode["L"]   = "Libur";
        $nm_kode["A"]   = "Alhpa";

        $ms_jenis_izin = $this->getMasterIzin();
        foreach($ms_jenis_izin as $row){
            $nm_kode[$row->kode_izin]   = $row->nama;
        }

        $ms_shift = $this->getMasterShift();
        foreach($ms_shift as $row){
            $nm_kode[$row->kode_shift]   = $row->nama_shift;
        }

        return $nm_kode;

    }

    public function getDataById($id_karyawan=null,$tanggal=null){
        return $this->db->select('nama_karyawan, tgl_absen, absen_masuk, absen_pulang, absen_ist_mulai, absen_ist_selesai, id_karyawan')
                ->where('id_karyawan', $id_karyawan)
                ->where('tgl_absen', $tanggal)
                ->get('r_absensi')->row();
    }

    public function save($kode_absen, $id) {
        $data = array(
            'kode_absen' => $kode_absen
        );
        if($kode_absen == 'A') {
            $data['bkd'] = '1';
        }
        $this->db->where('id_absensi_masuk', $id);
        $update = $this->db->update('absensi_masuk',$data);
        return  __response_update($update);

    }

    function nama_karyawan($id_karyawan) {
        return $this->db->select('nama_lengkap')
                ->where('id_karyawan', $id_karyawan)
                ->get('data_karyawan')->row()->nama_lengkap;
    }

    function nama_cabang($id_cabang) {
        return $this->db->select('nama' )
                        ->where('id_cabang', $id_cabang)
                        ->get('master_cabang')->row()->nama;
    }

    function nama_departemen($id_departemen) {
        return $this->db->select('nama' )
                        ->where('id_departemen', $id_departemen)
                        ->get('master_departemen')->row()->nama;
    }
}
