<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Wizard extends MY_Controller{

  public function __construct()
  {
    parent::__construct();
    //Codeigniter : Write Less Do More
  }

  function index()
  {
    $id_company = $this->session->userdata('id_company');
    $wizard = $this->db->where('id_company', $id_company)->get('wizard')->row();
    if($wizard->data_lokasi == '0') {
      redirect('wizard/lokasi');
    } elseif($wizard->data_lokasi == '1') {
      if($wizard->akun_kedep == '0') {
        redirect(route('wizard.akun.kepala_departemen.home'));
      } elseif($wizard->akun_kedep == '1') {
        if($wizard->akun_staff == '0') {
          redirect(route('wizard.akun.staff.home'));
        } elseif($wizard->akun_staff == '1') {
          if($wizard->tambah_akun == '0') {
            redirect(route('wizard.akun.tambah'));
          } elseif($wizard->tambah_akun == '1') {
            if($wizard->selesai == '0') {
              redirect(route('wizard.berhasil'));
            } elseif($wizard->selesai == '1') {
              redirect('dashboard/absensi');
            }
          }
        }
      }
    }
  }

  function berhasil() {
    $this->update_status_wizard_tambah_akun();
    $this->curl_notifikasi($this->session->userdata('id_company'));
    $this->load->view('wizard/header');
    $this->load->view('wizard/berhasil');
  }

  function curl_notifikasi($id_company) {
    // create a new cURL resource
    $ch = curl_init();

    // set URL and other appropriate options
    curl_setopt($ch, CURLOPT_URL, "https://registrasi.absenku.com/index.php/wizard_notifikasi/index/".$id_company);
    curl_setopt($ch, CURLOPT_HEADER, 0);

    // grab URL and pass it to the browser
    curl_exec($ch);

    // close cURL resource, and free up system resources
    curl_close($ch);
  }

  function dashboard() {
    $this->update_status_wizard_selesai();
    redirect('dashboard/absensi');
  }

  function update_status_wizard_selesai() {
    //update status selesai pada tabel wizard
    $id_company = $this->session->userdata('id_company');
    $this->db->set('selesai','1')->where('id_company', $id_company)->update('wizard');
  }

  function update_status_wizard_tambah_akun() {
    //update status selesai pada tabel wizard
    $id_company = $this->session->userdata('id_company');
    $this->db->set('tambah_akun','1')->where('id_company', $id_company)->update('wizard');
  }
}
